/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearStrategy;

public enum NewYearRule {
    BEGIN_OF_JANUARY{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 1, 1);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            return historicDate.getYearOfEra();
        }
    }
    ,
    BEGIN_OF_MARCH{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 3, 1);
        }
    }
    ,
    BEGIN_OF_SEPTEMBER{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 9, 1);
        }
    }
    ,
    CHRISTMAS_STYLE{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            if (historicEra == HistoricEra.BC) {
                return HistoricDate.of(historicEra, n + 1, 12, 25);
            }
            if (n == 1) {
                return HistoricDate.of(HistoricEra.BC, HistoricEra.BC.yearOfEra(historicEra, 0), 12, 25);
            }
            return HistoricDate.of(historicEra, n - 1, 12, 25);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n = historicDate.getYearOfEra();
            HistoricDate historicDate2 = newYearStrategy.newYear(historicDate.getEra(), n + 1);
            int n2 = n;
            if (historicDate.compareTo(historicDate2) >= 0) {
                ++n2;
            }
            return n2;
        }
    }
    ,
    MARIA_ANUNCIATA{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return HistoricDate.of(historicEra, n, 3, 25);
        }
    }
    ,
    CALCULUS_PISANUS{

        @Override
        HistoricDate newYear(HistoricEra historicEra, int n) {
            return MARIA_ANUNCIATA.newYear(historicEra, n);
        }

        @Override
        int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
            int n = historicDate.getYearOfEra();
            HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n);
            int n2 = n - 1;
            if (historicDate.compareTo(historicDate2) < 0) {
                --n2;
            }
            return n2;
        }
    };


    public NewYearStrategy until(int n) {
        return new NewYearStrategy(this, n);
    }

    abstract HistoricDate newYear(HistoricEra var1, int var2);

    int displayedYear(NewYearStrategy newYearStrategy, HistoricDate historicDate) {
        int n = historicDate.getYearOfEra();
        HistoricDate historicDate2 = this.newYear(historicDate.getEra(), n);
        int n2 = n;
        if (historicDate.compareTo(historicDate2) < 0) {
            --n2;
        }
        return n2;
    }
}

