/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import net.time4j.CalendarUnit;
import net.time4j.DayPeriod;
import net.time4j.GeneralTimestamp;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;
import net.time4j.engine.ValidationElement;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.PluralCategory;
import net.time4j.format.RawValues;
import net.time4j.format.TemporalFormatter;
import net.time4j.format.TextElement;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.CustomizedProcessor;
import net.time4j.format.expert.DecimalProcessor;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.FractionProcessor;
import net.time4j.format.expert.IgnorableWhitespaceProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.LookupProcessor;
import net.time4j.format.expert.NonAmbivalentMap;
import net.time4j.format.expert.NumberProcessor;
import net.time4j.format.expert.OrdinalProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.PatternType;
import net.time4j.format.expert.SignPolicy;
import net.time4j.format.expert.TextProcessor;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.format.expert.TimezoneIDProcessor;
import net.time4j.format.expert.TimezoneNameProcessor;
import net.time4j.format.expert.TimezoneOffsetProcessor;
import net.time4j.format.expert.TwoDigitYearProcessor;
import net.time4j.history.ChronoHistory;
import net.time4j.history.internal.HistoricAttribute;
import net.time4j.history.internal.HistorizedElement;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

public final class ChronoFormatter<T extends ChronoEntity<T>>
implements ChronoPrinter<T>,
ChronoParser<T>,
TemporalFormatter<T> {
    private final Chronology<T> chronology;
    private final OverrideHandler<?> overrideHandler;
    private final AttributeSet globalAttributes;
    private final List<FormatStep> steps;
    private final Map<ChronoElement<?>, Object> defaults;
    private final FractionProcessor fracproc;
    private final boolean hasOptionals;
    private final boolean needsHistorization;
    private final boolean needsExtensions;
    private final int countOfElements;
    private final Leniency leniency;

    private ChronoFormatter(Chronology<T> chronology, Chronology<?> chronology2, Locale locale, List<FormatStep> list) {
        if (chronology == null) {
            throw new NullPointerException("Missing chronology.");
        }
        if (list.isEmpty()) {
            throw new IllegalStateException("No format processors defined.");
        }
        this.chronology = chronology;
        this.overrideHandler = OverrideHandler.of(chronology2);
        this.globalAttributes = AttributeSet.createDefaults(chronology2 == null ? chronology : chronology2, locale);
        this.leniency = this.globalAttributes.get(Attributes.LENIENCY, Leniency.SMART);
        this.defaults = Collections.emptyMap();
        FractionProcessor fractionProcessor = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 0;
        for (FormatStep formatStep : list) {
            ChronoElement<?> chronoElement;
            if (fractionProcessor == null && formatStep.getProcessor() instanceof FractionProcessor) {
                fractionProcessor = (FractionProcessor)FractionProcessor.class.cast(formatStep.getProcessor());
            }
            if (!bl && formatStep.getLevel() > 0) {
                bl = true;
            }
            if ((chronoElement = formatStep.getProcessor().getElement()) == null) continue;
            ++n;
            if (chronoElement instanceof HistorizedElement) {
                bl2 = true;
                continue;
            }
            if (bl3 || !chronoElement.name().endsWith("_DAY_PERIOD")) continue;
            bl3 = true;
        }
        this.fracproc = fractionProcessor;
        this.hasOptionals = bl;
        this.needsHistorization = bl2;
        this.countOfElements = n;
        Class clazz = chronology.getChronoType();
        if (PlainDate.class.isAssignableFrom(clazz)) {
            this.needsExtensions = bl2 || chronology.getExtensions().size() > 2;
        } else if (PlainTime.class.isAssignableFrom(clazz)) {
            this.needsExtensions = bl3 || chronology.getExtensions().size() > 1;
        } else if (PlainTimestamp.class.isAssignableFrom(clazz)) {
            this.needsExtensions = bl3 || bl2 || chronology.getExtensions().size() > 3;
        } else {
            int n2 = chronology.getExtensions().size();
            if (chronology2 != null) {
                n2 += chronology2.getExtensions().size();
            }
            this.needsExtensions = n2 > 0;
        }
        this.steps = this.freeze(list);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, Attributes attributes) {
        this(chronoFormatter, chronoFormatter.globalAttributes.withAttributes(attributes), null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet) {
        this(chronoFormatter, attributeSet, null);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, AttributeSet attributeSet, ChronoHistory chronoHistory) {
        if (attributeSet == null) {
            throw new NullPointerException("Missing global format attributes.");
        }
        this.chronology = chronoFormatter.chronology;
        this.overrideHandler = chronoFormatter.overrideHandler;
        this.globalAttributes = attributeSet;
        this.leniency = this.globalAttributes.get(Attributes.LENIENCY, Leniency.SMART);
        this.defaults = Collections.unmodifiableMap(new NonAmbivalentMap((Map<? extends ChronoElement<?>, ?>)chronoFormatter.defaults));
        this.fracproc = chronoFormatter.fracproc;
        this.hasOptionals = chronoFormatter.hasOptionals;
        this.needsHistorization = chronoFormatter.needsHistorization || chronoHistory != null;
        this.needsExtensions = chronoFormatter.needsExtensions || this.needsHistorization;
        this.countOfElements = chronoFormatter.countOfElements;
        int n = chronoFormatter.steps.size();
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        for (int i = 0; i < n; ++i) {
            FormatStep formatStep = (FormatStep)arrayList.get(i);
            ChronoElement<?> chronoElement = formatStep.getProcessor().getElement();
            if (chronoElement != null && !this.chronology.isRegistered(chronoElement)) {
                block1: for (ChronoExtension chronoExtension : this.chronology.getExtensions()) {
                    if (!chronoExtension.getElements(chronoFormatter.getLocale(), (AttributeQuery)chronoFormatter.globalAttributes).contains(chronoElement)) continue;
                    Set set = chronoExtension.getElements(attributeSet.getLocale(), (AttributeQuery)attributeSet);
                    for (ChronoElement chronoElement2 : set) {
                        if (!chronoElement2.name().equals(chronoElement.name())) continue;
                        if (chronoElement2 == chronoElement) break block1;
                        arrayList.set(i, formatStep.updateElement(chronoElement2));
                        break block1;
                    }
                }
            }
            if (chronoHistory == null) continue;
            Iterator iterator = null;
            if (chronoElement == PlainDate.YEAR) {
                iterator = chronoHistory.yearOfEra();
            } else if (chronoElement == PlainDate.MONTH_OF_YEAR || chronoElement == PlainDate.MONTH_AS_NUMBER) {
                iterator = chronoHistory.month();
            } else if (chronoElement == PlainDate.DAY_OF_MONTH) {
                iterator = chronoHistory.dayOfMonth();
            } else if (chronoElement == PlainDate.DAY_OF_YEAR) {
                iterator = chronoHistory.dayOfYear();
            }
            if (iterator == null) continue;
            arrayList.set(i, formatStep.updateElement((ChronoElement<?>)iterator));
        }
        this.steps = this.freeze(arrayList);
    }

    private ChronoFormatter(ChronoFormatter<T> chronoFormatter, ChronoElement<?> chronoElement, Object object) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        Chronology<?> chronology = chronoFormatter.overrideHandler == null ? null : chronoFormatter.overrideHandler.getCalendarOverride();
        ChronoFormatter.checkElement(chronoFormatter.chronology, chronology, chronoElement);
        this.chronology = chronoFormatter.chronology;
        this.overrideHandler = chronoFormatter.overrideHandler;
        this.globalAttributes = chronoFormatter.globalAttributes;
        this.leniency = chronoFormatter.leniency;
        this.fracproc = chronoFormatter.fracproc;
        this.hasOptionals = chronoFormatter.hasOptionals;
        this.needsHistorization = chronoFormatter.needsHistorization;
        this.needsExtensions = chronoFormatter.needsExtensions;
        this.countOfElements = chronoFormatter.countOfElements;
        NonAmbivalentMap nonAmbivalentMap = new NonAmbivalentMap((Map<? extends ChronoElement<?>, ?>)chronoFormatter.defaults);
        if (object == null) {
            nonAmbivalentMap.remove(chronoElement);
        } else {
            nonAmbivalentMap.put(chronoElement, object);
        }
        this.defaults = Collections.unmodifiableMap(nonAmbivalentMap);
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>(chronoFormatter.steps);
        this.steps = Collections.unmodifiableList(arrayList);
    }

    public Chronology<T> getChronology() {
        return this.chronology;
    }

    public Locale getLocale() {
        return this.globalAttributes.getLocale();
    }

    public AttributeQuery getAttributes() {
        return this.globalAttributes;
    }

    public String format(T t) {
        ChronoDisplay chronoDisplay = this.display(t, this.globalAttributes);
        return this.format0(chronoDisplay);
    }

    public String format(GeneralTimestamp<?> generalTimestamp) {
        return this.format0((ChronoDisplay)generalTimestamp);
    }

    public void formatToBuffer(T t, Appendable appendable) throws IOException {
        this.print(t, appendable, this.globalAttributes);
    }

    public Set<ElementPosition> print(T t, StringBuilder stringBuilder) {
        ChronoDisplay chronoDisplay = this.display(t, this.globalAttributes);
        try {
            return this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    public Set<ElementPosition> print(T t, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        ChronoDisplay chronoDisplay = this.display(t, attributeQuery);
        return this.print(chronoDisplay, appendable, attributeQuery, true);
    }

    @Override
    public <R> R print(T t, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
        ChronoDisplay chronoDisplay = this.display(t, attributeQuery);
        this.print(chronoDisplay, appendable, attributeQuery, false);
        return (R)chronoFunction.apply((Object)chronoDisplay);
    }

    private Set<ElementPosition> print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl) throws IOException {
        if (appendable == null) {
            throw new NullPointerException("Missing text result buffer.");
        }
        LinkedHashSet<ElementPosition> linkedHashSet = null;
        if (bl) {
            linkedHashSet = new LinkedHashSet<ElementPosition>(this.steps.size());
        }
        try {
            int n = this.steps.size();
            for (int i = 0; i < n; ++i) {
                FormatStep formatStep = this.steps.get(i);
                formatStep.print(chronoDisplay, appendable, attributeQuery, linkedHashSet, attributeQuery == this.globalAttributes);
                if (!formatStep.isNewOrBlockStarted()) continue;
                i = formatStep.skipTrailingOrBlocks();
            }
        }
        catch (ChronoException chronoException) {
            throw new IllegalArgumentException("Not formattable: " + chronoDisplay, chronoException);
        }
        if (bl) {
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.emptySet();
    }

    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        T t = this.parse(charSequence, parseLog, this.globalAttributes);
        if (t == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return t;
    }

    public T parse(CharSequence charSequence, ParsePosition parsePosition) {
        return this.parse(charSequence, new ParseLog(parsePosition), this.globalAttributes);
    }

    public T parse(CharSequence charSequence, ParsePosition parsePosition, RawValues rawValues) {
        ParseLog parseLog = new ParseLog(parsePosition);
        T t = this.parse(charSequence, parseLog, this.globalAttributes);
        rawValues.accept(parseLog.getRawValues());
        return t;
    }

    public T parse(CharSequence charSequence, ParseLog parseLog) {
        return this.parse(charSequence, parseLog, this.globalAttributes);
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        ChronoEntity chronoEntity;
        ParsedValues parsedValues;
        Chronology chronology;
        AttributeQuery attributeQuery2 = attributeQuery;
        Leniency leniency = this.leniency;
        if (attributeQuery != this.globalAttributes) {
            attributeQuery2 = new AttributeWrapper(attributeQuery, this.globalAttributes);
            leniency = (Leniency)attributeQuery2.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        }
        if (this.overrideHandler != null) {
            chronology = this.overrideHandler.getExtensions();
            OverrideHandler<?> overrideHandler = this.overrideHandler;
            GeneralTimestamp generalTimestamp = (GeneralTimestamp)ChronoFormatter.parse(this, overrideHandler, (List<ChronoExtension>)chronology, charSequence, parseLog, attributeQuery2, leniency, true);
            parsedValues = parseLog.getRawValues0();
            if (parseLog.isError()) {
                return null;
            }
            TZID tZID = null;
            Moment moment = null;
            if (parsedValues.hasTimezone()) {
                tZID = parsedValues.getTimezone();
            } else if (attributeQuery2.contains(Attributes.TIMEZONE_ID)) {
                tZID = (TZID)attributeQuery2.get(Attributes.TIMEZONE_ID);
            }
            if (tZID != null) {
                StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)overrideHandler.getDefaultStartOfDay());
                if (attributeQuery2.contains(Attributes.TRANSITION_STRATEGY)) {
                    TransitionStrategy transitionStrategy = (TransitionStrategy)attributeQuery2.get(Attributes.TRANSITION_STRATEGY);
                    moment = generalTimestamp.in(Timezone.of((TZID)tZID).with(transitionStrategy), startOfDay);
                } else {
                    moment = generalTimestamp.in(Timezone.of((TZID)tZID), startOfDay);
                }
            }
            if (moment == null) {
                parseLog.setError(charSequence.length(), "Missing timezone or offset.");
                return null;
            }
            ChronoFormatter.updateSelf(parsedValues, Moment.axis().element(), moment);
        } else {
            chronology = this.chronology.preparser();
            if (chronology != null) {
                T t = ChronoFormatter.parse(this, chronology, chronology.getExtensions(), charSequence, parseLog, attributeQuery2, leniency, true);
                parsedValues = parseLog.getRawValues0();
                if (parseLog.isError()) {
                    return null;
                }
                if (chronology instanceof TimeAxis) {
                    ChronoElement chronoElement = ((TimeAxis)TimeAxis.class.cast(chronology)).element();
                    ChronoFormatter.updateSelf(parsedValues, chronoElement, t);
                }
            } else {
                return (T)((ChronoEntity)ChronoFormatter.parse(this, this.chronology, this.chronology.getExtensions(), charSequence, parseLog, attributeQuery2, leniency, false));
            }
        }
        try {
            chronoEntity = this.chronology.createFrom((ChronoEntity)parsedValues, attributeQuery2, leniency.isLax(), false);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(parsedValues));
            return null;
        }
        if (chronoEntity == null) {
            if (!parseLog.isError()) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription(parsedValues));
            }
            return null;
        }
        if (leniency.isStrict()) {
            return (T)ChronoFormatter.checkConsistency(parsedValues, chronoEntity, charSequence, parseLog);
        }
        return (T)chronoEntity;
    }

    public ChronoEntity<?> parseRaw(String string) {
        return this.parseRaw(string, 0);
    }

    public ChronoEntity<?> parseRaw(CharSequence charSequence, int n) {
        ParsedValues parsedValues;
        ParseLog parseLog;
        block5: {
            if (n >= charSequence.length()) {
                return new ParsedValues(0);
            }
            parseLog = new ParseLog(n);
            AttributeSet attributeSet = this.globalAttributes;
            parsedValues = null;
            try {
                parsedValues = this.parseElements(charSequence, parseLog, attributeSet, attributeSet == this.globalAttributes, this.countOfElements);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block5;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parsedValues == null || parseLog.isError()) {
            return new ParsedValues(0);
        }
        for (ChronoElement<?> chronoElement : this.defaults.keySet()) {
            if (parsedValues.contains(chronoElement)) continue;
            parsedValues.put(chronoElement, this.defaults.get(chronoElement));
        }
        return parsedValues;
    }

    public ChronoFormatter<T> with(Locale locale) {
        if (locale.equals(this.globalAttributes.getLocale())) {
            return this;
        }
        return new ChronoFormatter<T>(this, this.globalAttributes.withLocale(locale));
    }

    public ChronoFormatter<T> with(Leniency leniency) {
        return this.with(Attributes.LENIENCY, leniency);
    }

    public ChronoFormatter<T> withAlternativeEraNames() {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(HistoricAttribute.COMMON_ERA, true).set(HistoricAttribute.LATIN_ERA, false).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withLatinEraNames() {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(HistoricAttribute.COMMON_ERA, false).set(HistoricAttribute.LATIN_ERA, true).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withGregorianCutOver(PlainDate plainDate) {
        return this.with(ChronoHistory.ofGregorianReform(plainDate));
    }

    public ChronoFormatter<T> with(ChronoHistory chronoHistory) {
        if (chronoHistory == null) {
            throw new NullPointerException("Missing calendar history.");
        }
        AttributeSet attributeSet = this.globalAttributes.withInternal(HistoricAttribute.CALENDAR_HISTORY, chronoHistory);
        return new ChronoFormatter<T>(this, attributeSet, chronoHistory);
    }

    public ChronoFormatter<T> with(Timezone timezone) {
        if (timezone == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setTimezone(timezone.getID()).build();
        AttributeSet attributeSet = this.globalAttributes.withAttributes(attributes);
        attributeSet = attributeSet.withInternal(Attributes.TRANSITION_STRATEGY, timezone.getStrategy());
        return new ChronoFormatter<T>(this, attributeSet);
    }

    public ChronoFormatter<T> withTimezone(TZID tZID) {
        return this.with(Timezone.of((TZID)tZID));
    }

    public ChronoFormatter<T> withTimezone(String string) {
        return this.with(Timezone.of((String)string));
    }

    public ChronoFormatter<T> withStdTimezone() {
        return this.with(Timezone.ofSystem());
    }

    public ChronoFormatter<T> withCalendarVariant(String string) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setCalendarVariant(string).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> withCalendarVariant(VariantSource variantSource) {
        return this.withCalendarVariant(variantSource.getVariant());
    }

    public ChronoFormatter<T> with(StartOfDay startOfDay) {
        if (startOfDay == null) {
            throw new NullPointerException("Missing start of day.");
        }
        return new ChronoFormatter<T>(this, this.globalAttributes.withInternal(Attributes.START_OF_DAY, startOfDay));
    }

    public <V> ChronoFormatter<T> withDefault(ChronoElement<V> chronoElement, V v) {
        return new ChronoFormatter<T>(this, chronoElement, v);
    }

    public ChronoFormatter<T> with(AttributeKey<Boolean> attributeKey, boolean bl) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, bl).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Integer> attributeKey, int n) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, n).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(AttributeKey<Character> attributeKey, char c) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, c).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public <A extends Enum<A>> ChronoFormatter<T> with(AttributeKey<A> attributeKey, A a) {
        Attributes attributes = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).set(attributeKey, a).build();
        return new ChronoFormatter<T>(this, attributes);
    }

    public ChronoFormatter<T> with(Attributes attributes) {
        Attributes attributes2 = new Attributes.Builder().setAll(this.globalAttributes.getAttributes()).setAll(attributes).build();
        return new ChronoFormatter<T>(this, attributes2);
    }

    public Format toFormat() {
        return new TraditionalFormat(this);
    }

    public static ChronoFormatter<PlainDate> ofDatePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainDate.axis(), locale);
        builder.addPattern(string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainTime> ofTimePattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTime.axis(), locale);
        builder.addPattern(string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampPattern(String string, PatternType patternType, Locale locale) {
        Builder builder = new Builder((Chronology)PlainTimestamp.axis(), locale);
        builder.addPattern(string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<Moment> ofMomentPattern(String string, PatternType patternType, Locale locale, TZID tZID) {
        Builder builder = new Builder((Chronology)Moment.axis(), locale);
        builder.addPattern(string, patternType);
        try {
            return builder.build().withTimezone(tZID);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static <T extends ChronoEntity<T>> ChronoFormatter<T> ofPattern(String string, PatternType patternType, Locale locale, Chronology<T> chronology) {
        Builder builder = new Builder((Chronology)chronology, locale);
        builder.addPattern(string, patternType);
        try {
            return builder.build();
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalArgumentException(illegalStateException);
        }
    }

    public static ChronoFormatter<PlainDate> ofDateStyle(DisplayMode displayMode, Locale locale) {
        String string = CalendarText.patternForDate((DisplayMode)displayMode, (Locale)locale);
        return ChronoFormatter.ofDatePattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<PlainTime> ofTimeStyle(DisplayMode displayMode, Locale locale) {
        String string = CalendarText.patternForTime((DisplayMode)displayMode, (Locale)locale);
        return ChronoFormatter.ofTimePattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<PlainTimestamp> ofTimestampStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        String string = CalendarText.patternForTimestamp((DisplayMode)displayMode, (DisplayMode)displayMode2, (Locale)locale);
        return ChronoFormatter.ofTimestampPattern(string, PatternType.CLDR, locale);
    }

    public static ChronoFormatter<Moment> ofMomentStyle(DisplayMode displayMode, DisplayMode displayMode2, Locale locale, TZID tZID) {
        String string = CalendarText.patternForMoment((DisplayMode)displayMode, (DisplayMode)displayMode2, (Locale)locale);
        return ChronoFormatter.ofMomentPattern(string, PatternType.CLDR, locale, tZID);
    }

    public static <T extends ChronoEntity<T>> ChronoFormatter<T> ofStyle(DisplayStyle displayStyle, Locale locale, Chronology<T> chronology) {
        if (LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) {
            String string = chronology.getFormatPattern(displayStyle, locale);
            Builder builder = new Builder((Chronology)chronology, locale);
            builder.addPattern(string, PatternType.CLDR);
            return builder.build();
        }
        if (chronology.equals((Object)Moment.axis())) {
            throw new UnsupportedOperationException("Timezone required, use 'ofMomentStyle()' instead.");
        }
        throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Class<T> clazz, Locale locale) {
        if (clazz == null) {
            throw new NullPointerException("Missing chronological type.");
        }
        Chronology chronology = Chronology.lookup(clazz);
        if (chronology == null) {
            throw new IllegalArgumentException("Not formattable: " + clazz);
        }
        return new Builder(chronology, locale);
    }

    public static <T extends ChronoEntity<T>> Builder<T> setUp(Chronology<T> chronology, Locale locale) {
        return new Builder((Chronology)chronology, locale);
    }

    public static <C extends CalendarVariant<C>> Builder<Moment> setUpWithOverride(Locale locale, CalendarFamily<C> calendarFamily) {
        if (calendarFamily == null) {
            throw new NullPointerException("Missing override calendar.");
        }
        return new Builder<Moment>((Chronology)Moment.axis(), locale, (Chronology)calendarFamily);
    }

    public static <C extends Calendrical<?, C>> Builder<Moment> setUpWithOverride(Locale locale, Chronology<C> chronology) {
        if (chronology == null) {
            throw new NullPointerException("Missing override calendar.");
        }
        return new Builder<Moment>((Chronology)Moment.axis(), locale, chronology);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoFormatter) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)object;
            return this.chronology.equals(chronoFormatter.chronology) && ChronoFormatter.isEqual(this.overrideHandler, chronoFormatter.overrideHandler) && this.globalAttributes.equals(chronoFormatter.globalAttributes) && this.defaults.equals(chronoFormatter.defaults) && this.steps.equals(chronoFormatter.steps);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.chronology.hashCode() + 31 * this.globalAttributes.hashCode() + 37 * this.steps.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(256);
        stringBuilder.append("net.time4j.format.ChronoFormatter[chronology=");
        stringBuilder.append(this.chronology.getChronoType().getName());
        if (this.overrideHandler != null) {
            stringBuilder.append(", override=");
            stringBuilder.append(this.overrideHandler);
        }
        stringBuilder.append(", default-attributes=");
        stringBuilder.append(this.globalAttributes);
        stringBuilder.append(", default-values=");
        stringBuilder.append(this.defaults);
        stringBuilder.append(", processors=");
        boolean bl = true;
        for (FormatStep formatStep : this.steps) {
            if (bl) {
                bl = false;
                stringBuilder.append('{');
            } else {
                stringBuilder.append('|');
            }
            stringBuilder.append(formatStep);
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private String format0(ChronoDisplay chronoDisplay) {
        StringBuilder stringBuilder = new StringBuilder(this.steps.size() * 8);
        try {
            this.print(chronoDisplay, (Appendable)stringBuilder, (AttributeQuery)this.globalAttributes, false);
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
        return stringBuilder.toString();
    }

    private ChronoDisplay display(T t, AttributeQuery attributeQuery) {
        if (this.overrideHandler == null) {
            return this.chronology.preformat(t, attributeQuery);
        }
        try {
            GeneralTimestamp generalTimestamp;
            Class clazz = this.overrideHandler.getCalendarOverride().getChronoType();
            StartOfDay startOfDay = (StartOfDay)attributeQuery.get(Attributes.START_OF_DAY, (Object)this.overrideHandler.getDefaultStartOfDay());
            Moment moment = (Moment)Moment.class.cast(t);
            TZID tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID);
            if (CalendarVariant.class.isAssignableFrom(clazz)) {
                CalendarFamily calendarFamily = (CalendarFamily)ChronoFormatter.cast(this.overrideHandler.getCalendarOverride());
                String string = (String)attributeQuery.get(Attributes.CALENDAR_VARIANT);
                generalTimestamp = moment.toGeneralTimestamp(calendarFamily, string, tZID, startOfDay);
            } else if (Calendrical.class.isAssignableFrom(clazz)) {
                Chronology<?> chronology = this.overrideHandler.getCalendarOverride();
                generalTimestamp = moment.toGeneralTimestamp(chronology, tZID, startOfDay);
            } else {
                throw new IllegalStateException("Unexpected calendar override: " + clazz);
            }
            return new ZonalDisplay(generalTimestamp, tZID);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Not formattable: " + t, classCastException);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new IllegalArgumentException(noSuchElementException.getMessage(), noSuchElementException);
        }
    }

    private static <T extends ChronoDisplay> T parse(ChronoFormatter<?> chronoFormatter, ChronoMerger<T> chronoMerger, List<ChronoExtension> list, CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Leniency leniency, boolean bl) {
        ChronoDisplay chronoDisplay;
        ParsedValues parsedValues;
        block17: {
            if (parseLog.getPosition() >= charSequence.length()) {
                throw new IndexOutOfBoundsException("[" + parseLog.getPosition() + "]: " + charSequence.toString());
            }
            parsedValues = null;
            boolean bl2 = attributeQuery == chronoFormatter.globalAttributes;
            try {
                parsedValues = super.parseElements(charSequence, parseLog, attributeQuery, bl2, chronoFormatter.countOfElements);
                parsedValues.setNoAmbivalentCheck();
                parseLog.setRawValues(parsedValues);
            }
            catch (AmbivalentValueException ambivalentValueException) {
                if (parseLog.isError()) break block17;
                parseLog.setError(parseLog.getPosition(), ambivalentValueException.getMessage());
            }
        }
        if (parsedValues == null || parseLog.isError()) {
            return null;
        }
        int n = parseLog.getPosition();
        if (n < charSequence.length() && !((Boolean)attributeQuery.get(Attributes.TRAILING_CHARACTERS, (Object)Boolean.FALSE)).booleanValue()) {
            parseLog.setError(n, "Unparsed trailing characters: " + ChronoFormatter.sub(n, charSequence));
            return null;
        }
        if (!chronoFormatter.defaults.isEmpty()) {
            for (ChronoElement<?> chronoExtension : chronoFormatter.defaults.keySet()) {
                if (parsedValues.contains(chronoExtension)) continue;
                parsedValues.put(chronoExtension, chronoFormatter.defaults.get(chronoExtension));
            }
        }
        if (chronoFormatter.needsExtensions) {
            try {
                for (ChronoExtension chronoExtension : list) {
                    parsedValues = (ParsedValues)chronoExtension.resolve((ChronoEntity)parsedValues, chronoFormatter.getLocale(), attributeQuery);
                }
            }
            catch (RuntimeException runtimeException) {
                parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(parsedValues));
                return null;
            }
        }
        try {
            chronoDisplay = (ChronoDisplay)chronoMerger.createFrom((ChronoEntity)parsedValues, attributeQuery, leniency.isLax(), bl);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(charSequence.length(), runtimeException.getMessage() + ChronoFormatter.getDescription(parsedValues));
            return null;
        }
        if (chronoFormatter.fracproc != null && chronoDisplay instanceof ChronoEntity) {
            ChronoEntity chronoEntity = (ChronoEntity)ChronoEntity.class.cast(chronoDisplay);
            chronoDisplay = (ChronoDisplay)ChronoFormatter.cast(chronoFormatter.fracproc.update(chronoEntity, parsedValues));
        }
        if (chronoDisplay == null) {
            if (!bl) {
                parseLog.setError(charSequence.length(), ChronoFormatter.getReason(parsedValues) + ChronoFormatter.getDescription(parsedValues));
            }
            return null;
        }
        if (leniency.isStrict()) {
            return (T)ChronoFormatter.checkConsistency(parsedValues, chronoDisplay, charSequence, parseLog);
        }
        return (T)chronoDisplay;
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }

    private static String getReason(ParsedValues parsedValues) {
        String string;
        if (parsedValues.contains((ChronoElement<?>)ValidationElement.ERROR_MESSAGE)) {
            string = "Validation failed => " + (String)parsedValues.get(ValidationElement.ERROR_MESSAGE);
            parsedValues.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)null);
        } else {
            string = "Insufficient data:";
        }
        return string;
    }

    private static <T> void updateSelf(ParsedValues parsedValues, ChronoElement<T> chronoElement, Object object) {
        parsedValues.with((ChronoElement)chronoElement, chronoElement.getType().cast(object));
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T extends ChronoDisplay> T checkConsistency(ParsedValues parsedValues, T t, CharSequence charSequence, ParseLog parseLog) {
        if (t instanceof UnixTime) {
            TZID tZID;
            UnixTime unixTime = (UnixTime)UnixTime.class.cast(t);
            if (parsedValues.contains(TimezoneElement.TIMEZONE_ID) && parsedValues.contains(TimezoneElement.TIMEZONE_OFFSET)) {
                tZID = parsedValues.get(TimezoneElement.TIMEZONE_ID);
                TZID tZID2 = parsedValues.get(TimezoneElement.TIMEZONE_OFFSET);
                if (!Timezone.of((TZID)tZID).getOffset(unixTime).equals((Object)tZID2)) {
                    parseLog.setError(charSequence.length(), "Ambivalent offset information: " + tZID + " versus " + tZID2);
                    return null;
                }
            }
            if (parseLog.getDSTInfo() == null) return t;
            tZID = parsedValues.getTimezone();
            try {
                boolean bl = Timezone.of((TZID)tZID).isDaylightSaving(unixTime);
                if (bl == parseLog.getDSTInfo()) return t;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Parsed entity is ");
                if (!bl) {
                    stringBuilder.append("not ");
                }
                stringBuilder.append("daylight-saving, but timezone name");
                stringBuilder.append(" has not the appropriate form in {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                t = null;
                return t;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Unable to check timezone name: ");
                stringBuilder.append(illegalArgumentException.getMessage());
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        } else {
            TimePoint timePoint = null;
            if (t instanceof PlainTimestamp && t.getInt((ChronoElement)PlainTime.ISO_HOUR) == 0 && (parsedValues.getInt((ChronoElement<Integer>)PlainTime.ISO_HOUR) == 24 || parsedValues.contains((ChronoElement<?>)PlainTime.COMPONENT) && ((PlainTime)parsedValues.get(PlainTime.COMPONENT)).getHour() == 24)) {
                timePoint = ((PlainTimestamp)PlainTimestamp.class.cast(t)).toDate().minus(1L, (Object)CalendarUnit.DAYS);
            }
            for (ChronoElement<?> chronoElement : parsedValues.getRegisteredElements()) {
                void var8_15;
                Object obj = parsedValues.get(chronoElement);
                T t2 = t;
                if (timePoint != null) {
                    if (chronoElement.isDateElement()) {
                        TimePoint timePoint2 = timePoint;
                    } else if (chronoElement.isTimeElement()) {
                        PlainTime plainTime = PlainTime.midnightAtEndOfDay();
                    }
                }
                if (!var8_15.contains(chronoElement) || var8_15.get(chronoElement).equals(obj)) continue;
                StringBuilder stringBuilder = new StringBuilder(256);
                stringBuilder.append("Conflict found: ");
                stringBuilder.append("Text {");
                stringBuilder.append(charSequence.toString());
                stringBuilder.append("} with element ");
                stringBuilder.append(chronoElement.name());
                stringBuilder.append(" {");
                stringBuilder.append(obj);
                stringBuilder.append("}, but parsed entity ");
                stringBuilder.append("has element value {");
                stringBuilder.append(var8_15.get(chronoElement));
                stringBuilder.append("}.");
                parseLog.setError(charSequence.length(), stringBuilder.toString());
                return null;
            }
        }
        return t;
    }

    private ParsedValues parseElements(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, boolean bl, int n) {
        ParsedValues parsedValues = new ParsedValues(n);
        parsedValues.setPosition(parseLog.getPosition());
        LinkedList<ParsedValues> linkedList = null;
        if (this.hasOptionals) {
            linkedList = new LinkedList<ParsedValues>();
            linkedList.push(parsedValues);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = this.steps.size();
        for (int i = 0; i < n4; ++i) {
            ChronoElement<?> chronoElement;
            int n5;
            ParsedValues parsedValues2;
            FormatStep formatStep = this.steps.get(i);
            if (linkedList == null) {
                parsedValues2 = parsedValues;
            } else {
                for (n5 = n3 = formatStep.getLevel(); n5 > n2; --n5) {
                    parsedValues = new ParsedValues(n >>> 1);
                    parsedValues.setPosition(parseLog.getPosition());
                    linkedList.push(parsedValues);
                }
                while (n5 < n2) {
                    parsedValues = (ParsedValues)((Object)linkedList.pop());
                    ((ParsedValues)((Object)linkedList.peek())).putAll(parsedValues);
                    ++n5;
                }
                parsedValues2 = (ParsedValues)((Object)linkedList.peek());
            }
            parseLog.clearWarning();
            formatStep.parse(charSequence, parseLog, attributeQuery, parsedValues2, bl);
            if (parseLog.isWarning() && (chronoElement = formatStep.getProcessor().getElement()) != null && this.defaults.containsKey(chronoElement)) {
                parsedValues2.put(chronoElement, this.defaults.get(chronoElement));
                parsedValues2.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)null);
                parseLog.clearError();
                parseLog.clearWarning();
            }
            if (parseLog.isError()) {
                int n6;
                n5 = formatStep.getSection();
                int n7 = i;
                for (n6 = i + 1; n6 < n4; ++n6) {
                    FormatStep formatStep2 = this.steps.get(n6);
                    if (!formatStep2.isNewOrBlockStarted() || formatStep2.getSection() != n5) continue;
                    n7 = n6;
                    break;
                }
                if (n7 > i) {
                    if (linkedList != null) {
                        parsedValues = (ParsedValues)((Object)linkedList.pop());
                    }
                    parseLog.clearError();
                    parseLog.setPosition(parsedValues.getPosition());
                    parsedValues.reset();
                    if (linkedList != null) {
                        linkedList.push(parsedValues);
                    }
                    i = n7;
                } else {
                    if (n3 == 0) {
                        if (linkedList != null) {
                            parsedValues = (ParsedValues)((Object)linkedList.peek());
                        }
                        return parsedValues;
                    }
                    for (n6 = n4 - 1; n6 > i; --n6) {
                        if (this.steps.get(n6).getSection() != n5) continue;
                        n7 = n6;
                        break;
                    }
                    i = n7;
                    --n3;
                    assert (linkedList != null);
                    parsedValues = (ParsedValues)((Object)linkedList.pop());
                    parseLog.clearError();
                    parseLog.setPosition(parsedValues.getPosition());
                }
            } else if (formatStep.isNewOrBlockStarted()) {
                i = formatStep.skipTrailingOrBlocks();
            }
            n2 = n3;
        }
        while (n3 > 0) {
            assert (linkedList != null);
            parsedValues = (ParsedValues)((Object)linkedList.pop());
            ((ParsedValues)((Object)linkedList.peek())).putAll(parsedValues);
            --n3;
        }
        if (linkedList != null) {
            parsedValues = (ParsedValues)((Object)linkedList.peek());
        }
        return parsedValues;
    }

    private static String sub(int n, CharSequence charSequence) {
        int n2 = charSequence.length();
        if (n2 - n <= 10) {
            return charSequence.subSequence(n, n2).toString();
        }
        return charSequence.subSequence(n, n + 10).toString() + "...";
    }

    private static String getDescription(ParsedValues parsedValues) {
        StringBuilder stringBuilder = new StringBuilder(parsedValues.size() * 16);
        stringBuilder.append(" [parsed={");
        boolean bl = true;
        for (ChronoElement<?> chronoElement : parsedValues.getRegisteredElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(parsedValues.get(chronoElement));
        }
        stringBuilder.append("}]");
        return stringBuilder.toString();
    }

    private static void checkElement(Chronology<?> chronology, Chronology<?> chronology2, ChronoElement<?> chronoElement) {
        boolean bl = chronology.isSupported(chronoElement);
        if (!bl) {
            if (chronology2 == null) {
                Chronology chronology3 = chronology.preparser();
                bl = chronology3 != null && chronology3.isSupported(chronoElement);
            } else {
                boolean bl2 = bl = chronoElement.isDateElement() && chronology2.isSupported(chronoElement) || chronoElement.isTimeElement() && PlainTime.axis().isSupported(chronoElement);
            }
            if (!bl) {
                throw new IllegalArgumentException("Unsupported element: " + chronoElement.name());
            }
        }
    }

    private List<FormatStep> freeze(List<FormatStep> list) {
        ArrayList<FormatStep> arrayList = new ArrayList<FormatStep>();
        for (FormatStep formatStep : list) {
            arrayList.add(formatStep.quickPath(this));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static class ZonalDisplay
    implements ChronoDisplay {
        private final GeneralTimestamp<?> tsp;
        private final TZID tzid;

        private ZonalDisplay(GeneralTimestamp<?> generalTimestamp, TZID tZID) {
            this.tsp = generalTimestamp;
            this.tzid = tZID;
        }

        public boolean contains(ChronoElement<?> chronoElement) {
            return this.tsp.contains(chronoElement);
        }

        public <V> V get(ChronoElement<V> chronoElement) {
            return (V)this.tsp.get(chronoElement);
        }

        public int getInt(ChronoElement<Integer> chronoElement) {
            return this.tsp.getInt(chronoElement);
        }

        public <V> V getMinimum(ChronoElement<V> chronoElement) {
            return (V)this.tsp.getMinimum(chronoElement);
        }

        public <V> V getMaximum(ChronoElement<V> chronoElement) {
            return (V)this.tsp.getMaximum(chronoElement);
        }

        public boolean hasTimezone() {
            return true;
        }

        public TZID getTimezone() {
            return this.tzid;
        }
    }

    private static class OverrideHandler<C extends ChronoEntity<C>>
    implements ChronoMerger<GeneralTimestamp<C>> {
        private final Chronology<C> override;
        private final List<ChronoExtension> extensions;

        private OverrideHandler(Chronology<C> chronology) {
            this.override = chronology;
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.override.getExtensions());
            arrayList.addAll(PlainTime.axis().getExtensions());
            this.extensions = Collections.unmodifiableList(arrayList);
        }

        static <C extends ChronoEntity<C>> OverrideHandler<C> of(Chronology<C> chronology) {
            if (chronology == null) {
                return null;
            }
            return new OverrideHandler<C>(chronology);
        }

        @Deprecated
        public GeneralTimestamp<C> createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom(chronoEntity, attributeQuery, bl2, bl);
        }

        public GeneralTimestamp<C> createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            GeneralTimestamp generalTimestamp;
            ChronoEntity chronoEntity2 = this.override.createFrom(chronoEntity, attributeQuery, bl, bl2);
            PlainTime plainTime = (PlainTime)PlainTime.axis().createFrom(chronoEntity, attributeQuery, bl, bl2);
            if (chronoEntity2 instanceof CalendarVariant) {
                generalTimestamp = GeneralTimestamp.of((CalendarVariant)((CalendarVariant)CalendarVariant.class.cast(chronoEntity2)), (PlainTime)plainTime);
            } else if (chronoEntity2 instanceof Calendrical) {
                generalTimestamp = GeneralTimestamp.of((Calendrical)((Calendrical)Calendrical.class.cast(chronoEntity2)), (PlainTime)plainTime);
            } else {
                throw new IllegalStateException("Cannot determine calendar type: " + chronoEntity2);
            }
            return (GeneralTimestamp)ChronoFormatter.cast(generalTimestamp);
        }

        public StartOfDay getDefaultStartOfDay() {
            return this.override.getDefaultStartOfDay();
        }

        public List<ChronoExtension> getExtensions() {
            return this.extensions;
        }

        public Chronology<?> getCalendarOverride() {
            return this.override;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof OverrideHandler) {
                OverrideHandler overrideHandler = (OverrideHandler)object;
                return this.override.equals(overrideHandler.override);
            }
            return false;
        }

        public int hashCode() {
            return this.override.hashCode();
        }

        public String toString() {
            return this.override.getChronoType().getName();
        }

        public ChronoDisplay preformat(GeneralTimestamp<C> generalTimestamp, AttributeQuery attributeQuery) {
            throw new UnsupportedOperationException("Not used.");
        }

        public Chronology<?> preparser() {
            throw new UnsupportedOperationException("Not used.");
        }

        public GeneralTimestamp<C> createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            throw new UnsupportedOperationException("Not used.");
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            throw new UnsupportedOperationException("Not used.");
        }
    }

    private static class AttributeWrapper
    implements AttributeQuery {
        private final AttributeQuery attributes;
        private final AttributeSet globals;

        AttributeWrapper(AttributeQuery attributeQuery, AttributeSet attributeSet) {
            this.attributes = attributeQuery;
            this.globals = attributeSet;
        }

        public boolean contains(AttributeKey<?> attributeKey) {
            return this.attributes.contains(attributeKey) || this.globals.contains(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey) {
            if (this.attributes.contains(attributeKey)) {
                return (A)this.attributes.get(attributeKey);
            }
            return this.globals.get(attributeKey);
        }

        public <A> A get(AttributeKey<A> attributeKey, A a) {
            if (this.attributes.contains(attributeKey)) {
                return (A)this.attributes.get(attributeKey);
            }
            return this.globals.get(attributeKey, a);
        }
    }

    private static class TraditionalFormat<T extends ChronoEntity<T>>
    extends Format {
        private static final Map<String, DateFormat.Field> FIELD_MAP;
        private final ChronoFormatter<T> formatter;

        TraditionalFormat(ChronoFormatter<T> chronoFormatter) {
            this.formatter = chronoFormatter;
        }

        @Override
        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            fieldPosition.setBeginIndex(0);
            fieldPosition.setEndIndex(0);
            try {
                AttributeSet attributeSet = ((ChronoFormatter)this.formatter).globalAttributes;
                String string = (String)attributeSet.get(Attributes.CALENDAR_TYPE, "iso8601");
                ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuffer, attributeSet);
                if (string.equals("iso8601")) {
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null || !(field.equals(fieldPosition.getFieldAttribute()) || field.getCalendarField() == fieldPosition.getField() && fieldPosition.getField() != -1 || field.equals(DateFormat.Field.TIME_ZONE) && fieldPosition.getField() == 17 || field.equals(DateFormat.Field.HOUR_OF_DAY1) && fieldPosition.getField() == 4) && (!field.equals(DateFormat.Field.HOUR1) || fieldPosition.getField() != 15)) continue;
                        fieldPosition.setBeginIndex(elementPosition.getStartIndex());
                        fieldPosition.setEndIndex(elementPosition.getEndIndex());
                        break;
                    }
                }
                return stringBuffer;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Not formattable: " + object, classCastException);
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("Cannot print object: " + object, iOException);
            }
        }

        @Override
        public AttributedCharacterIterator formatToCharacterIterator(Object object) {
            String string = ((ChronoFormatter)this.formatter).globalAttributes.get(Attributes.CALENDAR_TYPE, "iso8601");
            if (string.equals("iso8601")) {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    ChronoEntity chronoEntity = (ChronoEntity)this.formatter.getChronology().getChronoType().cast(object);
                    Set<ElementPosition> set = this.formatter.print(chronoEntity, stringBuilder);
                    AttributedString attributedString = new AttributedString(stringBuilder.toString());
                    for (ElementPosition elementPosition : set) {
                        DateFormat.Field field = TraditionalFormat.toField(elementPosition.getElement());
                        if (field == null) continue;
                        attributedString.addAttribute(field, field, elementPosition.getStartIndex(), elementPosition.getEndIndex());
                    }
                    return attributedString.getIterator();
                }
                catch (ClassCastException classCastException) {
                    throw new IllegalArgumentException("Not formattable: " + object, classCastException);
                }
            }
            return super.formatToCharacterIterator(object);
        }

        @Override
        public Object parseObject(String string, ParsePosition parsePosition) {
            ParseLog parseLog = new ParseLog(parsePosition.getIndex());
            T t = this.formatter.parse((CharSequence)string, parseLog);
            if (t == null) {
                parsePosition.setErrorIndex(parseLog.getErrorIndex());
            } else {
                parsePosition.setIndex(parseLog.getPosition());
            }
            return t;
        }

        private static DateFormat.Field toField(ChronoElement<?> chronoElement) {
            return FIELD_MAP.get(chronoElement.name());
        }

        static {
            HashMap<String, DateFormat.Field> hashMap = new HashMap<String, DateFormat.Field>();
            hashMap.put("YEAR", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_ERA", DateFormat.Field.YEAR);
            hashMap.put("YEAR_OF_WEEKDATE", DateFormat.Field.YEAR);
            hashMap.put("WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("BOUNDED_WEEK_OF_YEAR", DateFormat.Field.WEEK_OF_YEAR);
            hashMap.put("BOUNDED_WEEK_OF_MONTH", DateFormat.Field.WEEK_OF_MONTH);
            hashMap.put("MONTH_OF_YEAR", DateFormat.Field.MONTH);
            hashMap.put("MONTH_AS_NUMBER", DateFormat.Field.MONTH);
            hashMap.put("HISTORIC_MONTH", DateFormat.Field.MONTH);
            hashMap.put("WEEKDAY_IN_MONTH", DateFormat.Field.DAY_OF_WEEK_IN_MONTH);
            hashMap.put("SECOND_OF_MINUTE", DateFormat.Field.SECOND);
            hashMap.put("MINUTE_OF_HOUR", DateFormat.Field.MINUTE);
            hashMap.put("MILLI_OF_SECOND", DateFormat.Field.MILLISECOND);
            hashMap.put("DIGITAL_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY0);
            hashMap.put("DIGITAL_HOUR_OF_AMPM", DateFormat.Field.HOUR0);
            hashMap.put("CLOCK_HOUR_OF_DAY", DateFormat.Field.HOUR_OF_DAY1);
            hashMap.put("CLOCK_HOUR_OF_AMPM", DateFormat.Field.HOUR1);
            hashMap.put("AM_PM_OF_DAY", DateFormat.Field.AM_PM);
            hashMap.put("DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("HISTORIC_DAY_OF_MONTH", DateFormat.Field.DAY_OF_MONTH);
            hashMap.put("DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("LOCAL_DAY_OF_WEEK", DateFormat.Field.DAY_OF_WEEK);
            hashMap.put("DAY_OF_YEAR", DateFormat.Field.DAY_OF_YEAR);
            hashMap.put("TIMEZONE_ID", DateFormat.Field.TIME_ZONE);
            hashMap.put("ERA", DateFormat.Field.ERA);
            FIELD_MAP = Collections.unmodifiableMap(hashMap);
        }
    }

    public static final class Builder<T extends ChronoEntity<T>> {
        private static final AttributeKey<DayPeriod> CUSTOM_DAY_PERIOD = Attributes.createKey((String)"CUSTOM_DAY_PERIOD", DayPeriod.class);
        private final Chronology<T> chronology;
        private final Chronology<?> override;
        private final Locale locale;
        private List<FormatStep> steps;
        private LinkedList<AttributeSet> stack;
        private int sectionID;
        private int reservedIndex;
        private int leftPadWidth;
        private DayPeriod dayPeriod;

        private Builder(Chronology<T> chronology, Locale locale) {
            this(chronology, locale, (Chronology<?>)null);
        }

        private Builder(Chronology<T> chronology, Locale locale, Chronology<?> chronology2) {
            if (chronology == null) {
                throw new NullPointerException("Missing chronology.");
            }
            if (locale == null) {
                throw new NullPointerException("Missing locale.");
            }
            this.chronology = chronology;
            this.override = chronology2;
            this.locale = locale;
            this.steps = new ArrayList<FormatStep>();
            this.stack = new LinkedList();
            this.sectionID = 0;
            this.reservedIndex = -1;
            this.leftPadWidth = 0;
            this.dayPeriod = null;
        }

        public Chronology<?> getChronology() {
            return this.override == null ? this.chronology : this.override;
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addInteger(ChronoElement<Integer> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addLongNumber(ChronoElement<Long> chronoElement, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, false, n, n2, signPolicy);
        }

        public Builder<T> addFixedInteger(ChronoElement<Integer> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addNumerical(ChronoElement<V> chronoElement, int n, int n2) {
            return this.addNumber(chronoElement, false, n, n2, SignPolicy.SHOW_NEVER);
        }

        public <V extends Enum<V>> Builder<T> addFixedNumerical(ChronoElement<V> chronoElement, int n) {
            return this.addNumber(chronoElement, true, n, n, SignPolicy.SHOW_NEVER);
        }

        public Builder<T> addFraction(ChronoElement<Integer> chronoElement, int n, int n2, boolean bl) {
            this.checkElement(chronoElement);
            boolean bl2 = !bl && n == n2;
            this.ensureOnlyOneFractional(bl2, bl);
            FractionProcessor fractionProcessor = new FractionProcessor(chronoElement, n, n2, bl);
            if (this.reservedIndex != -1 && bl2) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(fractionProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n));
                }
            } else {
                this.addProcessor(fractionProcessor);
            }
            return this;
        }

        public Builder<T> addFixedDecimal(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
            this.checkElement(chronoElement);
            this.ensureDecimalDigitsOnlyOnce();
            DecimalProcessor decimalProcessor = new DecimalProcessor(chronoElement, n, n2);
            if (this.reservedIndex != -1) {
                int n3 = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n3);
                this.addProcessor(decimalProcessor);
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n3;
                    this.steps.set(n3, formatStep.reserve(n - n2));
                }
            } else {
                this.addProcessor(decimalProcessor);
            }
            return this;
        }

        public Builder<T> addEnglishOrdinal(ChronoElement<Integer> chronoElement) {
            return this.addOrdinalProcessor(chronoElement, null);
        }

        public Builder<T> addOrdinal(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            if (map == null) {
                throw new NullPointerException("Missing ordinal indicators.");
            }
            return this.addOrdinalProcessor(chronoElement, map);
        }

        public Builder<T> addLiteral(char c) {
            return this.addLiteral(String.valueOf(c));
        }

        public Builder<T> addLiteral(char c, char c2) {
            this.addProcessor(new LiteralProcessor(c, c2));
            return this;
        }

        public Builder<T> addLiteral(String string) {
            this.addProcessor(new LiteralProcessor(string));
            return this;
        }

        public Builder<T> addLiteral(AttributeKey<Character> attributeKey) {
            this.addProcessor(new LiteralProcessor(attributeKey));
            return this;
        }

        public Builder<T> addIgnorableWhitespace() {
            this.addProcessor(IgnorableWhitespaceProcessor.SINGLETON);
            return this;
        }

        public Builder<T> addPattern(String string, PatternType patternType) {
            ChronoElement chronoElement;
            ChronoElement<?> chronoElement2;
            int n;
            int n2;
            if (patternType == null) {
                throw new NullPointerException("Missing pattern type.");
            }
            Map<Object, Object> map = Collections.emptyMap();
            int n3 = string.length();
            Locale locale = this.locale;
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.stack.isEmpty()) {
                locale = this.stack.getLast().getLocale();
            }
            for (n2 = 0; n2 < n3; ++n2) {
                int n4;
                n = string.charAt(n2);
                if (Builder.isSymbol((char)n)) {
                    this.addLiteralChars(stringBuilder);
                    n4 = n2++;
                    while (n2 < n3 && string.charAt(n2) == n) {
                        ++n2;
                    }
                    chronoElement2 = patternType.registerSymbol(this, locale, (char)n, n2 - n4);
                    if (map.isEmpty()) {
                        map = chronoElement2;
                    } else {
                        chronoElement = new HashMap(map);
                        chronoElement.putAll(chronoElement2);
                        map = chronoElement;
                    }
                    --n2;
                    continue;
                }
                if (n == 39) {
                    this.addLiteralChars(stringBuilder);
                    n4 = n2++;
                    while (n2 < n3) {
                        if (string.charAt(n2) == '\'') {
                            if (n2 + 1 >= n3 || string.charAt(n2 + 1) != '\'') break;
                            ++n2;
                        }
                        ++n2;
                    }
                    if (n2 >= n3) {
                        throw new IllegalArgumentException("String literal in pattern not closed: " + string);
                    }
                    if (n4 + 1 == n2) {
                        this.addLiteral('\'');
                        continue;
                    }
                    chronoElement2 = string.substring(n4 + 1, n2);
                    this.addLiteral(chronoElement2.replace((CharSequence)"''", (CharSequence)"'"));
                    continue;
                }
                if (n == 91) {
                    this.addLiteralChars(stringBuilder);
                    this.startOptionalSection();
                    continue;
                }
                if (n == 93) {
                    this.addLiteralChars(stringBuilder);
                    this.endSection();
                    continue;
                }
                if (n == 124) {
                    try {
                        this.addLiteralChars(stringBuilder);
                        this.or();
                        continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalArgumentException(illegalStateException);
                    }
                }
                if (n == 35 || n == 123 || n == 125) {
                    throw new IllegalArgumentException("Pattern contains reserved character: '" + (char)n + "'");
                }
                stringBuilder.append((char)n);
            }
            this.addLiteralChars(stringBuilder);
            if (!map.isEmpty()) {
                n2 = this.steps.size();
                for (n = 0; n < n2; ++n) {
                    FormatStep formatStep = this.steps.get(n);
                    chronoElement2 = formatStep.getProcessor().getElement();
                    if (!this.chronology.isRegistered(chronoElement2) || !map.containsKey(chronoElement2)) continue;
                    chronoElement = (ChronoElement)map.get(chronoElement2);
                    this.steps.set(n, formatStep.updateElement(chronoElement));
                }
            }
            return this;
        }

        public Builder<T> addText(TextElement<?> textElement) {
            this.checkElement((ChronoElement<?>)textElement);
            this.addProcessor(TextProcessor.create(textElement));
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement) {
            this.checkElement(chronoElement);
            if (chronoElement instanceof TextElement) {
                TextElement textElement = (TextElement)TextElement.class.cast(chronoElement);
                this.addProcessor(TextProcessor.create(textElement));
            } else {
                Map map = Collections.emptyMap();
                this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            }
            return this;
        }

        public <V extends Enum<V>> Builder<T> addText(ChronoElement<V> chronoElement, Map<V, String> map) {
            this.checkElement(chronoElement);
            this.addProcessor(new LookupProcessor<V>(chronoElement, map));
            return this;
        }

        public Builder<T> addDayPeriodFixed() {
            TextElement<?> textElement = this.findDayPeriodElement(true, null);
            return this.addText(textElement);
        }

        public Builder<T> addDayPeriodApproximate() {
            TextElement<?> textElement = this.findDayPeriodElement(false, null);
            return this.addText(textElement);
        }

        public Builder<T> addDayPeriod(Map<PlainTime, String> map) {
            if (this.dayPeriod != null) {
                throw new IllegalStateException("Cannot add custom day period more than once.");
            }
            DayPeriod dayPeriod = DayPeriod.of(map);
            TextElement<?> textElement = this.findDayPeriodElement(false, dayPeriod);
            this.dayPeriod = dayPeriod;
            this.addProcessor(TextProcessor.createProtected(textElement));
            return this;
        }

        public <V extends ChronoEntity<V>> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoFormatter<V> chronoFormatter) {
            return this.addCustomized(chronoElement, chronoFormatter, chronoFormatter);
        }

        public <V> Builder<T> addCustomized(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
            this.checkElement(chronoElement);
            this.startSection((AttributeKey)Attributes.TRAILING_CHARACTERS, (Enum)true);
            this.addProcessor(new CustomizedProcessor<V>(chronoElement, chronoPrinter, chronoParser));
            this.endSection();
            return this;
        }

        public Builder<T> addTwoDigitYear(ChronoElement<Integer> chronoElement) {
            this.checkElement(chronoElement);
            this.checkAfterDecimalDigits(chronoElement);
            TwoDigitYearProcessor twoDigitYearProcessor = new TwoDigitYearProcessor(chronoElement);
            if (this.reservedIndex == -1) {
                this.addProcessor(twoDigitYearProcessor);
                this.reservedIndex = this.steps.size() - 1;
            } else {
                int n = this.reservedIndex;
                FormatStep formatStep = this.steps.get(n);
                this.startSection(Attributes.LENIENCY, Leniency.STRICT);
                this.addProcessor(twoDigitYearProcessor);
                this.endSection();
                FormatStep formatStep2 = this.steps.get(this.steps.size() - 1);
                if (formatStep.getSection() == formatStep2.getSection()) {
                    this.reservedIndex = n;
                    this.steps.set(n, formatStep.reserve(2));
                }
            }
            return this;
        }

        public Builder<T> addTimezoneID() {
            Class clazz = this.chronology.getChronoType();
            if (UnixTime.class.isAssignableFrom(clazz)) {
                this.addProcessor(TimezoneIDProcessor.INSTANCE);
                return this;
            }
            throw new IllegalStateException("Only unix timestamps can have a timezone id.");
        }

        public Builder<T> addShortTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(true));
            return this;
        }

        public Builder<T> addLongTimezoneName() {
            this.addProcessor(new TimezoneNameProcessor(false));
            return this;
        }

        public Builder<T> addShortTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(true, set));
            return this;
        }

        public Builder<T> addLongTimezoneName(Set<TZID> set) {
            this.addProcessor(new TimezoneNameProcessor(false, set));
            return this;
        }

        public Builder<T> addTimezoneOffset() {
            return this.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList("Z"));
        }

        public Builder<T> addTimezoneOffset(DisplayMode displayMode, boolean bl, List<String> list) {
            this.addProcessor(new TimezoneOffsetProcessor(displayMode, bl, list));
            return this;
        }

        public Builder<T> addShortLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(true));
            return this;
        }

        public Builder<T> addLongLocalizedOffset() {
            this.addProcessor(new LocalizedGMTProcessor(false));
            return this;
        }

        public Builder<T> padNext(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (n > 0) {
                this.leftPadWidth = n;
            }
            return this;
        }

        public Builder<T> padPrevious(int n) {
            if (n < 0) {
                throw new IllegalArgumentException("Negative pad width: " + n);
            }
            if (!this.steps.isEmpty() && n > 0) {
                int n2 = this.steps.size() - 1;
                FormatStep formatStep = this.steps.get(n2);
                int n3 = 0;
                if (!this.stack.isEmpty()) {
                    n3 = this.stack.getLast().getSection();
                }
                if (n3 == formatStep.getSection() && !formatStep.isNewOrBlockStarted()) {
                    this.steps.set(n2, formatStep.pad(0, n));
                }
            }
            return this;
        }

        public Builder<T> startOptionalSection() {
            return this.startOptionalSection(null);
        }

        public Builder<T> startOptionalSection(final ChronoCondition<ChronoDisplay> chronoCondition) {
            ChronoCondition<ChronoDisplay> chronoCondition2;
            this.resetPadding();
            Attributes.Builder builder = new Attributes.Builder();
            AttributeSet attributeSet = null;
            ChronoCondition<ChronoDisplay> chronoCondition3 = null;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                builder.setAll(attributeSet.getAttributes());
                chronoCondition3 = attributeSet.getCondition();
            }
            int n = Builder.getLevel(attributeSet) + 1;
            int n2 = ++this.sectionID;
            if (chronoCondition != null) {
                chronoCondition2 = chronoCondition3;
                chronoCondition3 = chronoCondition2 == null ? chronoCondition : new ChronoCondition<ChronoDisplay>(){

                    public boolean test(ChronoDisplay chronoDisplay) {
                        return chronoCondition2.test((Object)chronoDisplay) && chronoCondition.test((Object)chronoDisplay);
                    }
                };
            }
            chronoCondition2 = new AttributeSet(builder.build(), this.locale, n, n2, chronoCondition3);
            this.stack.addLast((AttributeSet)chronoCondition2);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Boolean> attributeKey, boolean bl) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, bl).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, bl);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Integer> attributeKey, int n) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, n).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, n);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> startSection(AttributeKey<Character> attributeKey, char c) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, c).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, c);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public <A extends Enum<A>> Builder<T> startSection(AttributeKey<A> attributeKey, A a) {
            AttributeSet attributeSet;
            Builder.checkAttribute(attributeKey);
            this.resetPadding();
            if (this.stack.isEmpty()) {
                Attributes.Builder builder = new Attributes.Builder();
                attributeSet = new AttributeSet(builder.set(attributeKey, a).build(), this.locale);
            } else {
                AttributeSet attributeSet2 = this.stack.getLast();
                Attributes.Builder builder = new Attributes.Builder();
                builder.setAll(attributeSet2.getAttributes());
                builder.set(attributeKey, a);
                attributeSet = attributeSet2.withAttributes(builder.build());
            }
            this.stack.addLast(attributeSet);
            return this;
        }

        public Builder<T> endSection() {
            this.stack.removeLast();
            this.resetPadding();
            return this;
        }

        public Builder<T> or() {
            int n = -1;
            FormatStep formatStep = null;
            int n2 = -1;
            int n3 = 0;
            if (!this.stack.isEmpty()) {
                n3 = this.stack.getLast().getSection();
            }
            if (!this.steps.isEmpty()) {
                n = this.steps.size() - 1;
                formatStep = this.steps.get(n);
                n2 = formatStep.getSection();
            }
            if (n3 != n2) {
                throw new IllegalStateException("Cannot start or-block without any previous step in current section.");
            }
            this.steps.set(n, formatStep.startNewOrBlock());
            this.resetPadding();
            this.reservedIndex = -1;
            return this;
        }

        public ChronoFormatter<T> build() {
            HashMap<Integer, FormatStep> hashMap = null;
            int n = this.steps.size();
            for (int i = 0; i < n; ++i) {
                FormatStep formatStep = this.steps.get(i);
                if (!formatStep.isNewOrBlockStarted()) continue;
                int n2 = formatStep.getSection();
                boolean bl = false;
                for (int j = n - 1; j > i; --j) {
                    if (this.steps.get(j).getSection() != n2) continue;
                    if (hashMap == null) {
                        hashMap = new HashMap<Integer, FormatStep>();
                    }
                    hashMap.put(i, formatStep.markLastOrBlock(j));
                    bl = true;
                    break;
                }
                if (bl) continue;
                throw new IllegalStateException("Missing format processor after or-operator.");
            }
            if (hashMap != null) {
                for (Integer n3 : hashMap.keySet()) {
                    this.steps.set(n3, (FormatStep)hashMap.get(n3));
                }
            }
            ChronoFormatter chronoFormatter = new ChronoFormatter(this.chronology, this.override, this.locale, this.steps);
            if (this.dayPeriod != null) {
                AttributeSet attributeSet = chronoFormatter.globalAttributes;
                attributeSet = attributeSet.withInternal(CUSTOM_DAY_PERIOD, this.dayPeriod);
                chronoFormatter = new ChronoFormatter(chronoFormatter, attributeSet);
            }
            return chronoFormatter;
        }

        Builder<T> addYear(ChronoElement<Integer> chronoElement, int n, boolean bl) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null || formatStep.isNewOrBlockStarted() || !formatStep.isNumerical() || n != 4) {
                SignPolicy signPolicy = n < 4 ? SignPolicy.SHOW_WHEN_NEGATIVE : SignPolicy.SHOW_WHEN_BIG_NUMBER;
                return this.addNumber(chronoElement, false, n, 9, signPolicy, bl);
            }
            return this.addNumber(chronoElement, true, 4, 4, SignPolicy.SHOW_NEVER, bl);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy) {
            return this.addNumber(chronoElement, bl, n, n2, signPolicy, false);
        }

        private <V> Builder<T> addNumber(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            NumberProcessor<V> numberProcessor = new NumberProcessor<V>(chronoElement, bl, n, n2, signPolicy, bl2);
            if (bl) {
                if (this.reservedIndex == -1) {
                    this.addProcessor(numberProcessor);
                } else {
                    int n3 = this.reservedIndex;
                    FormatStep formatStep2 = this.steps.get(n3);
                    this.addProcessor(numberProcessor);
                    FormatStep formatStep3 = this.steps.get(this.steps.size() - 1);
                    if (formatStep2.getSection() == formatStep3.getSection()) {
                        this.reservedIndex = n3;
                        this.steps.set(n3, formatStep2.reserve(n));
                    }
                }
            } else {
                if (formatStep != null && formatStep.isNumerical() && !formatStep.isNewOrBlockStarted()) {
                    throw new IllegalStateException("Numerical element with variable width can't be inserted after another numerical element. Consider \"addFixedXXX()\" instead.");
                }
                this.addProcessor(numberProcessor);
                this.reservedIndex = this.steps.size() - 1;
            }
            return this;
        }

        private Builder<T> addOrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
            this.checkElement(chronoElement);
            FormatStep formatStep = this.checkAfterDecimalDigits(chronoElement);
            OrdinalProcessor ordinalProcessor = new OrdinalProcessor(chronoElement, map);
            if (formatStep != null && formatStep.isNumerical() && !formatStep.isNewOrBlockStarted()) {
                throw new IllegalStateException("Ordinal element with variable width can't be inserted after another numerical element.");
            }
            this.addProcessor(ordinalProcessor);
            return this;
        }

        private void addProcessor(FormatProcessor<?> formatProcessor) {
            this.reservedIndex = -1;
            AttributeSet attributeSet = null;
            int n = 0;
            int n2 = 0;
            if (!this.stack.isEmpty()) {
                attributeSet = this.stack.getLast();
                n = attributeSet.getLevel();
                n2 = attributeSet.getSection();
            }
            FormatStep formatStep = new FormatStep(formatProcessor, n, n2, attributeSet);
            if (this.leftPadWidth > 0) {
                formatStep = formatStep.pad(this.leftPadWidth, 0);
                this.leftPadWidth = 0;
            }
            this.steps.add(formatStep);
        }

        private TextElement<?> findDayPeriodElement(boolean bl, DayPeriod dayPeriod) {
            Attributes attributes;
            Object object = attributes = new Attributes.Builder(this.getChronology()).build();
            if (dayPeriod != null) {
                AttributeSet attributeSet = this.stack.isEmpty() ? new AttributeSet(attributes, this.locale) : this.stack.getLast();
                object = attributeSet.withInternal(CUSTOM_DAY_PERIOD, dayPeriod);
            }
            for (ChronoExtension chronoExtension : PlainTime.axis().getExtensions()) {
                for (ChronoElement chronoElement : chronoExtension.getElements(this.locale, (AttributeQuery)object)) {
                    if (bl && chronoElement.getSymbol() == 'b' && this.isDayPeriodSupported(chronoElement)) {
                        return (TextElement)ChronoFormatter.cast(chronoElement);
                    }
                    if (bl || chronoElement.getSymbol() != 'B' || !this.isDayPeriodSupported(chronoElement)) continue;
                    return (TextElement)ChronoFormatter.cast(chronoElement);
                }
            }
            throw new IllegalStateException("Day periods are not supported: " + this.getChronology().getChronoType());
        }

        private boolean isDayPeriodSupported(ChronoElement<?> chronoElement) {
            if (!chronoElement.name().endsWith("_DAY_PERIOD")) {
                return false;
            }
            if (this.override == null && !this.chronology.isSupported(chronoElement)) {
                Chronology chronology = this.chronology.preparser();
                return chronology != null && chronology.isSupported(chronoElement);
            }
            return true;
        }

        private static int getLevel(AttributeSet attributeSet) {
            if (attributeSet == null) {
                return 0;
            }
            return attributeSet.getLevel();
        }

        private static void checkAttribute(AttributeKey<?> attributeKey) {
            if (attributeKey.name().charAt(0) == '_') {
                throw new IllegalArgumentException("Internal attribute not allowed: " + attributeKey.name());
            }
        }

        private void resetPadding() {
            this.leftPadWidth = 0;
        }

        private static boolean isSymbol(char c) {
            return c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
        }

        private void checkElement(ChronoElement<?> chronoElement) {
            ChronoFormatter.checkElement(this.chronology, this.override, chronoElement);
        }

        private void ensureDecimalDigitsOnlyOnce() {
            for (FormatStep formatStep : this.steps) {
                if (!formatStep.isDecimal()) continue;
                throw new IllegalArgumentException("Cannot define more than one element with decimal digits.");
            }
        }

        private void ensureOnlyOneFractional(boolean bl, boolean bl2) {
            this.ensureDecimalDigitsOnlyOnce();
            if (!bl && !bl2 && this.reservedIndex != -1) {
                throw new IllegalArgumentException("Cannot add fractional element with variable width after another numerical element with variable width.");
            }
        }

        private FormatStep checkAfterDecimalDigits(ChronoElement<?> chronoElement) {
            FormatStep formatStep;
            FormatStep formatStep2 = formatStep = this.steps.isEmpty() ? null : this.steps.get(this.steps.size() - 1);
            if (formatStep == null) {
                return null;
            }
            if (formatStep.isDecimal() && !formatStep.isNewOrBlockStarted()) {
                throw new IllegalStateException(chronoElement.name() + " can't be inserted after an element" + " with decimal digits.");
            }
            return formatStep;
        }

        private void addLiteralChars(StringBuilder stringBuilder) {
            if (stringBuilder.length() > 0) {
                this.addLiteral(stringBuilder.toString());
                stringBuilder.setLength(0);
            }
        }
    }
}

