/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.AmbivalentValueException;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.TZID;

class ParsedValues
extends ChronoEntity<ParsedValues> {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INT_PHI = -1640531527;
    private Object[] keys;
    private Object[] values;
    private int[] ints;
    private int mask;
    private int len;
    private int count;
    private int threshold;
    private boolean duplicateKeysAllowed = false;
    private int position = -1;

    ParsedValues(int n) {
        this.len = ParsedValues.arraySize(n);
        this.mask = this.len - 1;
        this.threshold = ParsedValues.maxFill(this.len);
        this.keys = new Object[this.len];
        this.values = null;
        this.ints = new int[this.len];
        this.count = 0;
    }

    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement == null) {
            return false;
        }
        Object[] objectArray = this.keys;
        int n = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n];
        if (object == null) {
            return false;
        }
        if (chronoElement.equals(object)) {
            return true;
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            return false;
        } while (!chronoElement.equals(object));
        return true;
    }

    public <V> V get(ChronoElement<V> chronoElement) {
        int n;
        Object object;
        Class clazz = chronoElement.getType();
        if (clazz == Integer.class) {
            int n2 = this.getInt0(chronoElement);
            if (n2 == Integer.MIN_VALUE) {
                throw new ChronoException("No value found for: " + chronoElement.name());
            }
            return (V)clazz.cast(n2);
        }
        Object[] objectArray = this.keys;
        if (this.values == null || (object = objectArray[n = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) == null) {
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        if (chronoElement.equals(object)) {
            return (V)clazz.cast(this.values[n]);
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            throw new ChronoException("No value found for: " + chronoElement.name());
        } while (!chronoElement.equals(object));
        return (V)clazz.cast(this.values[n]);
    }

    public int getInt(ChronoElement<Integer> chronoElement) {
        return this.getInt0(chronoElement);
    }

    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return true;
    }

    public <V> ParsedValues with(ChronoElement<V> chronoElement, V v) {
        this.put(chronoElement, v);
        return this;
    }

    public ParsedValues with(ChronoElement<Integer> chronoElement, int n) {
        this.put(chronoElement, n);
        return this;
    }

    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMinimum();
    }

    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMaximum();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ParsedValues) {
            ParsedValues parsedValues = (ParsedValues)((Object)object);
            return this.count == parsedValues.count && Arrays.equals(this.keys, parsedValues.keys) && Arrays.equals(this.values, parsedValues.values) && Arrays.equals(this.ints, parsedValues.ints);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.keys);
    }

    public String toString() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('{');
        for (ChronoElement<?> chronoElement : this.getRegisteredElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(this.get(chronoElement));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public Set<ChronoElement<?>> getRegisteredElements() {
        return new KeySet();
    }

    protected Chronology<ParsedValues> getChronology() {
        throw new UnsupportedOperationException("Parsed values do not have any chronology.");
    }

    public boolean hasTimezone() {
        return this.contains(TimezoneElement.TIMEZONE_ID) || this.contains(TimezoneElement.TIMEZONE_OFFSET);
    }

    public TZID getTimezone() {
        TZID tZID = null;
        if (this.contains(TimezoneElement.TIMEZONE_ID)) {
            tZID = this.get(TimezoneElement.TIMEZONE_ID);
        } else if (this.contains(TimezoneElement.TIMEZONE_OFFSET)) {
            tZID = this.get(TimezoneElement.TIMEZONE_OFFSET);
        }
        if (tZID instanceof TZID) {
            return (TZID)TZID.class.cast(tZID);
        }
        return super.getTimezone();
    }

    void setPosition(int n) {
        this.position = n;
    }

    int getPosition() {
        return this.position;
    }

    void setNoAmbivalentCheck() {
        this.duplicateKeysAllowed = true;
    }

    int size() {
        return this.count;
    }

    void putAll(ParsedValues parsedValues) {
        Object[] objectArray = parsedValues.keys;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            ChronoElement chronoElement = (ChronoElement)ChronoElement.class.cast(object);
            if (chronoElement.getType() == Integer.class) {
                this.put(chronoElement, parsedValues.ints[i]);
                continue;
            }
            this.put(chronoElement, parsedValues.values[i]);
        }
    }

    void put(ChronoElement<?> chronoElement, int n) {
        Object[] objectArray = this.keys;
        int n2 = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n2];
        if (object != null) {
            if (object.equals(chronoElement)) {
                if (this.duplicateKeysAllowed || this.ints[n2] == n) {
                    this.ints[n2] = n;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
            while ((object = objectArray[n2 = n2 + 1 & this.mask]) != null) {
                if (!object.equals(chronoElement)) continue;
                if (this.duplicateKeysAllowed || this.ints[n2] == n) {
                    this.ints[n2] = n;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
        }
        objectArray[n2] = chronoElement;
        this.ints[n2] = n;
        if (this.count++ >= this.threshold) {
            this.rehash(ParsedValues.arraySize(this.count));
        }
    }

    void put(ChronoElement<?> chronoElement, Object object) {
        int n;
        Object object2;
        if (object == null) {
            this.remove(chronoElement);
            return;
        }
        if (chronoElement.getType() == Integer.class) {
            this.put(chronoElement, (Integer)Integer.class.cast(object));
            return;
        }
        Object[] objectArray = this.keys;
        if (this.values == null) {
            this.values = new Object[this.len];
        }
        if ((object2 = objectArray[n = ParsedValues.mix(chronoElement.hashCode()) & this.mask]) != null) {
            if (object2.equals(chronoElement)) {
                if (this.duplicateKeysAllowed || object.equals(this.values[n])) {
                    this.values[n] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
            while ((object2 = objectArray[n = n + 1 & this.mask]) != null) {
                if (!object2.equals(chronoElement)) continue;
                if (this.duplicateKeysAllowed || object.equals(this.values[n])) {
                    this.values[n] = object;
                    return;
                }
                throw new AmbivalentValueException(chronoElement);
            }
        }
        objectArray[n] = chronoElement;
        this.values[n] = object;
        if (this.count++ >= this.threshold) {
            this.rehash(ParsedValues.arraySize(this.count));
        }
    }

    void reset() {
        this.keys = new Object[this.keys.length];
        this.count = 0;
    }

    private int getInt0(ChronoElement<?> chronoElement) {
        Object[] objectArray = this.keys;
        int n = ParsedValues.mix(chronoElement.hashCode()) & this.mask;
        Object object = objectArray[n];
        if (object == null) {
            return Integer.MIN_VALUE;
        }
        if (chronoElement.equals(object)) {
            return this.ints[n];
        }
        do {
            if ((object = objectArray[n = n + 1 & this.mask]) != null) continue;
            return Integer.MIN_VALUE;
        } while (!chronoElement.equals(object));
        return this.ints[n];
    }

    private void remove(Object object) {
        Object[] objectArray = this.keys;
        int n = ParsedValues.mix(object.hashCode()) & this.mask;
        Object object2 = objectArray[n];
        if (object2 == null) {
            return;
        }
        if (object.equals(object2)) {
            this.removeEntry(n);
            return;
        }
        do {
            if ((object2 = objectArray[n = n + 1 & this.mask]) != null) continue;
            return;
        } while (!object.equals(object2));
        this.removeEntry(n);
    }

    private void removeEntry(int n) {
        --this.count;
        Object[] objectArray = this.keys;
        while (true) {
            Object object;
            int n2 = n;
            n = n2 + 1 & this.mask;
            while (true) {
                if ((object = objectArray[n]) == null) {
                    objectArray[n2] = null;
                    return;
                }
                int n3 = ParsedValues.mix(object.hashCode()) & this.mask;
                if (n2 <= n ? n2 >= n3 || n3 > n : n2 >= n3 && n3 > n) break;
                n = n + 1 & this.mask;
            }
            objectArray[n2] = object;
            if (this.values != null) {
                this.values[n2] = this.values[n];
            }
            this.ints[n2] = this.ints[n];
        }
    }

    private static int arraySize(int n) {
        return Math.max(2, ParsedValues.nextPowerOfTwo((int)Math.ceil((float)n / 0.75f)));
    }

    private static int nextPowerOfTwo(int n) {
        if (n == 0) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        return (n | n >> 16) + 1;
    }

    private static int maxFill(int n) {
        return Math.min((int)Math.ceil((float)n * 0.75f), n - 1);
    }

    private static int mix(int n) {
        int n2 = n * -1640531527;
        return n2 ^ n2 >>> 16;
    }

    private void rehash(int n) {
        Object[] objectArray = this.keys;
        Object[] objectArray2 = this.values;
        int[] nArray = this.ints;
        int n2 = n - 1;
        Object[] objectArray3 = new Object[n];
        Object[] objectArray4 = objectArray2 == null ? null : new Object[n];
        int[] nArray2 = new int[n];
        int n3 = this.len;
        int n4 = this.count;
        for (int i = 0; i < n4; ++i) {
            while (objectArray[--n3] == null) {
            }
            int n5 = ParsedValues.mix(objectArray[n3].hashCode()) & n2;
            if (objectArray3[n5] != null) {
                while (objectArray3[n5 = n5 + 1 & n2] != null) {
                }
            }
            objectArray3[n5] = objectArray[n3];
            if (objectArray2 != null) {
                objectArray4[n5] = objectArray2[n3];
            }
            nArray2[n5] = nArray[n3];
        }
        this.len = n;
        this.mask = n2;
        this.threshold = ParsedValues.maxFill(n);
        this.keys = objectArray3;
        this.values = objectArray4;
        this.ints = nArray2;
    }

    private class KeySet
    extends AbstractSet<ChronoElement<?>> {
        private KeySet() {
        }

        @Override
        public Iterator<ChronoElement<?>> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return ParsedValues.this.count;
        }
    }

    private class KeyIterator
    implements Iterator<ChronoElement<?>> {
        int pos;
        int c;

        private KeyIterator() {
            this.pos = ParsedValues.this.len;
            this.c = ParsedValues.this.count;
        }

        @Override
        public boolean hasNext() {
            return this.c > 0;
        }

        @Override
        public ChronoElement<?> next() {
            if (this.c > 0) {
                Object[] objectArray = ParsedValues.this.keys;
                while (--this.pos >= 0) {
                    if (objectArray[this.pos] == null) continue;
                    --this.c;
                    return (ChronoElement)ChronoElement.class.cast(objectArray[this.pos]);
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }
}

