/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.CalendarUnit;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.EpochDays;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.TimePoint;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.TextElement;
import net.time4j.history.AncientJulianLeapYears;
import net.time4j.history.Calculus;
import net.time4j.history.CalendarAlgorithm;
import net.time4j.history.CutOverEvent;
import net.time4j.history.EraPreference;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricDateElement;
import net.time4j.history.HistoricEra;
import net.time4j.history.HistoricEraElement;
import net.time4j.history.HistoricIntegerElement;
import net.time4j.history.NewYearRule;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.SPX;
import net.time4j.history.YearDefinition;
import net.time4j.history.internal.HistoricVariant;

public final class ChronoHistory
implements VariantSource,
Serializable {
    public static final AttributeKey<YearDefinition> YEAR_DEFINITION = Attributes.createKey((String)"YEAR_DEFINITION", YearDefinition.class);
    public static final ChronoHistory PROLEPTIC_GREGORIAN = new ChronoHistory(HistoricVariant.PROLEPTIC_GREGORIAN, Collections.singletonList(new CutOverEvent(Long.MIN_VALUE, CalendarAlgorithm.GREGORIAN, CalendarAlgorithm.GREGORIAN)));
    public static final ChronoHistory PROLEPTIC_JULIAN = new ChronoHistory(HistoricVariant.PROLEPTIC_JULIAN, Collections.singletonList(new CutOverEvent(Long.MIN_VALUE, CalendarAlgorithm.JULIAN, CalendarAlgorithm.JULIAN)));
    public static final ChronoHistory PROLEPTIC_BYZANTINE = new ChronoHistory(HistoricVariant.PROLEPTIC_BYZANTINE, Collections.singletonList(new CutOverEvent(Long.MIN_VALUE, CalendarAlgorithm.JULIAN, CalendarAlgorithm.JULIAN)), null, new NewYearStrategy(NewYearRule.BEGIN_OF_SEPTEMBER, Integer.MAX_VALUE), EraPreference.byzantineUntil((PlainDate)PlainDate.axis().getMaximum()));
    private static final long EARLIEST_CUTOVER = (Long)PlainDate.of((int)1582, (int)10, (int)15).get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
    private static final ChronoHistory INTRODUCTION_BY_POPE_GREGOR = ChronoHistory.ofGregorianReform(EARLIEST_CUTOVER);
    private static final ChronoHistory SWEDEN;
    private static final Map<String, ChronoHistory> LOOKUP;
    private static final long serialVersionUID = 4100690610730913643L;
    private final transient HistoricVariant variant;
    private final transient List<CutOverEvent> events;
    private final transient AncientJulianLeapYears ajly;
    private final transient NewYearStrategy nys;
    private final transient EraPreference eraPreference;
    private final transient ChronoElement<HistoricDate> dateElement;
    private final transient ChronoElement<HistoricEra> eraElement;
    private final transient TextElement<Integer> yearOfEraElement;
    private final transient ChronoElement<Integer> yearAfterElement;
    private final transient ChronoElement<Integer> yearBeforeElement;
    private final transient TextElement<Integer> monthElement;
    private final transient TextElement<Integer> dayOfMonthElement;
    private final transient TextElement<Integer> dayOfYearElement;
    private final transient Set<ChronoElement<?>> elements;

    private ChronoHistory(HistoricVariant historicVariant, List<CutOverEvent> list) {
        this(historicVariant, list, null, null, EraPreference.DEFAULT);
    }

    private ChronoHistory(HistoricVariant historicVariant, List<CutOverEvent> list, AncientJulianLeapYears ancientJulianLeapYears, NewYearStrategy newYearStrategy, EraPreference eraPreference) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("At least one cutover event must be present in chronological history.");
        }
        if (historicVariant == null) {
            throw new NullPointerException("Missing historic variant.");
        }
        if (eraPreference == null) {
            throw new NullPointerException("Missing era preference.");
        }
        this.variant = historicVariant;
        this.events = list;
        this.ajly = ancientJulianLeapYears;
        this.nys = newYearStrategy;
        this.eraPreference = eraPreference;
        this.dateElement = new HistoricDateElement(this);
        this.eraElement = new HistoricEraElement(this);
        this.yearOfEraElement = new HistoricIntegerElement('y', 1, 999999999, this, 2);
        this.yearAfterElement = new HistoricIntegerElement('\u0000', 1, 999999999, this, 6);
        this.yearBeforeElement = new HistoricIntegerElement('\u0000', 1, 999999999, this, 7);
        this.monthElement = new HistoricIntegerElement('M', 1, 12, this, 3);
        this.dayOfMonthElement = new HistoricIntegerElement('d', 1, 31, this, 4);
        this.dayOfYearElement = new HistoricIntegerElement('D', 1, 365, this, 5);
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(this.dateElement);
        hashSet.add(this.eraElement);
        hashSet.add(this.yearOfEraElement);
        hashSet.add(this.yearAfterElement);
        hashSet.add(this.yearBeforeElement);
        hashSet.add(this.monthElement);
        hashSet.add(this.dayOfMonthElement);
        hashSet.add(this.dayOfYearElement);
        this.elements = Collections.unmodifiableSet(hashSet);
    }

    public static ChronoHistory ofFirstGregorianReform() {
        return INTRODUCTION_BY_POPE_GREGOR;
    }

    public static ChronoHistory ofGregorianReform(PlainDate plainDate) {
        if (plainDate.equals((Object)PlainDate.axis().getMaximum())) {
            return PROLEPTIC_JULIAN;
        }
        if (plainDate.equals((Object)PlainDate.axis().getMinimum())) {
            return PROLEPTIC_GREGORIAN;
        }
        long l = (Long)plainDate.get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
        ChronoHistory.check(l);
        if (l == EARLIEST_CUTOVER) {
            return INTRODUCTION_BY_POPE_GREGOR;
        }
        return ChronoHistory.ofGregorianReform(l);
    }

    public static ChronoHistory of(Locale locale) {
        String string = locale.getCountry();
        ChronoHistory chronoHistory = null;
        if (!locale.getVariant().isEmpty()) {
            string = string + "-" + locale.getVariant();
            chronoHistory = LOOKUP.get(string);
        }
        if (chronoHistory == null) {
            chronoHistory = LOOKUP.get(string);
        }
        if (chronoHistory == null) {
            return ChronoHistory.ofFirstGregorianReform();
        }
        return chronoHistory;
    }

    public static ChronoHistory ofSweden() {
        return SWEDEN;
    }

    public boolean isValid(HistoricDate historicDate) {
        if (historicDate == null) {
            return false;
        }
        Calculus calculus = this.getAlgorithm(historicDate);
        return calculus != null && calculus.isValid(historicDate);
    }

    public PlainDate convert(HistoricDate historicDate) {
        Calculus calculus = this.getAlgorithm(historicDate);
        if (calculus == null) {
            throw new IllegalArgumentException("Invalid historic date: " + historicDate);
        }
        return PlainDate.of((long)calculus.toMJD(historicDate), (EpochDays)EpochDays.MODIFIED_JULIAN_DATE);
    }

    public HistoricDate convert(PlainDate plainDate) {
        HistoricEra historicEra;
        long l = (Long)plainDate.get((ChronoElement)EpochDays.MODIFIED_JULIAN_DATE);
        HistoricDate historicDate = null;
        for (int i = this.events.size() - 1; i >= 0; --i) {
            CutOverEvent cutOverEvent = this.events.get(i);
            if (l < cutOverEvent.start) continue;
            historicDate = cutOverEvent.algorithm.fromMJD(l);
            break;
        }
        if (historicDate == null) {
            historicDate = this.getJulianAlgorithm().fromMJD(l);
        }
        if ((historicEra = this.eraPreference.getPreferredEra(historicDate, plainDate)) != historicDate.getEra()) {
            int n = historicEra.yearOfEra(historicDate.getEra(), historicDate.getYearOfEra());
            historicDate = HistoricDate.of(historicEra, n, historicDate.getMonth(), historicDate.getDayOfMonth());
        }
        return historicDate;
    }

    public String getVariant() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.variant.name());
        switch (this.variant) {
            case PROLEPTIC_GREGORIAN: 
            case PROLEPTIC_JULIAN: 
            case PROLEPTIC_BYZANTINE: {
                stringBuilder.append(":no-cutover");
                break;
            }
            case INTRODUCTION_ON_1582_10_15: 
            case SINGLE_CUTOVER_DATE: {
                stringBuilder.append(":cutover=");
                stringBuilder.append(this.getGregorianCutOverDate());
            }
            default: {
                stringBuilder.append(":ancient-julian-leap-years=");
                if (this.ajly != null) {
                    int[] nArray = this.ajly.getPattern();
                    stringBuilder.append('[');
                    stringBuilder.append(nArray[0]);
                    for (int i = 1; i < nArray.length; ++i) {
                        stringBuilder.append(',');
                        stringBuilder.append(nArray[i]);
                    }
                    stringBuilder.append(']');
                } else {
                    stringBuilder.append("[]");
                }
                stringBuilder.append(":new-year-strategy=");
                stringBuilder.append(this.getNewYearStrategy());
                stringBuilder.append(":era-preference=");
                stringBuilder.append(this.getEraPreference());
            }
        }
        return stringBuilder.toString();
    }

    public PlainDate getGregorianCutOverDate() {
        long l = this.events.get((int)(this.events.size() - 1)).start;
        if (l == Long.MIN_VALUE) {
            throw new UnsupportedOperationException("Proleptic history without any gregorian reform date.");
        }
        return PlainDate.of((long)l, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE);
    }

    public boolean hasGregorianCutOverDate() {
        return this.events.get((int)(this.events.size() - 1)).start > Long.MIN_VALUE;
    }

    public HistoricDate getBeginOfYear(HistoricEra historicEra, int n) {
        HistoricDate historicDate = this.getNewYearStrategy().newYear(historicEra, n);
        if (this.isValid(historicDate)) {
            PlainDate plainDate = this.convert(historicDate);
            HistoricEra historicEra2 = this.eraPreference.getPreferredEra(historicDate, plainDate);
            if (historicEra2 != historicEra) {
                int n2 = historicEra2.yearOfEra(historicDate.getEra(), historicDate.getYearOfEra());
                historicDate = HistoricDate.of(historicEra2, n2, historicDate.getMonth(), historicDate.getDayOfMonth());
            }
            return historicDate;
        }
        throw new IllegalArgumentException("Cannot determine valid New Year: " + (Object)((Object)historicEra) + "-" + n);
    }

    public int getLengthOfYear(HistoricEra historicEra, int n) {
        try {
            int n2;
            HistoricDate historicDate;
            HistoricDate historicDate2;
            if (this.nys == null) {
                historicDate2 = HistoricDate.of(historicEra, n, 1, 1);
                historicDate = HistoricDate.of(historicEra, n, 12, 31);
                n2 = 1;
            } else {
                historicDate2 = this.nys.newYear(historicEra, n);
                if (historicEra == HistoricEra.BC) {
                    historicDate = n == 1 ? this.nys.newYear(HistoricEra.AD, 1) : this.nys.newYear(historicEra, n - 1);
                } else {
                    HistoricDate historicDate3;
                    historicDate = this.nys.newYear(historicEra, n + 1);
                    if (historicEra == HistoricEra.BYZANTINE && (historicDate3 = this.nys.newYear(HistoricEra.AD, historicEra.annoDomini(n))).compareTo(historicDate2) > 0) {
                        historicDate = historicDate3;
                    }
                }
                n2 = 0;
            }
            return (int)(CalendarUnit.DAYS.between((TimePoint)this.convert(historicDate2), (TimePoint)this.convert(historicDate)) + (long)n2);
        }
        catch (RuntimeException runtimeException) {
            return -1;
        }
    }

    public AncientJulianLeapYears getAncientJulianLeapYears() {
        if (this.ajly == null) {
            throw new UnsupportedOperationException("No historic julian leap years were defined.");
        }
        return this.ajly;
    }

    public boolean hasAncientJulianLeapYears() {
        return this.ajly != null;
    }

    public ChronoHistory with(AncientJulianLeapYears ancientJulianLeapYears) {
        if (ancientJulianLeapYears == null) {
            throw new NullPointerException("Missing ancient julian leap years.");
        }
        if (!this.hasGregorianCutOverDate()) {
            return this;
        }
        return new ChronoHistory(this.variant, this.events, ancientJulianLeapYears, this.nys, this.eraPreference);
    }

    public NewYearStrategy getNewYearStrategy() {
        return this.nys == null ? NewYearStrategy.DEFAULT : this.nys;
    }

    public ChronoHistory with(NewYearStrategy newYearStrategy) {
        if (newYearStrategy.equals(NewYearStrategy.DEFAULT)) {
            if (this.nys == null) {
                return this;
            }
            return new ChronoHistory(this.variant, this.events, this.ajly, null, this.eraPreference);
        }
        if (!this.hasGregorianCutOverDate()) {
            return this;
        }
        return new ChronoHistory(this.variant, this.events, this.ajly, newYearStrategy, this.eraPreference);
    }

    public ChronoHistory with(EraPreference eraPreference) {
        if (eraPreference.equals(this.eraPreference) || !this.hasGregorianCutOverDate()) {
            return this;
        }
        return new ChronoHistory(this.variant, this.events, this.ajly, this.nys, eraPreference);
    }

    public ChronoElement<HistoricDate> date() {
        return this.dateElement;
    }

    @FormattableElement(format="G")
    public ChronoElement<HistoricEra> era() {
        return this.eraElement;
    }

    @FormattableElement(format="y")
    public TextElement<Integer> yearOfEra() {
        return this.yearOfEraElement;
    }

    public ChronoElement<Integer> yearOfEra(YearDefinition yearDefinition) {
        switch (yearDefinition) {
            case DUAL_DATING: {
                return this.yearOfEraElement;
            }
            case AFTER_NEW_YEAR: {
                return this.yearAfterElement;
            }
            case BEFORE_NEW_YEAR: {
                return this.yearBeforeElement;
            }
        }
        throw new UnsupportedOperationException(yearDefinition.name());
    }

    @FormattableElement(format="M")
    public TextElement<Integer> month() {
        return this.monthElement;
    }

    @FormattableElement(format="d")
    public TextElement<Integer> dayOfMonth() {
        return this.dayOfMonthElement;
    }

    @FormattableElement(format="D")
    public TextElement<Integer> dayOfYear() {
        return this.dayOfYearElement;
    }

    public Set<ChronoElement<?>> getElements() {
        return this.elements;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChronoHistory) {
            ChronoHistory chronoHistory = (ChronoHistory)object;
            if (this.variant == chronoHistory.variant && ChronoHistory.isEqual(this.ajly, chronoHistory.ajly) && ChronoHistory.isEqual(this.nys, chronoHistory.nys) && this.eraPreference.equals(chronoHistory.eraPreference)) {
                return this.variant != HistoricVariant.SINGLE_CUTOVER_DATE || this.events.get((int)0).start == chronoHistory.events.get((int)0).start;
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.variant == HistoricVariant.SINGLE_CUTOVER_DATE) {
            long l = this.events.get((int)0).start;
            return (int)(l ^ l << 32);
        }
        return this.variant.hashCode();
    }

    public String toString() {
        return "ChronoHistory[" + this.getVariant() + "]";
    }

    Calculus getAlgorithm(HistoricDate historicDate) {
        for (int i = this.events.size() - 1; i >= 0; --i) {
            CutOverEvent cutOverEvent = this.events.get(i);
            if (historicDate.compareTo(cutOverEvent.dateAtCutOver) >= 0) {
                return cutOverEvent.algorithm;
            }
            if (historicDate.compareTo(cutOverEvent.dateBeforeCutOver) <= 0) continue;
            return null;
        }
        return this.getJulianAlgorithm();
    }

    HistoricDate adjustDayOfMonth(HistoricDate historicDate) {
        Calculus calculus = this.getAlgorithm(historicDate);
        if (calculus == null) {
            return historicDate;
        }
        int n = calculus.getMaximumDayOfMonth(historicDate);
        if (n < historicDate.getDayOfMonth()) {
            return HistoricDate.of(historicDate.getEra(), historicDate.getYearOfEra(), historicDate.getMonth(), n);
        }
        return historicDate;
    }

    List<CutOverEvent> getEvents() {
        return this.events;
    }

    HistoricVariant getHistoricVariant() {
        return this.variant;
    }

    EraPreference getEraPreference() {
        return this.eraPreference;
    }

    private Calculus getJulianAlgorithm() {
        if (this.ajly != null) {
            return this.ajly.getCalculus();
        }
        return CalendarAlgorithm.JULIAN;
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private static void check(long l) {
        if (l < EARLIEST_CUTOVER) {
            throw new IllegalArgumentException("Gregorian calendar did not exist before 1582-10-15");
        }
    }

    private static ChronoHistory ofGregorianReform(long l) {
        return new ChronoHistory(l == EARLIEST_CUTOVER ? HistoricVariant.INTRODUCTION_ON_1582_10_15 : HistoricVariant.SINGLE_CUTOVER_DATE, Collections.singletonList(new CutOverEvent(l, CalendarAlgorithm.JULIAN, CalendarAlgorithm.GREGORIAN)));
    }

    private Object writeReplace() {
        return new SPX(this, 3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        ArrayList<CutOverEvent> arrayList = new ArrayList<CutOverEvent>();
        arrayList.add(new CutOverEvent(-57959L, CalendarAlgorithm.JULIAN, CalendarAlgorithm.SWEDISH));
        arrayList.add(new CutOverEvent(-53575L, CalendarAlgorithm.SWEDISH, CalendarAlgorithm.JULIAN));
        arrayList.add(new CutOverEvent(-38611L, CalendarAlgorithm.JULIAN, CalendarAlgorithm.GREGORIAN));
        SWEDEN = new ChronoHistory(HistoricVariant.SWEDEN, Collections.unmodifiableList(arrayList));
        HashMap<String, ChronoHistory> hashMap = new HashMap<String, ChronoHistory>();
        PlainDate plainDate = PROLEPTIC_JULIAN.convert(HistoricDate.of(HistoricEra.AD, 988, 3, 1));
        PlainDate plainDate2 = PROLEPTIC_JULIAN.convert(HistoricDate.of(HistoricEra.AD, 1382, 12, 24));
        PlainDate plainDate3 = PROLEPTIC_JULIAN.convert(HistoricDate.of(HistoricEra.AD, 1421, 12, 24));
        PlainDate plainDate4 = PROLEPTIC_JULIAN.convert(HistoricDate.of(HistoricEra.AD, 1699, 12, 31));
        hashMap.put("ES", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.BEGIN_OF_JANUARY.until(1383).and(NewYearRule.CHRISTMAS_STYLE.until(1556))).with(EraPreference.hispanicUntil(plainDate2)));
        hashMap.put("PT", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.BEGIN_OF_JANUARY.until(1422).and(NewYearRule.CHRISTMAS_STYLE.until(1556))).with(EraPreference.hispanicUntil(plainDate3)));
        hashMap.put("FR", ChronoHistory.ofGregorianReform(PlainDate.of((int)1582, (int)12, (int)20)).with(NewYearRule.EASTER_STYLE.until(1567)));
        hashMap.put("DE", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.CHRISTMAS_STYLE.until(1544)));
        hashMap.put("DE-BAYERN", ChronoHistory.ofGregorianReform(PlainDate.of((int)1583, (int)10, (int)16)).with(NewYearRule.CHRISTMAS_STYLE.until(1544)));
        hashMap.put("DE-PREUSSEN", ChronoHistory.ofGregorianReform(PlainDate.of((int)1610, (int)9, (int)2)).with(NewYearRule.CHRISTMAS_STYLE.until(1559)));
        hashMap.put("DE-PROTESTANT", ChronoHistory.ofGregorianReform(PlainDate.of((int)1700, (int)3, (int)1)).with(NewYearRule.CHRISTMAS_STYLE.until(1559)));
        hashMap.put("NL", ChronoHistory.ofGregorianReform(PlainDate.of((int)1583, (int)1, (int)1)));
        hashMap.put("AT", ChronoHistory.ofGregorianReform(PlainDate.of((int)1584, (int)1, (int)17)));
        hashMap.put("CH", ChronoHistory.ofGregorianReform(PlainDate.of((int)1584, (int)1, (int)22)));
        hashMap.put("HU", ChronoHistory.ofGregorianReform(PlainDate.of((int)1587, (int)11, (int)1)));
        hashMap.put("DK", ChronoHistory.ofGregorianReform(PlainDate.of((int)1700, (int)3, (int)1)).with(NewYearRule.MARIA_ANUNCIATA.until(1623)));
        hashMap.put("NO", ChronoHistory.ofGregorianReform(PlainDate.of((int)1700, (int)3, (int)1)).with(NewYearRule.MARIA_ANUNCIATA.until(1623)));
        hashMap.put("IT", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.CHRISTMAS_STYLE.until(1583)));
        hashMap.put("IT-FLORENCE", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.MARIA_ANUNCIATA.until(1749)));
        hashMap.put("IT-PISA", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.CALCULUS_PISANUS.until(1749)));
        hashMap.put("IT-VENICE", ChronoHistory.ofFirstGregorianReform().with(NewYearRule.BEGIN_OF_MARCH.until(1798)));
        hashMap.put("GB", ChronoHistory.ofGregorianReform(PlainDate.of((int)1752, (int)9, (int)14)).with(NewYearRule.CHRISTMAS_STYLE.until(1087).and(NewYearRule.BEGIN_OF_JANUARY.until(1155)).and(NewYearRule.MARIA_ANUNCIATA.until(1752))));
        hashMap.put("GB-SCT", ChronoHistory.ofGregorianReform(PlainDate.of((int)1752, (int)9, (int)14)).with(NewYearRule.CHRISTMAS_STYLE.until(1087).and(NewYearRule.BEGIN_OF_JANUARY.until(1155)).and(NewYearRule.MARIA_ANUNCIATA.until(1600))));
        hashMap.put("RU", ChronoHistory.ofGregorianReform(PlainDate.of((int)1918, (int)2, (int)14)).with(NewYearRule.BEGIN_OF_JANUARY.until(988).and(NewYearRule.BEGIN_OF_MARCH.until(1493)).and(NewYearRule.BEGIN_OF_SEPTEMBER.until(1700))).with(EraPreference.byzantineBetween(plainDate, plainDate4)));
        hashMap.put("SE", SWEDEN);
        LOOKUP = Collections.unmodifiableMap(hashMap);
    }
}

