/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;

final class SkipProcessor
implements FormatProcessor<Void> {
    private final int count;
    private final ChronoCondition<Character> condition;

    SkipProcessor(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Must not be negative: " + n);
        }
        this.condition = null;
        this.count = n;
    }

    SkipProcessor(ChronoCondition<Character> chronoCondition, int n) {
        if (chronoCondition == null) {
            throw new NullPointerException("Missing condition for unparseable chars.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Must be positive: " + n);
        }
        this.condition = chronoCondition;
        this.count = n;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        int n;
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        if (this.condition == null) {
            n = n3 - this.count;
        } else {
            n = n2;
            for (int i = 0; i < this.count && i + n2 < n3 && this.condition.test((Object)Character.valueOf(charSequence.charAt(i + n2))); ++i) {
                ++n;
            }
        }
        n = Math.min(Math.max(n, 0), n3);
        if (n > n2) {
            parseLog.setPosition(n);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof SkipProcessor) {
            SkipProcessor skipProcessor = (SkipProcessor)object;
            return this.count == skipProcessor.count && (this.condition == null ? skipProcessor.condition == null : this.condition.equals(skipProcessor.condition));
        }
        return false;
    }

    public int hashCode() {
        return this.condition == null ? this.count : ~this.count ^ this.condition.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        if (this.condition == null) {
            stringBuilder.append("[keepRemainingChars=");
            stringBuilder.append(this.count);
        } else {
            stringBuilder.append("[condition=");
            stringBuilder.append(this.condition);
            stringBuilder.append(", maxIterations=");
            stringBuilder.append(this.count);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Void> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<Void> withElement(ChronoElement<Void> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<Void> quickPath(AttributeQuery attributeQuery, int n) {
        return this;
    }
}

