/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;

final class TwoDigitYearProcessor
implements FormatProcessor<Integer> {
    private static final Integer DEFAULT_PIVOT_YEAR;
    private final ChronoElement<Integer> element;
    private final int reserved;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final int protectedLength;
    private final int pivotYear;

    TwoDigitYearProcessor(ChronoElement<Integer> chronoElement) {
        if (!chronoElement.name().startsWith("YEAR")) {
            throw new IllegalArgumentException("Year element required: " + chronoElement);
        }
        this.element = chronoElement;
        this.reserved = 0;
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.protectedLength = 0;
        this.pivotYear = DEFAULT_PIVOT_YEAR;
    }

    private TwoDigitYearProcessor(ChronoElement<Integer> chronoElement, int n, char c, Leniency leniency, int n2, int n3) {
        this.element = chronoElement;
        this.reserved = n;
        this.zeroDigit = c;
        this.lenientMode = leniency;
        this.protectedLength = n2;
        this.pivotYear = n3;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        int n;
        char c;
        int n2 = chronoDisplay.getInt(this.element);
        if (n2 < 0) {
            throw new IllegalArgumentException("Negative year cannot be printed as two-digit-year: " + n2);
        }
        int n3 = MathUtils.floorModulo((int)n2, (int)100);
        String string = Integer.toString(n3);
        char c2 = c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (c != '0') {
            n = c - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(cArray[i] + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n4 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        if (n3 < 10) {
            appendable.append(c);
            ++n4;
        }
        appendable.append(string);
        if (n != -1 && (n4 += string.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n4));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        char c;
        int n6;
        int n7 = charSequence.length();
        int n8 = parseLog.getPosition();
        int n9 = n6 = bl ? this.protectedLength : (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (n6 > 0) {
            n7 -= n6;
        }
        if (n8 >= n7) {
            parseLog.setError(n8, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        Leniency leniency = bl ? this.lenientMode : (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        int n10 = leniency.isStrict() ? 2 : 9;
        char c2 = c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (this.reserved > 0 && n6 <= 0) {
            n5 = 0;
            for (n4 = n8; n4 < n7 && (n3 = charSequence.charAt(n4) - c) >= 0 && n3 <= 9; ++n4) {
                ++n5;
            }
            n10 = Math.min(n10, n5 - this.reserved);
        }
        n5 = n8 + 2;
        n4 = Math.min(n7, n8 + n10);
        n3 = 0;
        boolean bl2 = true;
        for (n2 = n8; n2 < n4; ++n2) {
            n = charSequence.charAt(n2) - c;
            if (n >= 0 && n <= 9) {
                n3 = n3 * 10 + n;
                bl2 = false;
                continue;
            }
            if (!bl2) break;
            parseLog.setError(n8, "Digit expected.");
            return;
        }
        if (n2 < n5) {
            parseLog.setError(n8, "Not enough digits found for: " + this.element.name());
            return;
        }
        if (n2 == n8 + 2) {
            int n11;
            int n12 = n11 = bl ? this.pivotYear : (Integer)attributeQuery.get(Attributes.PIVOT_YEAR, (Object)DEFAULT_PIVOT_YEAR);
            assert (n3 >= 0 && n3 <= 99);
            n = TwoDigitYearProcessor.toYear(n3, n11);
        } else {
            n = n3;
        }
        parsedValues.put(this.element, n);
        parseLog.setPosition(n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TwoDigitYearProcessor) {
            TwoDigitYearProcessor twoDigitYearProcessor = (TwoDigitYearProcessor)object;
            return this.element.equals(twoDigitYearProcessor.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new TwoDigitYearProcessor(chronoElement);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<Integer> quickPath(AttributeQuery attributeQuery, int n) {
        return new TwoDigitYearProcessor(this.element, n, ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue(), (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0), (Integer)attributeQuery.get(Attributes.PIVOT_YEAR, (Object)DEFAULT_PIVOT_YEAR));
    }

    private static int toYear(int n, int n2) {
        int n3 = n >= n2 % 100 ? (n2 / 100 - 1) * 100 : n2 / 100 * 100;
        return n3 + n;
    }

    static {
        long l = EpochDays.MODIFIED_JULIAN_DATE.transform(MathUtils.floorDivide((long)System.currentTimeMillis(), (int)86400000), EpochDays.UNIX);
        DEFAULT_PIVOT_YEAR = GregorianMath.readYear((long)GregorianMath.toPackedDate((long)l)) + 20;
    }
}

