/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.JulianMath;

public enum Computus {
    WESTERN,
    EASTERN;


    public PlainDate easterSunday(int n) {
        int n2 = this.marchDay(n);
        int n3 = 3;
        if (n2 > 31) {
            ++n3;
            n2 -= 31;
        }
        return this == WESTERN && n > 1582 ? PlainDate.of((int)n, (int)n3, (int)n2) : PlainDate.of((long)JulianMath.toMJD(n, n3, n2), (EpochDays)EpochDays.MODIFIED_JULIAN_DATE);
    }

    int marchDay(int n) {
        if (n < 532) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        int n2 = n / 100;
        int n3 = 15;
        int n4 = 0;
        if (this == WESTERN && n > 1582) {
            n3 += (3 * n2 + 3) / 4;
            n3 -= (8 * n2 + 13) / 25;
            n4 = 2 - (3 * n2 + 3) / 4;
        }
        int n5 = n % 19;
        int n6 = (19 * n5 + n3) % 30;
        int n7 = n6 / 29 + (n6 / 28 - n6 / 29) * (n5 / 11);
        int n8 = 21 + n6 - n7;
        int n9 = 7 - (n + n / 4 + n4) % 7;
        int n10 = 7 - (n8 - n9) % 7;
        return n8 + n10;
    }
}

