/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.time4j.format.DisplayMode;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.ExtendedPatterns;
import net.time4j.history.HistoricEra;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class IsoTextProviderSPI
implements TextProvider,
ExtendedPatterns {
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;

    public String[] getSupportedCalendarTypes() {
        return new String[]{"iso8601"};
    }

    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        return IsoTextProviderSPI.months(locale, textWidth, outputContext);
    }

    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.quarters(locale, textWidth, outputContext);
    }

    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.weekdays(locale, textWidth, outputContext);
    }

    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        return IsoTextProviderSPI.eras(locale, textWidth);
    }

    public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
        return IsoTextProviderSPI.meridiems(locale, textWidth, OutputContext.FORMAT);
    }

    public String[] meridiems(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.meridiems(locale, textWidth, outputContext);
    }

    public String getDatePattern(DisplayMode displayMode, Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("F(");
        stringBuilder.append(IsoTextProviderSPI.toChar(displayMode));
        stringBuilder.append(")_d");
        String string = stringBuilder.toString();
        return IsoTextProviderSPI.getPatterns(locale).getString(string);
    }

    public String getTimePattern(DisplayMode displayMode, Locale locale) {
        return this.getTimePattern(displayMode, locale, false);
    }

    public String getTimePattern(DisplayMode displayMode, Locale locale, boolean bl) {
        String string;
        if (bl && displayMode == DisplayMode.FULL) {
            string = "F(alt)";
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("F(");
            stringBuilder.append(IsoTextProviderSPI.toChar(displayMode));
            stringBuilder.append(")_t");
            string = stringBuilder.toString();
        }
        return IsoTextProviderSPI.getPatterns(locale).getString(string);
    }

    public String getDateTimePattern(DisplayMode displayMode, DisplayMode displayMode2, Locale locale) {
        DisplayMode displayMode3 = displayMode;
        if (displayMode.compareTo((Enum)displayMode2) < 0) {
            displayMode3 = displayMode2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("F(");
        stringBuilder.append(IsoTextProviderSPI.toChar(displayMode3));
        stringBuilder.append(")_dt");
        String string = stringBuilder.toString();
        return IsoTextProviderSPI.getPatterns(locale).getString(string);
    }

    public String getIntervalPattern(Locale locale) {
        return IsoTextProviderSPI.getPatterns(locale).getString("I");
    }

    public ResourceBundle.Control getControl() {
        return UTF8ResourceControl.SINGLETON;
    }

    public String toString() {
        return "IsoTextProviderSPI";
    }

    static Set<String> getPrimaryLanguages() {
        return LANGUAGES;
    }

    private static String[] months(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String[] stringArray = null;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String string;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 12, string = IsoTextProviderSPI.getKey(resourceBundle, "MONTH_OF_YEAR"), textWidth, outputContext, 1)) == null) {
                if (outputContext == OutputContext.STANDALONE) {
                    if (textWidth != TextWidth.NARROW) {
                        stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.FORMAT);
                    }
                } else if (textWidth == TextWidth.ABBREVIATED) {
                    stringArray = IsoTextProviderSPI.months(locale, TextWidth.WIDE, OutputContext.FORMAT);
                } else if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.STANDALONE);
                }
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-month.", IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] quarters(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String[] stringArray = null;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String string;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 4, string = IsoTextProviderSPI.getKey(resourceBundle, "QUARTER_OF_YEAR"), textWidth, outputContext, 1)) == null) {
                if (outputContext == OutputContext.STANDALONE) {
                    if (textWidth != TextWidth.NARROW) {
                        stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.FORMAT);
                    }
                } else if (textWidth == TextWidth.ABBREVIATED) {
                    stringArray = IsoTextProviderSPI.quarters(locale, TextWidth.WIDE, OutputContext.FORMAT);
                } else if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.STANDALONE);
                }
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-quarter-of-year.", IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] weekdays(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        String string;
        String[] stringArray = null;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && (stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 7, string = IsoTextProviderSPI.getKey(resourceBundle, "DAY_OF_WEEK"), textWidth, outputContext, 1)) == null) {
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth != TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.FORMAT);
                }
            } else if (textWidth == TextWidth.ABBREVIATED) {
                stringArray = IsoTextProviderSPI.weekdays(locale, TextWidth.WIDE, OutputContext.FORMAT);
            } else if (textWidth == TextWidth.SHORT) {
                stringArray = IsoTextProviderSPI.weekdays(locale, TextWidth.ABBREVIATED, OutputContext.FORMAT);
            } else if (textWidth == TextWidth.NARROW) {
                stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.STANDALONE);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-quarter-of-year.", IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] eras(Locale locale, TextWidth textWidth) throws MissingResourceException {
        String[] stringArray = null;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            String string = IsoTextProviderSPI.getKey(resourceBundle, "ERA");
            stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, HistoricEra.values().length, string, textWidth, OutputContext.FORMAT, 0);
            if (stringArray == null && textWidth != TextWidth.ABBREVIATED) {
                stringArray = IsoTextProviderSPI.eras(locale, TextWidth.ABBREVIATED);
            }
        }
        if (stringArray == null) {
            throw new MissingResourceException("Cannot find ISO-8601-resource for era.", IsoTextProviderSPI.class.getName(), locale.toString());
        }
        return stringArray;
    }

    private static String[] meridiems(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            String string = IsoTextProviderSPI.meridiemKey("am", textWidth, outputContext);
            String string2 = IsoTextProviderSPI.meridiemKey("pm", textWidth, outputContext);
            if (resourceBundle.containsKey(string) && resourceBundle.containsKey(string2)) {
                String[] stringArray = new String[]{resourceBundle.getString(string), resourceBundle.getString(string2)};
                return stringArray;
            }
            if (outputContext == OutputContext.STANDALONE) {
                if (textWidth == TextWidth.ABBREVIATED) {
                    return IsoTextProviderSPI.meridiems(locale, textWidth, OutputContext.FORMAT);
                }
                return IsoTextProviderSPI.meridiems(locale, TextWidth.ABBREVIATED, outputContext);
            }
            if (textWidth != TextWidth.ABBREVIATED) {
                return IsoTextProviderSPI.meridiems(locale, TextWidth.ABBREVIATED, outputContext);
            }
        }
        throw new MissingResourceException("Cannot find ISO-8601-resource for am/pm.", IsoTextProviderSPI.class.getName(), locale.toString());
    }

    private static ResourceBundle getBundle(Locale locale) throws MissingResourceException {
        if (LANGUAGES.contains(LanguageMatch.getAlias(locale))) {
            return ResourceBundle.getBundle("calendar/iso8601", locale, IsoTextProviderSPI.getDefaultLoader(), UTF8ResourceControl.SINGLETON);
        }
        return null;
    }

    private static ResourceBundle getPatterns(Locale locale) {
        return ResourceBundle.getBundle("calendar/iso8601", locale, IsoTextProviderSPI.getDefaultLoader(), UTF8ResourceControl.SINGLETON);
    }

    private static char toChar(DisplayMode displayMode) {
        return Character.toLowerCase(displayMode.name().charAt(0));
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext, int n2) {
        String[] stringArray = new String[n];
        boolean bl = string.length() == 1;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + n2);
            String string2 = stringBuilder.toString();
            if (!resourceBundle.containsKey(string2)) {
                return null;
            }
            stringArray[i] = resourceBundle.getString(string2);
        }
        return stringArray;
    }

    private static String getKey(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getDefaultLoader() {
        return IsoTextProviderSPI.class.getClassLoader();
    }

    private static String meridiemKey(String string, TextWidth textWidth, OutputContext outputContext) {
        char c = textWidth.name().charAt(0);
        if (outputContext == OutputContext.FORMAT) {
            c = Character.toLowerCase(c);
        }
        return "P(" + String.valueOf(c) + ")_" + string;
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("calendar/iso8601", Locale.ROOT, IsoTextProviderSPI.getDefaultLoader(), UTF8ResourceControl.SINGLETON);
        String[] stringArray = resourceBundle.getString("languages").split(" ");
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (String string : LANGUAGES) {
            hashSet2.add(new Locale(string));
        }
        for (LanguageMatch languageMatch : LanguageMatch.values()) {
            hashSet2.add(new Locale(languageMatch.name()));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
    }
}

