/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class OrdinalProcessor
implements FormatProcessor<Integer> {
    private static final Map<PluralCategory, String> ENGLISH_ORDINALS;
    private final ChronoElement<Integer> element;
    private final Map<PluralCategory, String> indicators;
    private final int reserved;
    private final int protectedLength;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final Locale locale;

    OrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = chronoElement;
        if (map == null) {
            this.indicators = null;
        } else {
            this.indicators = Collections.unmodifiableMap(new EnumMap<PluralCategory, String>(map));
            if (!this.indicators.containsKey(PluralCategory.OTHER)) {
                throw new IllegalArgumentException("Missing plural category OTHER: " + map);
            }
        }
        this.reserved = 0;
        this.protectedLength = 0;
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.locale = Locale.ROOT;
    }

    private OrdinalProcessor(ChronoElement<Integer> chronoElement, Map<PluralCategory, String> map, int n, int n2, char c, Leniency leniency, Locale locale) {
        this.element = chronoElement;
        this.indicators = map;
        this.reserved = n;
        this.protectedLength = n2;
        this.zeroDigit = c;
        this.lenientMode = leniency;
        this.locale = locale;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        int n;
        char c;
        int n2 = chronoDisplay.getInt(this.element);
        if (n2 < 0) {
            if (n2 == Integer.MIN_VALUE) {
                throw new IllegalArgumentException("Format context \"" + chronoDisplay + "\" without element: " + this.element);
            }
            throw new IllegalArgumentException("Cannot format negative ordinal numbers: " + chronoDisplay);
        }
        String string = Integer.toString(n2);
        char c2 = c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (c != '0') {
            n = c - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = (char)(cArray[i] + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n3 = 0;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        n3 += string.length();
        String string2 = this.getIndicator(attributeQuery, bl, n2);
        appendable.append(string2);
        if (n != -1 && (n3 += string2.length()) > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n3));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n;
        int n2;
        int n3;
        char c;
        int n4;
        int n5;
        int n6 = 1;
        int n7 = 9;
        int n8 = charSequence.length();
        int n9 = n5 = parseLog.getPosition();
        Leniency leniency = bl ? this.lenientMode : (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        int n10 = n4 = bl ? this.protectedLength : (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (n4 > 0) {
            n8 -= n4;
        }
        if (n9 >= n8) {
            parseLog.setError(n9, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        char c2 = c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (this.reserved > 0 && n4 <= 0) {
            int n11;
            n3 = 0;
            for (n2 = n9; n2 < n8 && (n11 = charSequence.charAt(n2) - c) >= 0 && n11 <= 9; ++n2) {
                ++n3;
            }
            n7 = Math.min(n7, n3 - this.reserved);
        }
        n3 = n9 + n6;
        n2 = Math.min(n8, n9 + n7);
        long l = 0L;
        boolean bl2 = true;
        while (n9 < n2) {
            n = charSequence.charAt(n9) - c;
            if (n >= 0 && n <= 9) {
                l = l * 10L + (long)n;
                ++n9;
                bl2 = false;
                continue;
            }
            if (!bl2) break;
            parseLog.setError(n5, "Digit expected.");
            return;
        }
        if (n9 < n3) {
            parseLog.setError(n5, "Not enough digits found for: " + this.element.name());
            return;
        }
        n = (int)l;
        String string = this.getIndicator(attributeQuery, bl, n);
        int n12 = n9 + string.length();
        if (n12 >= n8) {
            parseLog.setError(n9, "Missing or wrong ordinal indicator for: " + this.element.name());
            return;
        }
        String string2 = charSequence.subSequence(n9, n12).toString();
        if (string2.equals(string)) {
            n9 = n12;
        } else if (!leniency.isLax()) {
            parseLog.setError(n9, "Wrong ordinal indicator for: " + this.element.name() + " (expected=" + string + ", found=" + string2 + ")");
            return;
        }
        parsedEntity.put(this.element, n);
        parseLog.setPosition(n9);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OrdinalProcessor) {
            OrdinalProcessor ordinalProcessor = (OrdinalProcessor)object;
            return this.element.equals(ordinalProcessor.element) && this.getIndicators().equals(ordinalProcessor.getIndicators());
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.getIndicators().hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", indicators=");
        stringBuilder.append(this.getIndicators());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private String getIndicator(AttributeQuery attributeQuery, boolean bl, int n) {
        Locale locale = this.isEnglish() ? Locale.ENGLISH : (bl ? this.locale : (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT));
        PluralCategory pluralCategory = PluralRules.of((Locale)locale, (NumberType)NumberType.ORDINALS).getCategory((long)n);
        if (!this.getIndicators().containsKey(pluralCategory)) {
            pluralCategory = PluralCategory.OTHER;
        }
        return this.getIndicators().get(pluralCategory);
    }

    private boolean isEnglish() {
        return this.indicators == null;
    }

    private Map<PluralCategory, String> getIndicators() {
        if (this.isEnglish()) {
            return ENGLISH_ORDINALS;
        }
        return this.indicators;
    }

    @Override
    public ChronoElement<Integer> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<Integer> withElement(ChronoElement<Integer> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new OrdinalProcessor(chronoElement, this.indicators);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<Integer> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new OrdinalProcessor(this.element, this.indicators, n, (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0), ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue(), (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT));
    }

    static {
        EnumMap<PluralCategory, String> enumMap = new EnumMap<PluralCategory, String>(PluralCategory.class);
        enumMap.put(PluralCategory.ONE, "st");
        enumMap.put(PluralCategory.TWO, "nd");
        enumMap.put(PluralCategory.FEW, "rd");
        enumMap.put(PluralCategory.OTHER, "th");
        ENGLISH_ORDINALS = Collections.unmodifiableMap(enumMap);
    }
}

