/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.SymbolProviderSPI;

final class AttributeSet
implements AttributeQuery {
    static final AttributeKey<String> PLUS_SIGN = Attributes.createKey((String)"PLUS_SIGN", String.class);
    static final AttributeKey<String> MINUS_SIGN = Attributes.createKey((String)"MINUS_SIGN", String.class);
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    private static final char ISO_DECIMAL_SEPARATOR;
    private static final ConcurrentMap<String, NumericalSymbols> NUMBER_SYMBOL_CACHE;
    private static final NumericalSymbols DEFAULT_NUMERICAL_SYMBOLS;
    private final Map<String, Object> internals;
    private final Attributes attributes;
    private final Locale locale;
    private final int level;
    private final int section;
    private final ChronoCondition<ChronoDisplay> printCondition;

    AttributeSet(Attributes attributes, Locale locale) {
        this(attributes, locale, 0, 0, null);
    }

    AttributeSet(Attributes attributes, Locale locale, int n, int n2, ChronoCondition<ChronoDisplay> chronoCondition) {
        if (attributes == null) {
            throw new NullPointerException("Missing format attributes.");
        }
        this.attributes = attributes;
        this.locale = locale == null ? Locale.ROOT : locale;
        this.level = n;
        this.section = n2;
        this.printCondition = chronoCondition;
        this.internals = Collections.emptyMap();
    }

    private AttributeSet(Attributes attributes, Locale locale, int n, int n2, ChronoCondition<ChronoDisplay> chronoCondition, Map<String, Object> map) {
        if (attributes == null) {
            throw new NullPointerException("Missing format attributes.");
        }
        this.attributes = attributes;
        this.locale = locale == null ? Locale.ROOT : locale;
        this.level = n;
        this.section = n2;
        this.printCondition = chronoCondition;
        this.internals = Collections.unmodifiableMap(map);
    }

    public boolean contains(AttributeKey<?> attributeKey) {
        if (this.internals.containsKey(attributeKey.name())) {
            return true;
        }
        return this.attributes.contains(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey) {
        if (this.internals.containsKey(attributeKey.name())) {
            return (A)attributeKey.type().cast(this.internals.get(attributeKey.name()));
        }
        return (A)this.attributes.get(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey, A a) {
        if (this.internals.containsKey(attributeKey.name())) {
            return (A)attributeKey.type().cast(this.internals.get(attributeKey.name()));
        }
        return (A)this.attributes.get(attributeKey, a);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.attributes.equals((Object)attributeSet.attributes) && this.locale.equals(attributeSet.locale) && this.level == attributeSet.level && this.section == attributeSet.section && AttributeSet.isEqual(this.printCondition, attributeSet.printCondition) && this.internals.equals(attributeSet.internals);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.attributes.hashCode() + 37 * this.internals.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[attributes=");
        stringBuilder.append(this.attributes);
        stringBuilder.append(",locale=");
        stringBuilder.append(this.locale);
        stringBuilder.append(",level=");
        stringBuilder.append(this.level);
        stringBuilder.append(",section=");
        stringBuilder.append(this.section);
        stringBuilder.append(",print-condition=");
        stringBuilder.append(this.printCondition);
        stringBuilder.append(",other=");
        stringBuilder.append(this.internals);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    Locale getLocale() {
        return this.locale;
    }

    int getLevel() {
        return this.level;
    }

    int getSection() {
        return this.section;
    }

    ChronoCondition<ChronoDisplay> getCondition() {
        return this.printCondition;
    }

    static AttributeSet createDefaults(Chronology<?> chronology, Attributes attributes, Locale locale) {
        Attributes.Builder builder = new Attributes.Builder(chronology);
        builder.set(Attributes.LENIENCY, (Enum)Leniency.SMART);
        builder.set(Attributes.TEXT_WIDTH, (Enum)TextWidth.WIDE);
        builder.set(Attributes.OUTPUT_CONTEXT, (Enum)OutputContext.FORMAT);
        builder.set(Attributes.PAD_CHAR, ' ');
        builder.setAll(attributes);
        AttributeSet attributeSet = new AttributeSet(builder.build(), locale);
        return attributeSet.withLocale(locale);
    }

    AttributeSet withAttributes(Attributes attributes) {
        return new AttributeSet(attributes, this.locale, this.level, this.section, this.printCondition, this.internals);
    }

    <A> AttributeSet withInternal(AttributeKey<A> attributeKey, A a) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.internals);
        if (a == null) {
            hashMap.remove(attributeKey.name());
        } else {
            hashMap.put(attributeKey.name(), a);
        }
        return new AttributeSet(this.attributes, this.locale, this.level, this.section, this.printCondition, hashMap);
    }

    AttributeSet withLocale(Locale locale) {
        Object object;
        String string;
        String string2;
        Attributes.Builder builder = new Attributes.Builder();
        builder.setAll(this.attributes);
        String string3 = LanguageMatch.getAlias(locale);
        String string4 = locale.getCountry();
        if (string3.isEmpty() && string4.isEmpty()) {
            locale = Locale.ROOT;
            builder.set(Attributes.NUMBER_SYSTEM, (Enum)NumberSystem.ARABIC);
            builder.set(Attributes.DECIMAL_SEPARATOR, ISO_DECIMAL_SEPARATOR);
            string2 = "+";
            string = "-";
        } else {
            NumericalSymbols numericalSymbols;
            object = string3;
            if (!string4.isEmpty()) {
                object = (String)object + "_" + string4;
            }
            if ((numericalSymbols = (NumericalSymbols)NUMBER_SYMBOL_CACHE.get(object)) == null) {
                try {
                    numericalSymbols = new NumericalSymbols(NUMBER_SYMBOLS.getDefaultNumberSystem(locale), NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getDecimalSeparator(locale), NUMBER_SYMBOLS.getPlusSign(locale), NUMBER_SYMBOLS.getMinusSign(locale));
                }
                catch (RuntimeException runtimeException) {
                    numericalSymbols = DEFAULT_NUMERICAL_SYMBOLS;
                }
                NumericalSymbols numericalSymbols2 = NUMBER_SYMBOL_CACHE.putIfAbsent((String)object, numericalSymbols);
                if (numericalSymbols2 != null) {
                    numericalSymbols = numericalSymbols2;
                }
            }
            builder.set(Attributes.NUMBER_SYSTEM, (Enum)numericalSymbols.numsys);
            builder.set(Attributes.ZERO_DIGIT, numericalSymbols.zeroDigit);
            builder.set(Attributes.DECIMAL_SEPARATOR, numericalSymbols.decimalSeparator);
            string2 = numericalSymbols.plus;
            string = numericalSymbols.minus;
        }
        builder.setLanguage(locale);
        object = new HashMap<String, Object>(this.internals);
        object.put(PLUS_SIGN.name(), string2);
        object.put(MINUS_SIGN.name(), string);
        return new AttributeSet(builder.build(), locale, this.level, this.section, this.printCondition, (Map<String, Object>)object);
    }

    static AttributeSet merge(AttributeSet attributeSet, AttributeSet attributeSet2) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.putAll(attributeSet2.internals);
        hashMap.putAll(attributeSet.internals);
        Attributes attributes = new Attributes.Builder().setAll(attributeSet2.attributes).setAll(attributeSet.attributes).build();
        AttributeSet attributeSet3 = new AttributeSet(attributes, Locale.ROOT, 0, 0, null, hashMap);
        return attributeSet3.withLocale(attributeSet.locale);
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static {
        SymbolProviderSPI symbolProviderSPI = null;
        int n = 0;
        for (NumberSymbolProvider numberSymbolProvider : ResourceLoader.getInstance().services(NumberSymbolProvider.class)) {
            int n2 = numberSymbolProvider.getAvailableLocales().length;
            if (n2 <= n) continue;
            symbolProviderSPI = numberSymbolProvider;
            n = n2;
        }
        if (symbolProviderSPI == null) {
            symbolProviderSPI = SymbolProviderSPI.INSTANCE;
        }
        NUMBER_SYMBOLS = symbolProviderSPI;
        ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
        NUMBER_SYMBOL_CACHE = new ConcurrentHashMap<String, NumericalSymbols>();
        DEFAULT_NUMERICAL_SYMBOLS = new NumericalSymbols(NumberSystem.ARABIC, '0', ISO_DECIMAL_SEPARATOR, "+", "-");
    }

    private static class NumericalSymbols {
        private final NumberSystem numsys;
        private final char zeroDigit;
        private final char decimalSeparator;
        private final String plus;
        private final String minus;

        NumericalSymbols(NumberSystem numberSystem, char c, char c2, String string, String string2) {
            this.numsys = numberSystem;
            this.zeroDigit = c;
            this.decimalSeparator = c2;
            this.plus = string;
            this.minus = string2;
        }
    }
}

