/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.ZonalDateTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.ParsedValue;

final class CustomizedProcessor<V>
implements FormatProcessor<V> {
    private static final ChronoFunction<ChronoDisplay, Void> NO_RESULT = new ChronoFunction<ChronoDisplay, Void>(){

        public Void apply(ChronoDisplay chronoDisplay) {
            return null;
        }
    };
    private final ChronoElement<V> element;
    private final ChronoPrinter<V> printer;
    private final ChronoParser<V> parser;
    private final boolean passThroughZDT;
    private boolean optPrinter;
    private boolean optParser;
    private boolean singleStepMode;

    CustomizedProcessor(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser) {
        this(chronoElement, chronoPrinter, chronoParser, false, false, false);
    }

    private CustomizedProcessor(ChronoElement<V> chronoElement, ChronoPrinter<V> chronoPrinter, ChronoParser<V> chronoParser, boolean bl, boolean bl2, boolean bl3) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (chronoPrinter == null) {
            throw new NullPointerException("Missing printer.");
        }
        if (chronoParser == null) {
            throw new NullPointerException("Missing parser.");
        }
        this.element = chronoElement;
        this.printer = chronoPrinter;
        this.parser = chronoParser;
        this.passThroughZDT = chronoPrinter instanceof ChronoFormatter && chronoElement.getType() == Moment.class;
        this.optPrinter = bl;
        this.optParser = bl2;
        this.singleStepMode = bl3;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        if (bl && this.optPrinter) {
            attributeQuery = ((ChronoFormatter)ChronoFormatter.class.cast(this.printer)).getAttributes();
        }
        if (this.passThroughZDT && chronoDisplay instanceof ZonalDateTime && set == null) {
            ChronoFormatter chronoFormatter = (ChronoFormatter)this.printer;
            chronoFormatter.print(chronoDisplay, appendable, attributeQuery, false);
            return;
        }
        Object object = chronoDisplay.get(this.element);
        StringBuilder stringBuilder = new StringBuilder();
        if (appendable instanceof CharSequence && set != null) {
            int n = ((CharSequence)((Object)appendable)).length();
            if (this.printer instanceof ChronoFormatter) {
                ChronoFormatter chronoFormatter = (ChronoFormatter)ChronoFormatter.class.cast(this.printer);
                Set<ElementPosition> set2 = CustomizedProcessor.print(chronoFormatter, object, stringBuilder, attributeQuery);
                LinkedHashSet<ElementPosition> linkedHashSet = new LinkedHashSet<ElementPosition>();
                for (ElementPosition elementPosition : set2) {
                    linkedHashSet.add(new ElementPosition(elementPosition.getElement(), n + elementPosition.getStartIndex(), n + elementPosition.getEndIndex()));
                }
                set.addAll(linkedHashSet);
            } else {
                this.printer.print(object, stringBuilder, attributeQuery, NO_RESULT);
                set.add(new ElementPosition(this.element, n, n + stringBuilder.length()));
            }
        } else {
            this.printer.print(object, stringBuilder, attributeQuery, NO_RESULT);
        }
        appendable.append(stringBuilder);
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n = parseLog.getPosition();
        try {
            V v;
            if (bl && this.optParser) {
                attributeQuery = ((ChronoFormatter)ChronoFormatter.class.cast(this.parser)).getAttributes();
            }
            if ((v = this.parser.parse(charSequence, parseLog, attributeQuery)) == null) {
                parseLog.setError(n, parseLog.getErrorMessage());
            } else if (this.singleStepMode && parsedEntity instanceof ParsedValue) {
                parsedEntity.setResult(v);
            } else {
                ChronoEntity<?> chronoEntity = parseLog.getRawValues();
                for (ChronoElement chronoElement : chronoEntity.getRegisteredElements()) {
                    if (chronoElement.getType() == Integer.class) {
                        ChronoElement chronoElement2 = chronoElement;
                        parsedEntity.put(chronoElement2, chronoEntity.getInt(chronoElement2));
                        continue;
                    }
                    parsedEntity.put(chronoElement, chronoEntity.get(chronoElement));
                }
                parsedEntity.put(this.element, v);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            parseLog.setError(n, indexOutOfBoundsException.getMessage());
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CustomizedProcessor) {
            CustomizedProcessor customizedProcessor = (CustomizedProcessor)object;
            return this.element.equals(customizedProcessor.element) && this.printer.equals(customizedProcessor.printer) && this.parser.equals(customizedProcessor.parser);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * this.printer.hashCode() + 37 * this.parser.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", printer=");
        stringBuilder.append(this.printer);
        stringBuilder.append(", parser=");
        stringBuilder.append(this.parser);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new CustomizedProcessor<V>(chronoElement, this.printer, this.parser);
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<V> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        boolean bl;
        boolean bl2 = bl = chronoFormatter.isSingleStepOptimizationPossible() && this.element.getType().equals(chronoFormatter.getChronology().getChronoType());
        if (attributeQuery instanceof AttributeSet) {
            ChronoFormatter chronoFormatter2;
            ChronoPrinter<V> chronoPrinter = this.printer;
            ChronoParser<V> chronoParser = this.parser;
            boolean bl3 = false;
            boolean bl4 = false;
            Map<ChronoElement<?>, Object> map = chronoFormatter.getDefaults();
            AttributeSet attributeSet = (AttributeSet)attributeQuery;
            if (this.printer instanceof ChronoFormatter) {
                chronoFormatter2 = (ChronoFormatter)ChronoFormatter.class.cast(this.printer);
                chronoPrinter = chronoFormatter2.with(CustomizedProcessor.adjust(map, chronoFormatter2), attributeSet);
                bl3 = true;
            }
            if (this.parser instanceof ChronoFormatter) {
                chronoFormatter2 = (ChronoFormatter)ChronoFormatter.class.cast(this.parser);
                chronoParser = chronoFormatter2.with(CustomizedProcessor.adjust(map, chronoFormatter2), attributeSet);
                bl4 = true;
            }
            return new CustomizedProcessor<V>(this.element, chronoPrinter, chronoParser, bl3, bl4, bl);
        }
        if (this.optPrinter || this.optParser) {
            return new CustomizedProcessor<V>(this.element, this.printer, this.parser);
        }
        return this;
    }

    boolean isSingleStepMode() {
        return this.singleStepMode;
    }

    private static Map<ChronoElement<?>, Object> adjust(Map<ChronoElement<?>, Object> map, ChronoFormatter<?> chronoFormatter) {
        Chronology<?> chronology = chronoFormatter.getChronology();
        HashMap hashMap = new HashMap();
        for (ChronoElement<?> chronoElement : map.keySet()) {
            if (!chronology.isSupported(chronoElement)) continue;
            hashMap.put(chronoElement, map.get(chronoElement));
        }
        return hashMap;
    }

    private static <T> Set<ElementPosition> print(ChronoFormatter<T> chronoFormatter, Object object, StringBuilder stringBuilder, AttributeQuery attributeQuery) throws IOException {
        return chronoFormatter.print(chronoFormatter.getChronology().getChronoType().cast(object), stringBuilder, attributeQuery);
    }
}

