/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.Weekday;
import net.time4j.base.ResourceLoader;
import net.time4j.format.WeekdataProvider;

public class WeekdataProviderSPI
implements WeekdataProvider {
    private final String source;
    private final Set<String> countriesWithMinDays4;
    private final Map<String, Weekday> firstDayOfWeek;
    private final Map<String, Weekday> startOfWeekend;
    private final Map<String, Weekday> endOfWeekend;

    public WeekdataProviderSPI() {
        String string = "data/week.data";
        URI uRI = ResourceLoader.getInstance().locate("i18n", WeekdataProviderSPI.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            try {
                inputStream = ResourceLoader.getInstance().load(WeekdataProviderSPI.class, string, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            this.source = "@" + uRI;
            HashSet<String> hashSet = new HashSet<String>();
            HashMap hashMap = new HashMap();
            HashMap<String, Weekday> hashMap2 = new HashMap<String, Weekday>();
            HashMap hashMap3 = new HashMap();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    HashMap<String, Weekday> hashMap4;
                    Weekday weekday;
                    Object object;
                    if (string2.startsWith("#")) continue;
                    int n = string2.indexOf(61);
                    String string3 = string2.substring(0, n).trim();
                    String[] stringArray2 = string2.substring(n + 1).split(" ");
                    if (string3.equals("minDays-4")) {
                        for (String string4 : stringArray2) {
                            String string5 = string4.trim().toUpperCase(Locale.US);
                            if (string5.isEmpty()) continue;
                            hashSet.add(string5);
                        }
                        continue;
                    }
                    if (string3.startsWith("start-")) {
                        object = string3.substring(6);
                        weekday = Weekday.SATURDAY;
                        hashMap4 = hashMap2;
                    } else if (string3.startsWith("end-")) {
                        object = string3.substring(4);
                        weekday = Weekday.SUNDAY;
                        hashMap4 = hashMap3;
                    } else if (string3.startsWith("first-")) {
                        object = string3.substring(6);
                        weekday = Weekday.MONDAY;
                        hashMap4 = hashMap;
                    } else {
                        throw new IllegalStateException("Unexpected format: " + this.source);
                    }
                    if (((String)object).equals("sun")) {
                        weekday = Weekday.SUNDAY;
                    } else if (((String)object).equals("sat")) {
                        weekday = Weekday.SATURDAY;
                    } else if (((String)object).equals("fri")) {
                        weekday = Weekday.FRIDAY;
                    } else if (((String)object).equals("thu")) {
                        weekday = Weekday.THURSDAY;
                    } else if (((String)object).equals("wed")) {
                        weekday = Weekday.WEDNESDAY;
                    } else if (((String)object).equals("tue")) {
                        weekday = Weekday.TUESDAY;
                    } else if (((String)object).equals("mon")) {
                        weekday = Weekday.MONDAY;
                    }
                    for (String string6 : stringArray2) {
                        String string7 = string6.trim().toUpperCase(Locale.US);
                        if (string7.isEmpty()) continue;
                        hashMap4.put(string7, weekday);
                    }
                }
                this.countriesWithMinDays4 = Collections.unmodifiableSet(hashSet);
                this.firstDayOfWeek = Collections.unmodifiableMap(hashMap);
                this.startOfWeekend = Collections.unmodifiableMap(hashMap2);
                this.endOfWeekend = Collections.unmodifiableMap(hashMap3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unexpected format: " + this.source, exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        this.source = "@STATIC";
        this.countriesWithMinDays4 = Collections.emptySet();
        this.firstDayOfWeek = Collections.emptyMap();
        this.startOfWeekend = Collections.emptyMap();
        this.endOfWeekend = Collections.emptyMap();
        System.err.println("Warning: File \"" + string + "\" not found.");
    }

    public int getFirstDayOfWeek(Locale locale) {
        if (this.firstDayOfWeek.isEmpty()) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
            int n = gregorianCalendar.getFirstDayOfWeek();
            return n == 1 ? 7 : n - 1;
        }
        String string = locale.getCountry();
        Weekday weekday = Weekday.MONDAY;
        if (this.firstDayOfWeek.containsKey(string)) {
            weekday = this.firstDayOfWeek.get(string);
        }
        return weekday.getValue();
    }

    public int getMinimalDaysInFirstWeek(Locale locale) {
        if (this.countriesWithMinDays4.isEmpty()) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
            return gregorianCalendar.getMinimalDaysInFirstWeek();
        }
        String string = locale.getCountry();
        int n = 1;
        if (string.isEmpty() && locale.getLanguage().isEmpty()) {
            n = 4;
        } else if (this.countriesWithMinDays4.contains(string)) {
            n = 4;
        }
        return n;
    }

    public int getStartOfWeekend(Locale locale) {
        String string = locale.getCountry();
        Weekday weekday = Weekday.SATURDAY;
        if (this.startOfWeekend.containsKey(string)) {
            weekday = this.startOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public int getEndOfWeekend(Locale locale) {
        String string = locale.getCountry();
        Weekday weekday = Weekday.SUNDAY;
        if (this.endOfWeekend.containsKey(string)) {
            weekday = this.endOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public String toString() {
        return this.getClass().getName() + this.source;
    }
}

