/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralProvider;
import net.time4j.format.PluralRules;

public final class PluralProviderSPI
implements PluralProvider {
    private static final Map<String, PluralRules> CARDINAL_MAP = new HashMap<String, PluralRules>(140);
    private static final PluralRules STD_CARDINALS = new StdCardinalRules(0);
    private static final Map<String, PluralRules> ORDINAL_MAP;
    private static final PluralRules STD_ORDINALS;

    public PluralRules load(Locale locale, NumberType numberType) {
        PluralRules pluralRules;
        Map<String, PluralRules> map;
        switch (numberType) {
            case CARDINALS: {
                map = CARDINAL_MAP;
                pluralRules = STD_CARDINALS;
                break;
            }
            case ORDINALS: {
                map = ORDINAL_MAP;
                pluralRules = STD_ORDINALS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(numberType.name());
            }
        }
        PluralRules pluralRules2 = null;
        if (!locale.getCountry().equals("")) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(locale.getLanguage());
            stringBuilder.append('_');
            stringBuilder.append(locale.getCountry());
            pluralRules2 = map.get(stringBuilder.toString());
        }
        if (pluralRules2 == null) {
            pluralRules2 = map.get(locale.getLanguage());
        }
        if (pluralRules2 == null) {
            return pluralRules;
        }
        return pluralRules2;
    }

    private static void fillC(Map<String, PluralRules> map, String string, int n) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdCardinalRules(n));
        }
    }

    private static void fillO(Map<String, PluralRules> map, String string, int n) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdOrdinalRules(n));
        }
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, PluralRules>();
        PluralProviderSPI.fillC(hashMap, "bm bo dz id ig ii in ja jbo jv jw kde kea km ko lkt", -1);
        PluralProviderSPI.fillC(hashMap, "lo ms my nqo root sah ses sg th to vi wo yo zh", -1);
        PluralProviderSPI.fillC(hashMap, "pt_PT", 0);
        PluralProviderSPI.fillC(hashMap, "am bn fa gu hi kn mr zu", 1);
        PluralProviderSPI.fillC(hashMap, "ff fr hy kab pt", 1);
        PluralProviderSPI.fillC(hashMap, "si", 1);
        PluralProviderSPI.fillC(hashMap, "ak bh guw ln mg nso pa ti wa", 1);
        PluralProviderSPI.fillC(hashMap, "tzm", 2);
        PluralProviderSPI.fillC(hashMap, "is", 3);
        PluralProviderSPI.fillC(hashMap, "mk", 4);
        PluralProviderSPI.fillC(hashMap, "fil tl", 5);
        PluralProviderSPI.fillC(hashMap, "lv prg", 6);
        PluralProviderSPI.fillC(hashMap, "lag ksh", 7);
        PluralProviderSPI.fillC(hashMap, "iu kw naq se sma smi smj smn sms", 8);
        PluralProviderSPI.fillC(hashMap, "shi", 9);
        PluralProviderSPI.fillC(hashMap, "mo ro", 10);
        PluralProviderSPI.fillC(hashMap, "bs hr sh sr", 11);
        PluralProviderSPI.fillC(hashMap, "gd", 12);
        PluralProviderSPI.fillC(hashMap, "sl", 13);
        PluralProviderSPI.fillC(hashMap, "he iw", 14);
        PluralProviderSPI.fillC(hashMap, "cs sk", 15);
        PluralProviderSPI.fillC(hashMap, "pl", 16);
        PluralProviderSPI.fillC(hashMap, "be", 17);
        PluralProviderSPI.fillC(hashMap, "lt", 18);
        PluralProviderSPI.fillC(hashMap, "mt", 19);
        PluralProviderSPI.fillC(hashMap, "ru uk", 17);
        PluralProviderSPI.fillC(hashMap, "br", 20);
        PluralProviderSPI.fillC(hashMap, "ga", 21);
        PluralProviderSPI.fillC(hashMap, "gv", 22);
        PluralProviderSPI.fillC(hashMap, "ar", 23);
        PluralProviderSPI.fillC(hashMap, "cy", 24);
        CARDINAL_MAP.putAll(hashMap);
        ORDINAL_MAP = new HashMap<String, PluralRules>(140);
        STD_ORDINALS = new StdOrdinalRules(0);
        hashMap = new HashMap();
        PluralProviderSPI.fillO(hashMap, "sv", 1);
        PluralProviderSPI.fillO(hashMap, "fil fr hy lo mo ms ro tl vi", 2);
        PluralProviderSPI.fillO(hashMap, "hu", 3);
        PluralProviderSPI.fillO(hashMap, "ne", 4);
        PluralProviderSPI.fillO(hashMap, "kk", 5);
        PluralProviderSPI.fillO(hashMap, "it", 6);
        PluralProviderSPI.fillO(hashMap, "ka", 7);
        PluralProviderSPI.fillO(hashMap, "sq", 8);
        PluralProviderSPI.fillO(hashMap, "en", 9);
        PluralProviderSPI.fillO(hashMap, "mr", 10);
        PluralProviderSPI.fillO(hashMap, "ca", 11);
        PluralProviderSPI.fillO(hashMap, "mk", 12);
        PluralProviderSPI.fillO(hashMap, "az", 13);
        PluralProviderSPI.fillO(hashMap, "gu hi", 14);
        PluralProviderSPI.fillO(hashMap, "bn", 15);
        PluralProviderSPI.fillO(hashMap, "cy", 16);
        ORDINAL_MAP.putAll(hashMap);
    }

    private static class StdOrdinalRules
    extends PluralRules {
        private final int id;

        private StdOrdinalRules(int n) {
            this.id = n;
        }

        public PluralCategory getCategory(long l) {
            long l2 = -1L;
            long l3 = -1L;
            switch (this.id) {
                case 0: {
                    return PluralCategory.OTHER;
                }
                case 1: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if ((l2 == 1L || l2 == 2L) && l3 != 11L && l3 != 12L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 2: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l == 1L || l == 5L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    if (l >= 1L || l <= 4L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 5: {
                    l2 = l % 10L;
                    if (l2 == 6L || l2 == 9L || l2 == 0L && l != 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 6: {
                    if (l == 8L || l == 11L || l == 80L || l == 800L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    l3 = l % 100L;
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 0L || l3 >= 2L && l3 <= 20L || l3 == 40L || l3 == 60L || l3 == 80L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l % 10L == 4L && l % 100L != 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L && l3 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l2 == 3L && l3 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    if (l == 1L || l == 3L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L && l3 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if ((l2 == 7L || l2 == 8L) && l3 != 17L && l3 != 18L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    long l4 = l % 1000L;
                    if (l2 == 1L || l2 == 2L || l2 == 5L || l2 == 7L || l2 == 8L || l3 == 20L || l3 == 50L || l3 == 70L || l3 == 80L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 3L || l2 == 4L || l4 == 100L || l4 == 200L || l4 == 300L || l4 == 400L || l4 == 500L || l4 == 600L || l4 == 700L || l4 == 800L || l4 == 900L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 0L || l2 == 6L || l3 == 40L || l3 == 60L || l3 == 90L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l == 1L || l == 5L || l >= 7L && l <= 10L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l == 0L || l >= 7L && l <= 9L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 3L || l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 5L || l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        public NumberType getNumberType() {
            return NumberType.ORDINALS;
        }
    }

    private static class StdCardinalRules
    extends PluralRules {
        private final int id;

        private StdCardinalRules(int n) {
            this.id = n;
        }

        public PluralCategory getCategory(long l) {
            long l2 = -1L;
            long l3 = -1L;
            switch (this.id) {
                case 0: {
                    return l == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 1: {
                    return l == 0L || l == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 2: {
                    if (l == 0L || l == 1L || l >= 11L && l <= 99L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l % 10L == 1L && l % 100L != 11L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    return l % 10L == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 5: {
                    if (l >= 1L && l <= 3L) {
                        return PluralCategory.ONE;
                    }
                    l2 = l % 10L;
                    if (l2 == 4L || l2 == 6L || l2 == 9L) {
                        return PluralCategory.OTHER;
                    }
                    return PluralCategory.ONE;
                }
                case 6: {
                    if (l % 10L == 0L) {
                        return PluralCategory.ZERO;
                    }
                    l3 = l % 100L;
                    if (l3 >= 11L && l3 <= 19L) {
                        return PluralCategory.ZERO;
                    }
                    if (l % 10L == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    if (l == 0L || l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l >= 2L && l <= 10L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 0L) {
                        return PluralCategory.FEW;
                    }
                    l3 = l % 100L;
                    if (l3 >= 1L && l3 <= 19L && l != 1L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    l3 = l % 100L;
                    if (l % 10L == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l % 10L >= 2L && l % 10L <= 4L && l3 != 12L && l3 != 13L && l3 != 14L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    if (l == 1L || l == 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 3L && l <= 10L || l >= 13L && l <= 19L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    l3 = l % 100L;
                    if (l3 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l3 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l3 == 3L || l3 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 11L && l % 10L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l >= 2L && l <= 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 >= 2L && l2 <= 4L && l3 != 12L && l3 != 13L && l3 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l != 1L && l2 >= 0L && l2 <= 1L || l2 >= 5L && l2 <= 9L || l3 >= 12L && l3 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 17: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 >= 2L && l2 <= 4L && l3 != 12L && l3 != 13L && l3 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l2 == 0L || l2 >= 5L && l2 <= 9L || l3 >= 11L && l3 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 18: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L && (l3 < 11L || l3 > 19L)) {
                        return PluralCategory.ONE;
                    }
                    if (l2 >= 2L && l2 <= 9L && (l3 < 11L || l3 > 19L)) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 19: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    l3 = l % 100L;
                    if (l == 0L || l3 >= 2L && l3 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l3 >= 11L && l3 <= 19L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 20: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L && l3 != 11L && l3 != 71L && l3 != 91L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L && l3 != 12L && l3 != 72L && l3 != 92L) {
                        return PluralCategory.TWO;
                    }
                    if (!(l2 != 3L && l2 != 4L && l2 != 9L || l3 >= 10L && l3 <= 19L || l3 >= 70L && l3 <= 79L || l3 >= 90L && l3 <= 99L)) {
                        return PluralCategory.FEW;
                    }
                    if (l != 0L && l % 1000000L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 21: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 3L && l <= 6L) {
                        return PluralCategory.FEW;
                    }
                    if (l >= 7L && l <= 10L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 22: {
                    l2 = l % 10L;
                    l3 = l % 100L;
                    if (l2 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l2 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l3 == 0L || l3 == 20L || l3 == 40L || l3 == 60L || l3 == 80L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 23: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    l3 = l % 100L;
                    if (l3 >= 3L && l3 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l3 >= 11L && l3 <= 99L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 24: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 3L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        public NumberType getNumberType() {
            return NumberType.CARDINALS;
        }
    }
}

