/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayElement;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.internal.HistoricAttribute;

final class HistoricEraElement
extends DisplayElement<HistoricEra>
implements TextElement<HistoricEra> {
    private static final long serialVersionUID = 5200533417265981438L;
    private static final Locale LATIN = new Locale("la");
    private final ChronoHistory history;

    HistoricEraElement(ChronoHistory chronoHistory) {
        super("ERA");
        this.history = chronoHistory;
    }

    public Class<HistoricEra> getType() {
        return HistoricEra.class;
    }

    public char getSymbol() {
        return 'G';
    }

    public HistoricEra getDefaultMinimum() {
        return HistoricEra.BC;
    }

    public HistoricEra getDefaultMaximum() {
        return HistoricEra.AD;
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print((Enum)chronoDisplay.get((ChronoElement)this)));
    }

    public HistoricEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        return (HistoricEra)this.accessor(attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, HistoricEra> derive(Chronology<T> chronology) {
        if (chronology.isRegistered((ChronoElement)PlainDate.COMPONENT)) {
            return new Rule(this.history);
        }
        return null;
    }

    protected boolean doEquals(BasicElement<?> basicElement) {
        return this.history.equals(((HistoricEraElement)basicElement).history);
    }

    private TextAccessor accessor(AttributeQuery attributeQuery) {
        TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
        if (((Boolean)attributeQuery.get(HistoricAttribute.LATIN_ERA, (Object)Boolean.FALSE)).booleanValue()) {
            CalendarText calendarText = CalendarText.getInstance((String)"historic", (Locale)LATIN);
            return calendarText.getTextForms((ChronoElement)this, new String[]{textWidth == TextWidth.WIDE ? "w" : "a"});
        }
        CalendarText calendarText = CalendarText.getIsoInstance((Locale)((Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT)));
        if (((Boolean)attributeQuery.get(HistoricAttribute.COMMON_ERA, (Object)Boolean.FALSE)).booleanValue()) {
            return calendarText.getTextForms((ChronoElement)this, new String[]{textWidth == TextWidth.WIDE ? "w" : "a", "alt"});
        }
        return calendarText.getEras(textWidth);
    }

    private Object readResolve() throws ObjectStreamException {
        return this.history.era();
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, HistoricEra> {
        private final ChronoHistory history;

        Rule(ChronoHistory chronoHistory) {
            this.history = chronoHistory;
        }

        public HistoricEra getValue(C c) {
            try {
                return this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT)).getEra();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public HistoricEra getMinimum(C c) {
            HistoricEra historicEra = this.getValue(c);
            if (historicEra == HistoricEra.AD) {
                return HistoricEra.BC;
            }
            return historicEra;
        }

        public HistoricEra getMaximum(C c) {
            HistoricEra historicEra = this.getValue(c);
            if (historicEra == HistoricEra.BC) {
                return HistoricEra.AD;
            }
            return historicEra;
        }

        public boolean isValid(C c, HistoricEra historicEra) {
            if (historicEra == null) {
                return false;
            }
            try {
                HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
                return historicDate.getEra() == historicEra;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public C withValue(C c, HistoricEra historicEra, boolean bl) {
            if (historicEra == null) {
                throw new IllegalArgumentException("Missing era value.");
            }
            HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
            if (historicDate.getEra() == historicEra) {
                return c;
            }
            throw new IllegalArgumentException(historicEra.name());
        }

        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }
    }
}

