/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.CalendarAlgorithm;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

final class CutOverEvent {
    final long start;
    final CalendarAlgorithm algorithm;
    final HistoricDate dateAtCutOver;
    final HistoricDate dateBeforeCutOver;

    CutOverEvent(long l, CalendarAlgorithm calendarAlgorithm, CalendarAlgorithm calendarAlgorithm2) {
        this.start = l;
        this.algorithm = calendarAlgorithm2;
        if (l == Long.MIN_VALUE) {
            HistoricDate historicDate;
            this.dateAtCutOver = historicDate = new HistoricDate(HistoricEra.BC, 1000000000, 1, 1);
            this.dateBeforeCutOver = historicDate;
        } else {
            this.dateAtCutOver = this.algorithm.fromMJD(l);
            this.dateBeforeCutOver = calendarAlgorithm.fromMJD(l - 1L);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CutOverEvent) {
            CutOverEvent cutOverEvent = (CutOverEvent)object;
            return this.start == cutOverEvent.start && this.algorithm == cutOverEvent.algorithm && this.dateBeforeCutOver.equals(cutOverEvent.dateBeforeCutOver);
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.start ^ this.start >>> 32);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[start=");
        stringBuilder.append(this.start);
        stringBuilder.append(" (");
        stringBuilder.append(PlainDate.of((long)this.start, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE));
        stringBuilder.append("),algorithm=");
        stringBuilder.append((Object)this.algorithm);
        stringBuilder.append(",date-before-cutover=");
        stringBuilder.append(this.dateBeforeCutOver);
        stringBuilder.append(",date-at-cutover=");
        stringBuilder.append(this.dateAtCutOver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

