/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatEngine;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.SignPolicy;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricEra;
import net.time4j.i18n.UltimateFormatEngine;

public enum PatternType implements ChronoPattern<PatternType>
{
    CLDR,
    SIMPLE_DATE_FORMAT,
    CLDR_24,
    NON_ISO_DATE;


    public FormatEngine<PatternType> getFormatEngine() {
        return UltimateFormatEngine.INSTANCE;
    }

    Map<ChronoElement<?>, ChronoElement<?>> registerSymbol(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (this) {
            case CLDR: {
                return this.cldr(builder, locale, c, n, false);
            }
            case SIMPLE_DATE_FORMAT: {
                return this.sdf(builder, locale, c, n);
            }
            case CLDR_24: {
                return this.cldr24(builder, locale, c, n, false);
            }
            case NON_ISO_DATE: {
                return this.general(builder, c, n);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChronoElement<?>, ChronoElement<?>> cldr(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n, boolean bl) {
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.of(locale);
                TextElement<HistoricEra> textElement = chronoHistory.era();
                builder.addText(textElement);
                builder.endSection();
                HashMap hashMap = new HashMap();
                hashMap.put((ChronoElement<?>)PlainDate.YEAR, (ChronoElement<?>)chronoHistory.yearOfEra());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_OF_YEAR, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.DAY_OF_MONTH, (ChronoElement<?>)chronoHistory.dayOfMonth());
                return hashMap;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR);
                    break;
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, false);
                break;
            }
            case 'Y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE);
                    break;
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE, n, false);
                break;
            }
            case 'u': {
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, true);
                break;
            }
            case 'Q': {
                PatternType.addQuarterOfYear(builder, n);
                break;
            }
            case 'q': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addQuarterOfYear(builder, n);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, bl ? 4 : n));
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'w': {
                PatternType.addNumber((ChronoElement<Integer>)Weekmodel.of((Locale)locale).weekOfYear(), builder, n, bl);
                break;
            }
            case 'W': {
                if (n == 1) {
                    builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.of((Locale)locale).weekOfMonth(), 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'd': {
                PatternType.addNumber((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, builder, n, bl);
                break;
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, n, 3);
                    break;
                }
                if (n == 3 || bl) {
                    builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'F': {
                if (n == 1 || bl) {
                    builder.addFixedInteger((ChronoElement<Integer>)PlainDate.WEEKDAY_IN_MONTH, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'g': {
                builder.addLongNumber((ChronoElement<Long>)EpochDays.MODIFIED_JULIAN_DATE, n, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
                break;
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n <= 2) {
                    builder.addFixedNumerical(Weekmodel.of((Locale)locale).localDayOfWeek(), n);
                    break;
                }
                this.cldr(builder, locale, 'E', n, bl);
                break;
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    if (n == 1) {
                        builder.addFixedNumerical(Weekmodel.of((Locale)locale).localDayOfWeek(), 1);
                        break;
                    }
                    this.cldr(builder, locale, 'E', n, bl);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'a': {
                if (n == 1 || bl) {
                    builder.addText(PlainTime.AM_PM_OF_DAY);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'h': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.CLOCK_HOUR_OF_AMPM, builder, n, bl);
                break;
            }
            case 'H': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.DIGITAL_HOUR_OF_DAY, builder, n, bl);
                break;
            }
            case 'K': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.DIGITAL_HOUR_OF_AMPM, builder, n, bl);
                break;
            }
            case 'k': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.CLOCK_HOUR_OF_DAY, builder, n, bl);
                break;
            }
            case 'm': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.MINUTE_OF_HOUR, builder, n, bl);
                break;
            }
            case 's': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, builder, n, bl);
                break;
            }
            case 'S': {
                builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, n, n, false);
                break;
            }
            case 'A': {
                builder.addInteger((ChronoElement<Integer>)PlainTime.MILLI_OF_DAY, n, 9);
                break;
            }
            case 'z': {
                if (n < 4) {
                    builder.addShortTimezoneName();
                    break;
                }
                if (n == 4 || bl) {
                    builder.addLongTimezoneName();
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'Z': {
                if (n < 4) {
                    builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList("+0000"));
                    break;
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                if (n == 5) {
                    builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList("Z"));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'O': {
                if (n == 1) {
                    builder.addShortLocalizedOffset();
                    break;
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                throw new IllegalArgumentException("Count of pattern letters is not 1 or 4: " + n);
            }
            case 'V': {
                if (n == 2) {
                    try {
                        builder.addTimezoneID();
                        break;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw new IllegalArgumentException(illegalStateException.getMessage());
                    }
                }
                throw new IllegalArgumentException("Count of pattern letters is not 2: " + n);
            }
            case 'X': {
                PatternType.addOffset(builder, n, true);
                break;
            }
            case 'x': {
                PatternType.addOffset(builder, n, false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> sdf(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (c) {
            case 'W': {
                builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.of((Locale)locale).boundedWeekOfMonth(), n);
                break;
            }
            case 'u': {
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, n);
                break;
            }
            case 'S': {
                builder.addFixedInteger((ChronoElement<Integer>)PlainTime.MILLI_OF_SECOND, n);
                break;
            }
            case 'Z': {
                PatternType.addOffset(builder, 2, false);
                break;
            }
            case 'L': 
            case 'O': 
            case 'Q': 
            case 'V': 
            case 'c': 
            case 'e': 
            case 'g': 
            case 'q': 
            case 'x': {
                throw new IllegalArgumentException("CLDR pattern symbol not supported in SimpleDateFormat-style: " + c);
            }
            case 'X': {
                if (n >= 4) {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                return this.cldr(builder, locale, 'X', n, true);
            }
            default: {
                return this.cldr(builder, locale, c, n, true);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr24(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n, boolean bl) {
        if (c == 'H') {
            PatternType.addNumber((ChronoElement<Integer>)PlainTime.ISO_HOUR, builder, n, bl);
            return Collections.emptyMap();
        }
        return this.cldr(builder, locale, c, n, bl);
    }

    private static void addOffset(ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        switch (n) {
            case 1: {
                builder.addTimezoneOffset(DisplayMode.SHORT, false, Collections.singletonList(bl ? "Z" : "+00"));
                break;
            }
            case 2: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 3: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            case 4: {
                builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 5: {
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addNumber(ChronoElement<Integer> chronoElement, ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        if (n == 1) {
            builder.addInteger(chronoElement, 1, 2);
        } else if (n == 2 || bl) {
            builder.addFixedInteger(chronoElement, n);
        } else {
            throw new IllegalArgumentException("Too many pattern letters: " + n);
        }
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: {
                builder.addInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addQuarterOfYear(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: 
            case 2: {
                builder.addFixedNumerical(PlainDate.QUARTER_OF_YEAR, n);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChronoElement<?>, ChronoElement<?>> general(ChronoFormatter.Builder<?> builder, char c, int n) {
        ChronoElement chronoElement;
        ChronoElement chronoElement2;
        TextElement textElement;
        String string;
        Set set = builder.getChronology().getRegisteredElements();
        ChronoElement<?> chronoElement3 = PatternType.find(set, c, string = builder.getChronology().getChronoType().getName());
        if (chronoElement3.getType().isEnum() && chronoElement3 instanceof TextElement) {
            textElement = (TextElement)PatternType.cast(chronoElement3);
            chronoElement2 = (ChronoElement)PatternType.cast(chronoElement3);
            chronoElement = null;
        } else if (Integer.class.isAssignableFrom(chronoElement3.getType())) {
            textElement = null;
            chronoElement2 = null;
            chronoElement = (ChronoElement)PatternType.cast(chronoElement3);
        } else {
            throw new IllegalStateException("Implementation error: " + chronoElement3 + " in \"" + string + "\"");
        }
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)chronoElement);
                    break;
                }
                builder.addYear((ChronoElement<Integer>)chronoElement, n, false);
                break;
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, n), textElement, (ChronoElement<? extends Enum>)chronoElement2);
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n, textElement, (ChronoElement<? extends Enum>)chronoElement2);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'd': {
                PatternType.addNumber((ChronoElement<Integer>)chronoElement, builder, n, false);
                break;
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger((ChronoElement<Integer>)chronoElement, n, 3);
                    break;
                }
                if (n == 3) {
                    builder.addFixedInteger((ChronoElement<Integer>)chronoElement, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptyMap();
    }

    private static ChronoElement<?> find(Set<ChronoElement<?>> set, char c, String string) {
        for (ChronoElement<?> chronoElement : set) {
            if (chronoElement.getSymbol() != c) continue;
            return chronoElement;
        }
        throw new IllegalArgumentException("Cannot find any registered element for symbol " + c + " in \"" + string + "\".");
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n, TextElement<?> textElement, ChronoElement<? extends Enum> chronoElement) {
        switch (n) {
            case 1: {
                builder.addNumerical(chronoElement, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedNumerical(chronoElement, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

