/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class LocalizedGMTProcessor
implements FormatProcessor<TZID> {
    private static final char UNICODE_LRM = '\u200e';
    private final boolean abbreviated;

    LocalizedGMTProcessor(boolean bl) {
        this.abbreviated = bl;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        ZonalOffset zonalOffset;
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        TZID tZID = null;
        if (chronoDisplay.hasTimezone()) {
            tZID = chronoDisplay.getTimezone();
        }
        if (tZID == null) {
            zonalOffset = LocalizedGMTProcessor.getOffset(chronoDisplay, formatStep, attributeQuery);
        } else if (tZID instanceof ZonalOffset) {
            zonalOffset = (ZonalOffset)tZID;
        } else if (chronoDisplay instanceof UnixTime) {
            zonalOffset = Timezone.of((TZID)tZID).getOffset((UnixTime)chronoDisplay);
        } else {
            throw new IllegalArgumentException("Cannot extract timezone offset from: " + chronoDisplay);
        }
        Locale locale = formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT);
        String string = CalendarText.getGMTPrefix((Locale)locale);
        appendable.append(string);
        int n2 = string.length();
        int n3 = zonalOffset.getIntegralAmount();
        int n4 = zonalOffset.getFractionalAmount();
        if (n3 != 0 || n4 != 0) {
            if ("ar".equals(locale.getLanguage())) {
                appendable.append('\u200e');
                ++n2;
            }
            appendable.append(zonalOffset.getSign() == OffsetSign.BEHIND_UTC ? (char)'-' : '+');
            ++n2;
            int n5 = zonalOffset.getAbsoluteHours();
            int n6 = zonalOffset.getAbsoluteMinutes();
            if (n5 < 10 && !this.abbreviated) {
                appendable.append('0');
                ++n2;
            }
            String string2 = String.valueOf(n5);
            for (int i = 0; i < string2.length(); ++i) {
                appendable.append(string2.charAt(i));
                ++n2;
            }
            if (n6 != 0 || !this.abbreviated) {
                appendable.append(':');
                ++n2;
                if (n6 < 10) {
                    appendable.append('0');
                    ++n2;
                }
                String string3 = String.valueOf(n6);
                for (int i = 0; i < string3.length(); ++i) {
                    appendable.append(string3.charAt(i));
                    ++n2;
                }
            }
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        OffsetSign offsetSign;
        String string;
        int n;
        String string22;
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing localized GMT offset.");
            return;
        }
        Locale locale = formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT);
        String string3 = CalendarText.getGMTPrefix((Locale)locale);
        String[] stringArray = new String[]{"GMT", string3, "UTC", "UT"};
        boolean bl = false;
        boolean bl2 = formatStep.getAttribute(Attributes.PARSE_CASE_INSENSITIVE, attributeQuery, Boolean.TRUE);
        for (String string22 : stringArray) {
            n = string22.length();
            if (n2 - n4 < n) continue;
            string = charSequence.subSequence(n4, n4 + n).toString();
            if ((!bl2 || !string.equalsIgnoreCase(string22)) && (bl2 || !string.equals(string22))) continue;
            bl = true;
            n4 += n;
            break;
        }
        if (!bl) {
            parseLog.setError(n3, "Missing prefix in localized offset: " + string3);
            return;
        }
        if (n4 >= n2) {
            map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n4);
            return;
        }
        char c = charSequence.charAt(n4);
        if (c == '\u200e' && "ar".equals(locale.getLanguage())) {
            if (n4 + 1 >= n2) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
                parseLog.setPosition(n4);
                return;
            }
            c = charSequence.charAt(++n4);
        }
        if (c == '+') {
            offsetSign = OffsetSign.AHEAD_OF_UTC;
            ++n4;
        } else if (c == '-') {
            offsetSign = OffsetSign.BEHIND_UTC;
            ++n4;
        } else {
            map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.UTC);
            parseLog.setPosition(n4);
            return;
        }
        int n5 = LocalizedGMTProcessor.parseHours(charSequence, n4);
        if (n5 == -1000) {
            parseLog.setError(n4, "Missing hour part in localized GMT offset.");
            return;
        }
        if (n5 < 0) {
            n5 ^= 0xFFFFFFFF;
            ++n4;
        } else {
            n4 += 2;
        }
        if (n4 >= n2) {
            if (this.abbreviated) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)offsetSign, (int)n5));
                parseLog.setPosition(n4);
            } else {
                parseLog.setError(n4, "Missing minute part in localized GMT offset.");
            }
            return;
        }
        string22 = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        if (charSequence.charAt(n4) == ':') {
            ++n4;
        } else {
            if (this.abbreviated) {
                map.put(TimezoneElement.TIMEZONE_OFFSET, ZonalOffset.ofHours((OffsetSign)offsetSign, (int)n5));
                parseLog.setPosition(n4);
                return;
            }
            if (string22.isStrict()) {
                parseLog.setError(n4, "Colon expected in localized GMT offset.");
                return;
            }
        }
        n = LocalizedGMTProcessor.parseMinutes(charSequence, n4);
        if (n == -1000) {
            parseLog.setError(n4, "Minute part in localized GMT offset does not match expected pattern mm.");
            return;
        }
        string = ZonalOffset.ofHoursMinutes((OffsetSign)offsetSign, (int)n5, (int)n);
        map.put(TimezoneElement.TIMEZONE_OFFSET, string);
        parseLog.setPosition(n4 += 2);
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_OFFSET;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private static ZonalOffset getOffset(ChronoDisplay chronoDisplay, FormatStep formatStep, AttributeQuery attributeQuery) {
        TZID tZID;
        AttributeQuery attributeQuery2 = formatStep.getQuery(attributeQuery);
        if (attributeQuery2.contains(Attributes.TIMEZONE_ID) && (tZID = (TZID)attributeQuery2.get(Attributes.TIMEZONE_ID)) instanceof ZonalOffset) {
            return (ZonalOffset)tZID;
        }
        throw new IllegalArgumentException("Cannot extract timezone offset from format attributes for: " + chronoDisplay);
    }

    private static int parseMinutes(CharSequence charSequence, int n) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            int n3 = n + i >= charSequence.length() ? 0 : (int)charSequence.charAt(n + i);
            if (n3 < 48 || n3 > 57) {
                return -1000;
            }
            n2 = n2 * 10 + (n3 - 48);
        }
        return n2;
    }

    private static int parseHours(CharSequence charSequence, int n) {
        int n2 = 0;
        for (int i = 0; i < 2; ++i) {
            int n3 = n + i >= charSequence.length() ? 0 : (int)charSequence.charAt(n + i);
            if (n3 < 48 || n3 > 57) {
                if (i == 0) {
                    return -1000;
                }
                return ~n2;
            }
            n2 = n2 * 10 + (n3 - 48);
        }
        return n2;
    }
}

