/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.Serializable;
import java.util.Map;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.NonAmbivalentMap;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.TZID;

class ParsedValues
extends ChronoEntity<ParsedValues>
implements Serializable {
    private static final long serialVersionUID = 6400471321200669320L;
    private final NonAmbivalentMap map;

    ParsedValues() {
        this.map = new NonAmbivalentMap();
    }

    ParsedValues(NonAmbivalentMap nonAmbivalentMap) {
        nonAmbivalentMap.remove(null);
        this.map = nonAmbivalentMap;
    }

    public boolean contains(ChronoElement<?> chronoElement) {
        return this.map.containsKey(chronoElement);
    }

    public <V> V get(ChronoElement<V> chronoElement) {
        Object t = chronoElement.getType().cast(this.map.get(chronoElement));
        if (t == null) {
            throw new ChronoException("No value found for: " + chronoElement.name());
        }
        return (V)t;
    }

    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return true;
    }

    public <V> ParsedValues with(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        if (v == null) {
            this.map.remove(chronoElement);
        } else {
            this.map.put(chronoElement, v);
        }
        return this;
    }

    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMinimum();
    }

    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMaximum();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ParsedValues) {
            ParsedValues parsedValues = (ParsedValues)object;
            return this.map.equals(parsedValues.map);
        }
        return false;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('{');
        for (ChronoElement chronoElement : this.map.keySet()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(this.map.get(chronoElement));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    protected Chronology<ParsedValues> getChronology() {
        throw new UnsupportedOperationException("Parsed values do not have any chronology.");
    }

    public boolean hasTimezone() {
        return this.map.containsKey((Object)TimezoneElement.TIMEZONE_ID) || this.map.containsKey((Object)TimezoneElement.TIMEZONE_OFFSET);
    }

    public TZID getTimezone() {
        Object var1_1 = null;
        if (this.map.containsKey((Object)TimezoneElement.TIMEZONE_ID)) {
            var1_1 = this.map.get((Object)TimezoneElement.TIMEZONE_ID);
        } else if (this.map.containsKey((Object)TimezoneElement.TIMEZONE_OFFSET)) {
            var1_1 = this.map.get((Object)TimezoneElement.TIMEZONE_OFFSET);
        }
        if (var1_1 instanceof TZID) {
            return (TZID)TZID.class.cast(var1_1);
        }
        return super.getTimezone();
    }

    Map<ChronoElement<?>, Object> toMap() {
        return this.map;
    }

    void setNoAmbivalentCheck() {
        this.map.setChecking(false);
    }
}

