/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricVariant;

final class SPX
implements Externalizable {
    static final int VERSION_1 = 1;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: {
                this.writeHistory(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch ((by & 0xFF) >> 4) {
            case 1: {
                this.obj = this.readHistory(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHistory(ObjectOutput objectOutput) throws IOException {
        ChronoHistory chronoHistory = (ChronoHistory)this.obj;
        int n = chronoHistory.getVariant().getSerialValue();
        int n2 = this.type;
        n2 <<= 4;
        objectOutput.writeByte(n2 |= n);
        if (chronoHistory.getVariant() == HistoricVariant.SINGLE_CUTOVER_DATE) {
            objectOutput.writeLong(chronoHistory.getEvents().get((int)0).start);
        }
    }

    private ChronoHistory readHistory(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n = by & 0xF;
        HistoricVariant historicVariant = SPX.getEnum(n);
        switch (historicVariant) {
            case PROLEPTIC_GREGORIAN: {
                return ChronoHistory.PROLEPTIC_GREGORIAN;
            }
            case PROLEPTIC_JULIAN: {
                return ChronoHistory.PROLEPTIC_JULIAN;
            }
            case SWEDEN: {
                return ChronoHistory.ofSweden();
            }
            case INTRODUCTION_ON_1582_10_15: {
                return ChronoHistory.ofFirstGregorianReform();
            }
        }
        long l = objectInput.readLong();
        return ChronoHistory.ofGregorianReform(PlainDate.of((long)l, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE));
    }

    private static HistoricVariant getEnum(int n) throws StreamCorruptedException {
        for (HistoricVariant historicVariant : HistoricVariant.values()) {
            if (historicVariant.getSerialValue() != n) continue;
            return historicVariant;
        }
        throw new StreamCorruptedException("Unknown variant of chronological history.");
    }
}

