/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.chrono.IsoEra;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import net.time4j.format.OutputContext;
import net.time4j.format.TextProvider;
import net.time4j.format.TextWidth;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class IsoTextProviderSPI
implements TextProvider {
    private static final Set<String> LANGUAGES;
    private static final Set<Locale> LOCALES;

    public String[] getSupportedCalendarTypes() {
        return new String[]{"iso8601"};
    }

    public Locale[] getAvailableLocales() {
        return LOCALES.toArray(new Locale[LOCALES.size()]);
    }

    public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
        return IsoTextProviderSPI.months(locale, textWidth, outputContext);
    }

    public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.quarters(locale, textWidth, outputContext);
    }

    public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return IsoTextProviderSPI.weekdays(locale, textWidth, outputContext);
    }

    public String[] eras(String string, Locale locale, TextWidth textWidth) {
        return IsoTextProviderSPI.eras(locale, textWidth);
    }

    public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
        return IsoTextProviderSPI.meridiems(locale, textWidth);
    }

    public ResourceBundle.Control getControl() {
        return UTF8ResourceControl.SINGLETON;
    }

    public String toString() {
        return "IsoTextProviderSPI";
    }

    static Set<String> getPrimaryLanguages() {
        return LANGUAGES;
    }

    private static String[] months(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String[] stringArray;
            boolean bl;
            String string = IsoTextProviderSPI.getKey(resourceBundle, "MONTH_OF_YEAR");
            boolean bl2 = bl = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone"));
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = bl ? IsoTextProviderSPI.lookupBundle(resourceBundle, 12, string, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 12, string, textWidth)) == null) {
                if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.months(locale, TextWidth.ABBREVIATED, outputContext);
                    if (stringArray == null) {
                        if (bl) {
                            stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.FORMAT);
                        }
                        if (stringArray == null) {
                            throw new MissingResourceException("Cannot find ISO-8601-month.", IsoTextProviderSPI.class.getName(), locale.toString());
                        }
                    }
                    return IsoTextProviderSPI.narrow(stringArray, 12);
                }
                if (bl) {
                    stringArray = IsoTextProviderSPI.months(locale, textWidth, OutputContext.FORMAT);
                }
                if (stringArray == null) {
                    throw new MissingResourceException("Cannot find ISO-8601-month.", IsoTextProviderSPI.class.getName(), locale.toString());
                }
            }
            return stringArray;
        }
        if (locale.getLanguage().isEmpty()) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        }
        TextStyle textStyle = IsoTextProviderSPI.getStyle(textWidth, outputContext);
        String[] stringArray = new String[12];
        int n = 0;
        for (Month month : Month.values()) {
            stringArray[n] = month.getDisplayName(textStyle, locale);
            ++n;
        }
        return stringArray;
    }

    private static String[] quarters(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String[] stringArray;
            boolean bl;
            String string = IsoTextProviderSPI.getKey(resourceBundle, "QUARTER_OF_YEAR");
            boolean bl2 = bl = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone"));
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = bl ? IsoTextProviderSPI.lookupBundle(resourceBundle, 4, string, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 4, string, textWidth)) == null) {
                if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.quarters(locale, TextWidth.ABBREVIATED, outputContext);
                    if (stringArray == null) {
                        if (bl) {
                            stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.FORMAT);
                        }
                        if (stringArray == null) {
                            throw new MissingResourceException("Cannot find ISO-8601-quarter-of-year.", IsoTextProviderSPI.class.getName(), locale.toString());
                        }
                    }
                    return IsoTextProviderSPI.narrow(stringArray, 4);
                }
                if (bl) {
                    stringArray = IsoTextProviderSPI.quarters(locale, textWidth, OutputContext.FORMAT);
                }
                if (stringArray == null) {
                    throw new MissingResourceException("Cannot find ISO-8601-quarter-of-year.", IsoTextProviderSPI.class.getName(), locale.toString());
                }
            }
            return stringArray;
        }
        if (locale.getLanguage().isEmpty()) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }
        TextStyle textStyle = IsoTextProviderSPI.getStyle(textWidth, outputContext);
        String[] stringArray = new String[4];
        for (int i = 0; i < 4; ++i) {
            LocalDate localDate = LocalDate.of(1970, i * 3 + 1, 1);
            stringArray[i] = new DateTimeFormatterBuilder().appendText(IsoFields.QUARTER_OF_YEAR, textStyle).toFormatter(locale).format(localDate);
        }
        return stringArray;
    }

    private static String[] weekdays(Locale locale, TextWidth textWidth, OutputContext outputContext) throws MissingResourceException {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String string = IsoTextProviderSPI.getKey(resourceBundle, "DAY_OF_WEEK");
            boolean bl = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone"));
            String[] stringArray = bl ? IsoTextProviderSPI.lookupBundle(resourceBundle, 7, string, textWidth, outputContext) : IsoTextProviderSPI.lookupBundle(resourceBundle, 7, string, textWidth);
            if (stringArray == null) {
                if (textWidth == TextWidth.NARROW) {
                    stringArray = IsoTextProviderSPI.narrow(IsoTextProviderSPI.weekdays(locale, TextWidth.SHORT, outputContext), 7);
                } else if (textWidth == TextWidth.SHORT) {
                    stringArray = IsoTextProviderSPI.weekdays(locale, TextWidth.ABBREVIATED, outputContext);
                    if (stringArray == null && bl) {
                        stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.FORMAT);
                    }
                } else if (bl) {
                    stringArray = IsoTextProviderSPI.weekdays(locale, textWidth, OutputContext.FORMAT);
                }
            }
            if (stringArray == null) {
                throw new MissingResourceException("Cannot find ISO-8601-weekday.", IsoTextProviderSPI.class.getName(), locale.toString());
            }
            return stringArray;
        }
        if (locale.getLanguage().isEmpty()) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }
        TextStyle textStyle = IsoTextProviderSPI.getStyle(textWidth, outputContext);
        String[] stringArray = new String[7];
        int n = 0;
        for (DayOfWeek dayOfWeek : DayOfWeek.values()) {
            stringArray[n] = dayOfWeek.getDisplayName(textStyle, locale);
            ++n;
        }
        return stringArray;
    }

    private static String[] eras(Locale locale, TextWidth textWidth) throws MissingResourceException {
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null) {
            String string;
            String[] stringArray;
            if (textWidth == TextWidth.SHORT) {
                textWidth = TextWidth.ABBREVIATED;
            }
            if ((stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 2, string = IsoTextProviderSPI.getKey(resourceBundle, "ERA"), textWidth)) != null) {
                return stringArray;
            }
            if (textWidth == TextWidth.NARROW) {
                return IsoTextProviderSPI.narrow(IsoTextProviderSPI.eras(locale, TextWidth.ABBREVIATED), 2);
            }
            throw new MissingResourceException("Cannot find ISO-8601-resource for era.", IsoTextProviderSPI.class.getName(), locale.toString());
        }
        if (locale.getLanguage().isEmpty()) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }
        TextStyle textStyle = IsoTextProviderSPI.getStyle(textWidth, OutputContext.FORMAT);
        String[] stringArray = new String[2];
        int n = 0;
        for (IsoEra isoEra : IsoEra.values()) {
            stringArray[n] = isoEra.getDisplayName(textStyle, locale);
            ++n;
        }
        return stringArray;
    }

    private static String[] meridiems(Locale locale, TextWidth textWidth) throws MissingResourceException {
        Object object;
        String[] stringArray;
        ResourceBundle resourceBundle = IsoTextProviderSPI.getBundle(locale);
        if (resourceBundle != null && (stringArray = IsoTextProviderSPI.lookupBundle(resourceBundle, 2, object = IsoTextProviderSPI.getKey(resourceBundle, "AM_PM_OF_DAY"), textWidth)) != null) {
            return stringArray;
        }
        if (locale.getLanguage().isEmpty()) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }
        object = IsoTextProviderSPI.getStyle(textWidth, OutputContext.FORMAT);
        stringArray = new String[2];
        for (int i = 0; i < 2; ++i) {
            LocalTime localTime = LocalTime.of(i * 12, 0);
            stringArray[i] = new DateTimeFormatterBuilder().appendText((TemporalField)ChronoField.AMPM_OF_DAY, (TextStyle)((Object)object)).toFormatter(locale).format(localTime);
        }
        return stringArray;
    }

    private static String[] narrow(String[] stringArray, int n) {
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = !stringArray[i].isEmpty() ? IsoTextProviderSPI.toSingleLetter(stringArray[i]) : String.valueOf(i + 1);
        }
        return stringArray2;
    }

    private static String toSingleLetter(String string) {
        char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
        if (c >= 'A' && c <= 'Z') {
            return String.valueOf(c);
        }
        if (c >= 'a' && c <= 'z') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        if (c >= '\u0410' && c <= '\u042f') {
            return String.valueOf(c);
        }
        if (c >= '\u0430' && c <= '\u044f') {
            c = (char)(c - 32);
            return String.valueOf(c);
        }
        return string;
    }

    private static ResourceBundle getBundle(Locale locale) throws MissingResourceException {
        if (LANGUAGES.contains(LanguageMatch.getAlias(locale))) {
            return ResourceBundle.getBundle("calendar/iso8601", locale, IsoTextProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        return null;
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth) {
        return IsoTextProviderSPI.lookupBundle(resourceBundle, n, string, textWidth, null);
    }

    private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext) {
        String[] stringArray = new String[n];
        boolean bl = string.length() == 1;
        for (int i = 0; i < n; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(string);
            stringBuilder.append('(');
            if (bl) {
                char c = textWidth.name().charAt(0);
                if (outputContext != OutputContext.STANDALONE) {
                    c = Character.toLowerCase(c);
                }
                stringBuilder.append(c);
            } else {
                stringBuilder.append(textWidth.name());
                if (outputContext == OutputContext.STANDALONE) {
                    stringBuilder.append('|');
                    stringBuilder.append(outputContext.name());
                }
            }
            stringBuilder.append(')');
            stringBuilder.append('_');
            stringBuilder.append(i + 1);
            String string2 = stringBuilder.toString();
            if (!resourceBundle.containsKey(string2)) {
                return null;
            }
            stringArray[i] = resourceBundle.getString(string2);
        }
        return stringArray;
    }

    private static String getKey(ResourceBundle resourceBundle, String string) {
        if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
            return string.substring(0, 1);
        }
        return string;
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = IsoTextProviderSPI.getDefaultLoader();
        }
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    private static ClassLoader getDefaultLoader() {
        return IsoTextProviderSPI.class.getClassLoader();
    }

    private static TextStyle getStyle(TextWidth textWidth, OutputContext outputContext) {
        boolean bl = outputContext == OutputContext.STANDALONE;
        switch (textWidth) {
            case WIDE: {
                return bl ? TextStyle.FULL_STANDALONE : TextStyle.FULL;
            }
            case ABBREVIATED: 
            case SHORT: {
                return bl ? TextStyle.SHORT_STANDALONE : TextStyle.SHORT;
            }
            case NARROW: {
                return bl ? TextStyle.NARROW_STANDALONE : TextStyle.NARROW;
            }
        }
        throw new UnsupportedOperationException(textWidth.name());
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("calendar/iso8601", Locale.ROOT, IsoTextProviderSPI.getDefaultLoader(), UTF8ResourceControl.SINGLETON);
        String[] stringArray = resourceBundle.getString("languages").split(" ");
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        LANGUAGES = Collections.unmodifiableSet(hashSet);
        HashSet<Locale> hashSet2 = new HashSet<Locale>();
        for (Locale locale : DateFormatSymbols.getAvailableLocales()) {
            if (locale.getLanguage().isEmpty()) continue;
            hashSet2.add(locale);
        }
        for (String string : LANGUAGES) {
            hashSet2.add(new Locale(string));
        }
        LOCALES = Collections.unmodifiableSet(hashSet2);
    }
}

