/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.util.Arrays;
import net.time4j.history.Calculus;
import net.time4j.history.CalendarAlgorithm;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;

public final class AncientJulianLeapYears {
    private static final int[] SEQUENCE_SCALIGER = new int[]{42, 39, 36, 33, 30, 27, 24, 21, 18, 15, 12, 9};
    private static final HistoricDate AD8 = HistoricDate.of(HistoricEra.AD, 8, 1, 1);
    private static final HistoricDate BC45 = HistoricDate.of(HistoricEra.BC, 45, 1, 1);
    private static final long MJD_OF_AD8 = -676021L;
    public static final AncientJulianLeapYears SCALIGER = new AncientJulianLeapYears(SEQUENCE_SCALIGER);
    private final int[] leaps;
    private final Calculus calculus;

    private AncientJulianLeapYears(int ... nArray) {
        int n;
        int[] nArray2 = new int[nArray.length];
        for (n = 0; n < nArray.length; ++n) {
            nArray2[n] = 1 - nArray[n];
        }
        Arrays.sort(nArray2);
        this.leaps = nArray2;
        if (this.leaps.length == 0) {
            throw new IllegalArgumentException("Missing leap years.");
        }
        if (this.leaps[0] < -44 || this.leaps[this.leaps.length - 1] >= 8) {
            throw new IllegalArgumentException("Out of range: " + Arrays.toString(nArray));
        }
        n = nArray2[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray2[i] == n) {
                throw new IllegalArgumentException("Contains duplicates: " + Arrays.toString(nArray));
            }
            n = nArray2[i];
        }
        this.calculus = new Calculus(){

            @Override
            public long toMJD(HistoricDate historicDate) {
                int n;
                if (historicDate.compareTo(AD8) >= 0) {
                    return CalendarAlgorithm.JULIAN.toMJD(historicDate);
                }
                if (historicDate.compareTo(BC45) < 0) {
                    throw new IllegalArgumentException("Not valid before BC 45: " + historicDate);
                }
                long l = -676021L;
                int n2 = this.getProlepticYear(historicDate);
                for (n = 7; n >= n2; --n) {
                    if (this.isLeapYear(n)) {
                        l -= 366L;
                        continue;
                    }
                    l -= 365L;
                }
                for (n = 1; n < historicDate.getMonth(); ++n) {
                    l += (long)this.getMaximumDayOfMonth(n2, n);
                }
                return l + (long)historicDate.getDayOfMonth() - 1L;
            }

            @Override
            public HistoricDate fromMJD(long l) {
                if (l >= -676021L) {
                    return CalendarAlgorithm.JULIAN.fromMJD(l);
                }
                long l2 = -676021L;
                for (int i = 7; i >= -44; --i) {
                    l2 = this.isLeapYear(i) ? (l2 -= 366L) : (l2 -= 365L);
                    if (l2 > l) continue;
                    for (int j = 1; j <= 12; ++j) {
                        int n = this.getMaximumDayOfMonth(i, j);
                        if (l2 + (long)n > l) {
                            HistoricEra historicEra = i <= 0 ? HistoricEra.BC : HistoricEra.AD;
                            int n2 = i <= 0 ? 1 - i : i;
                            return HistoricDate.of(historicEra, n2, j, (int)(l - l2 + 1L));
                        }
                        l2 += (long)n;
                    }
                }
                throw new IllegalArgumentException("Not valid before BC 45: " + l);
            }

            @Override
            public boolean isValid(HistoricDate historicDate) {
                if (historicDate != null && (historicDate.getEra() == HistoricEra.AD || historicDate.getYearOfEra() <= 45)) {
                    int n = this.getProlepticYear(historicDate);
                    if (n >= 8) {
                        return CalendarAlgorithm.JULIAN.isValid(historicDate);
                    }
                    return historicDate.getDayOfMonth() <= this.getMaximumDayOfMonth(n, historicDate.getMonth());
                }
                return false;
            }

            @Override
            public int getMaximumDayOfMonth(HistoricDate historicDate) {
                if (historicDate.compareTo(AD8) >= 0) {
                    return CalendarAlgorithm.JULIAN.getMaximumDayOfMonth(historicDate);
                }
                if (historicDate.compareTo(BC45) < 0) {
                    throw new IllegalArgumentException("Not valid before BC 45: " + historicDate);
                }
                return this.getMaximumDayOfMonth(this.getProlepticYear(historicDate), historicDate.getMonth());
            }

            private int getMaximumDayOfMonth(int n, int n2) {
                switch (n2) {
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 12: {
                        return 31;
                    }
                    case 4: 
                    case 6: 
                    case 9: 
                    case 11: {
                        return 30;
                    }
                    case 2: {
                        return this.isLeapYear(n) ? 29 : 28;
                    }
                }
                throw new IllegalArgumentException("Invalid month: " + n2);
            }

            private int getProlepticYear(HistoricDate historicDate) {
                return historicDate.getEra() == HistoricEra.BC ? 1 - historicDate.getYearOfEra() : historicDate.getYearOfEra();
            }

            private boolean isLeapYear(int n) {
                return Arrays.binarySearch(AncientJulianLeapYears.this.leaps, n) >= 0;
            }
        };
    }

    public static AncientJulianLeapYears of(int ... nArray) {
        if (Arrays.equals(nArray, SEQUENCE_SCALIGER)) {
            return SCALIGER;
        }
        return new AncientJulianLeapYears(nArray);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AncientJulianLeapYears) {
            AncientJulianLeapYears ancientJulianLeapYears = (AncientJulianLeapYears)object;
            return this.leaps == ancientJulianLeapYears.leaps;
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.leaps);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.leaps.length; ++i) {
            int n;
            if (i > 0) {
                stringBuilder.append(", ");
            }
            if ((n = 1 - this.leaps[i]) > 0) {
                stringBuilder.append("BC ");
                stringBuilder.append(n);
                continue;
            }
            stringBuilder.append("AD ");
            stringBuilder.append(this.leaps[i]);
        }
        return stringBuilder.toString();
    }

    int[] getPattern() {
        return this.leaps;
    }

    Calculus getCalculus() {
        return this.calculus;
    }
}

