/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.Weekday;
import net.time4j.base.ResourceLoader;
import net.time4j.format.WeekdataProvider;

public class WeekdataProviderSPI
implements WeekdataProvider {
    static final Map<String, Weekday> START_OF_WEEKEND;
    static final Map<String, Weekday> END_OF_WEEKEND;
    private final String source;
    private final Map<String, Weekday> startOfWeekend;
    private final Map<String, Weekday> endOfWeekend;

    public WeekdataProviderSPI() {
        String string = "data/weekend.data";
        URI uRI = ResourceLoader.getInstance().locate("i18n", WeekdataProviderSPI.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream != null) {
            this.source = "@" + uRI;
            HashMap<String, Weekday> hashMap = new HashMap<String, Weekday>(START_OF_WEEKEND.size());
            HashMap hashMap2 = new HashMap(END_OF_WEEKEND.size());
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    HashMap<String, Weekday> hashMap3;
                    Weekday weekday;
                    String[] stringArray;
                    if (string2.startsWith("#")) continue;
                    int n = string2.indexOf(61);
                    String string3 = string2.substring(0, n).trim();
                    String[] stringArray2 = string2.substring(n + 1).split(" ");
                    if (string3.startsWith("start-")) {
                        stringArray = string3.substring(6);
                        weekday = Weekday.SATURDAY;
                        hashMap3 = hashMap;
                    } else if (string3.startsWith("end-")) {
                        stringArray = string3.substring(4);
                        weekday = Weekday.SUNDAY;
                        hashMap3 = hashMap2;
                    } else {
                        throw new IllegalStateException("Unexpected format: " + this.source);
                    }
                    switch (stringArray) {
                        case "sun": {
                            weekday = Weekday.SUNDAY;
                            break;
                        }
                        case "sat": {
                            weekday = Weekday.SATURDAY;
                            break;
                        }
                        case "fri": {
                            weekday = Weekday.FRIDAY;
                            break;
                        }
                        case "thu": {
                            weekday = Weekday.THURSDAY;
                            break;
                        }
                        case "wed": {
                            weekday = Weekday.WEDNESDAY;
                            break;
                        }
                        case "tue": {
                            weekday = Weekday.TUESDAY;
                            break;
                        }
                        case "mon": {
                            weekday = Weekday.MONDAY;
                        }
                    }
                    for (String string4 : stringArray2) {
                        String string5 = string4.trim().toUpperCase(Locale.US);
                        if (string5.isEmpty()) continue;
                        hashMap3.put(string5, weekday);
                    }
                }
                this.startOfWeekend = Collections.unmodifiableMap(hashMap);
                this.endOfWeekend = Collections.unmodifiableMap(hashMap2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unexpected format: " + this.source, exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        this.source = "@STATIC";
        this.startOfWeekend = START_OF_WEEKEND;
        this.endOfWeekend = END_OF_WEEKEND;
        System.out.println("Warning: File \"" + string + "\" not found.");
    }

    public int getFirstDayOfWeek(Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        int n = gregorianCalendar.getFirstDayOfWeek();
        return n == 1 ? 7 : n - 1;
    }

    public int getMinimalDaysInFirstWeek(Locale locale) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
        return gregorianCalendar.getMinimalDaysInFirstWeek();
    }

    public int getStartOfWeekend(Locale locale) {
        String string = locale.getCountry();
        Weekday weekday = Weekday.SATURDAY;
        if (this.startOfWeekend.containsKey(string)) {
            weekday = this.startOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public int getEndOfWeekend(Locale locale) {
        String string = locale.getCountry();
        Weekday weekday = Weekday.SUNDAY;
        if (this.endOfWeekend.containsKey(string)) {
            weekday = this.endOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public String toString() {
        return this.getClass().getName() + this.source;
    }

    static {
        HashMap<String, Weekday> hashMap = new HashMap<String, Weekday>(28);
        hashMap.put("AF", Weekday.THURSDAY);
        hashMap.put("DZ", Weekday.THURSDAY);
        hashMap.put("IR", Weekday.THURSDAY);
        hashMap.put("OM", Weekday.THURSDAY);
        hashMap.put("SA", Weekday.THURSDAY);
        hashMap.put("YE", Weekday.THURSDAY);
        hashMap.put("AE", Weekday.FRIDAY);
        hashMap.put("BH", Weekday.FRIDAY);
        hashMap.put("EG", Weekday.FRIDAY);
        hashMap.put("IL", Weekday.FRIDAY);
        hashMap.put("IQ", Weekday.FRIDAY);
        hashMap.put("JO", Weekday.FRIDAY);
        hashMap.put("KW", Weekday.FRIDAY);
        hashMap.put("LY", Weekday.FRIDAY);
        hashMap.put("MA", Weekday.FRIDAY);
        hashMap.put("QA", Weekday.FRIDAY);
        hashMap.put("SD", Weekday.FRIDAY);
        hashMap.put("SY", Weekday.FRIDAY);
        hashMap.put("TN", Weekday.FRIDAY);
        hashMap.put("IN", Weekday.SUNDAY);
        START_OF_WEEKEND = Collections.unmodifiableMap(hashMap);
        hashMap = new HashMap(25);
        hashMap.put("AF", Weekday.FRIDAY);
        hashMap.put("DZ", Weekday.FRIDAY);
        hashMap.put("IR", Weekday.FRIDAY);
        hashMap.put("OM", Weekday.FRIDAY);
        hashMap.put("SA", Weekday.FRIDAY);
        hashMap.put("YE", Weekday.FRIDAY);
        hashMap.put("AE", Weekday.SATURDAY);
        hashMap.put("BH", Weekday.SATURDAY);
        hashMap.put("EG", Weekday.SATURDAY);
        hashMap.put("IL", Weekday.SATURDAY);
        hashMap.put("IQ", Weekday.SATURDAY);
        hashMap.put("JO", Weekday.SATURDAY);
        hashMap.put("KW", Weekday.SATURDAY);
        hashMap.put("LY", Weekday.SATURDAY);
        hashMap.put("MA", Weekday.SATURDAY);
        hashMap.put("QA", Weekday.SATURDAY);
        hashMap.put("SD", Weekday.SATURDAY);
        hashMap.put("SY", Weekday.SATURDAY);
        hashMap.put("TN", Weekday.SATURDAY);
        END_OF_WEEKEND = Collections.unmodifiableMap(hashMap);
    }
}

