/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ParseLog;

public final class MultiFormatParser<T extends ChronoEntity<T>>
implements ChronoParser<T> {
    private final List<ChronoFormatter<T>> parsers;

    private MultiFormatParser(List<ChronoFormatter<T>> list) {
        this.parsers = Collections.unmodifiableList(list);
        for (ChronoFormatter<T> chronoFormatter : this.parsers) {
            if (chronoFormatter != null) continue;
            throw new NullPointerException("Null format cannot be set.");
        }
    }

    @SafeVarargs
    public static <T extends ChronoEntity<T>> MultiFormatParser<T> of(ChronoFormatter<T> ... chronoFormatterArray) {
        List<ChronoFormatter<T>> list = Arrays.asList(chronoFormatterArray);
        return new MultiFormatParser<T>(list);
    }

    public static <T extends ChronoEntity<T>> MultiFormatParser<T> of(List<ChronoFormatter<T>> list) {
        ArrayList<ChronoFormatter<T>> arrayList = new ArrayList<ChronoFormatter<T>>(list);
        return new MultiFormatParser<T>(arrayList);
    }

    public T parse(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        T t = this.parse(charSequence, parseLog);
        if (t == null) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return t;
    }

    public T parse(CharSequence charSequence, ParseLog parseLog) {
        int n = parseLog.getPosition();
        for (ChronoFormatter<T> chronoFormatter : this.parsers) {
            parseLog.reset();
            parseLog.setPosition(n);
            T t = chronoFormatter.parse(charSequence, parseLog);
            if (t == null || parseLog.isError()) continue;
            return t;
        }
        parseLog.setError(parseLog.getErrorIndex(), "Not matched by any format: " + charSequence);
        return null;
    }

    @Override
    public T parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        int n = parseLog.getPosition();
        for (ChronoFormatter<T> chronoFormatter : this.parsers) {
            parseLog.reset();
            parseLog.setPosition(n);
            T t = chronoFormatter.parse(charSequence, parseLog, attributeQuery);
            if (t == null || parseLog.isError()) continue;
            return t;
        }
        parseLog.setError(parseLog.getErrorIndex(), "Not matched by any format: " + charSequence);
        return null;
    }
}

