/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.List;
import java.util.Locale;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.base.MathUtils;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.history.ChronoHistory;
import net.time4j.history.CutOverEvent;
import net.time4j.history.EraPreference;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.internal.HistoricAttribute;
import net.time4j.history.internal.HistorizedElement;

final class HistoricalIntegerElement
extends BasicElement<Integer>
implements NumericalElement<Integer>,
HistorizedElement {
    private static final int YEAR_OF_ERA_INDEX = 2;
    private static final int MONTH_INDEX = 3;
    private static final int DAY_OF_MONTH_INDEX = 4;
    private static final long serialVersionUID = -6283098762945747308L;
    private final ChronoHistory history;
    private final transient int index;
    private final transient char symbol;
    private final transient Integer defaultMin;
    private final transient Integer defaultMax;

    private HistoricalIntegerElement(String string, char c, Integer n, Integer n2, ChronoHistory chronoHistory, int n3) {
        super(string);
        this.symbol = c;
        this.defaultMin = n;
        this.defaultMax = n2;
        this.history = chronoHistory;
        this.index = n3;
    }

    static TextElement<Integer> forYearOfEra(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("YEAR_OF_ERA", 'y', 1, 999999999, chronoHistory, 2);
    }

    static TextElement<Integer> forMonth(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("HISTORIC_MONTH", 'M', 1, 12, chronoHistory, 3);
    }

    static TextElement<Integer> forDayOfMonth(ChronoHistory chronoHistory) {
        return new HistoricalIntegerElement("HISTORIC_DAY_OF_MONTH", 'd', 1, 31, chronoHistory, 4);
    }

    public Class<Integer> getType() {
        return Integer.class;
    }

    public char getSymbol() {
        return this.symbol;
    }

    public Integer getDefaultMinimum() {
        return this.defaultMin;
    }

    public Integer getDefaultMaximum() {
        return this.defaultMax;
    }

    public boolean isDateElement() {
        return true;
    }

    public boolean isTimeElement() {
        return false;
    }

    public int numerical(Integer n) {
        return n;
    }

    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        HistoricDate historicDate = this.history.convert((PlainDate)chronoDisplay.get((ChronoElement)PlainDate.COMPONENT));
        switch (this.index) {
            case 2: {
                int n;
                int n2;
                int n3 = 1;
                int n4 = 9;
                if (attributeQuery.contains(HistoricAttribute.MIN_WIDTH_OF_YEAR)) {
                    n3 = (Integer)attributeQuery.get(HistoricAttribute.MIN_WIDTH_OF_YEAR);
                }
                if (attributeQuery.contains(HistoricAttribute.MAX_WIDTH_OF_YEAR)) {
                    n4 = (Integer)attributeQuery.get(HistoricAttribute.MAX_WIDTH_OF_YEAR);
                }
                NewYearStrategy newYearStrategy = this.history.getNewYearStrategy();
                HistoricEra historicEra = historicDate.getEra();
                int n5 = historicDate.getYearOfEra();
                int n6 = historicEra.annoDomini(n5);
                char c = ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
                String string = this.format(String.valueOf(n5), c, n3, n4);
                if (!(NewYearStrategy.DEFAULT.equals(newYearStrategy) || n6 < 8 && historicEra.compareTo(HistoricEra.AD) <= 0 || (n2 = historicDate.getYearOfEra(newYearStrategy)) == n5)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(n2);
                    stringBuilder.append('/');
                    if (n5 >= 100 && MathUtils.floorDivide((int)n2, (int)100) == MathUtils.floorDivide((int)n5, (int)100)) {
                        n = MathUtils.floorModulo((int)n5, (int)100);
                        if (n < 10) {
                            stringBuilder.append('0');
                        }
                        stringBuilder.append(n);
                    } else {
                        stringBuilder.append(n5);
                    }
                    string = this.format(stringBuilder.toString(), c, n3, n4);
                }
                if (c != '0') {
                    StringBuilder stringBuilder = new StringBuilder();
                    n = string.length();
                    for (int i = 0; i < n; ++i) {
                        char c2 = string.charAt(i);
                        if (c2 >= '0' && c2 <= '9') {
                            int n7 = c - 48;
                            stringBuilder.append((char)(c2 + n7));
                            continue;
                        }
                        stringBuilder.append(c2);
                    }
                    string = stringBuilder.toString();
                }
                appendable.append(string);
                break;
            }
            case 3: {
                OutputContext outputContext = (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT);
                appendable.append(this.monthAccessor(attributeQuery, outputContext).print((Enum)Month.valueOf((int)historicDate.getMonth())));
                break;
            }
            case 4: {
                appendable.append(String.valueOf(historicDate.getDayOfMonth()));
            }
        }
    }

    public Integer parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        int n;
        if (this.index == 3) {
            int n2 = parsePosition.getIndex();
            OutputContext outputContext = (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT);
            Month month = (Month)this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
            if (month == null && ((Boolean)attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, (Object)Boolean.TRUE)).booleanValue()) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                outputContext = outputContext == OutputContext.FORMAT ? OutputContext.STANDALONE : OutputContext.FORMAT;
                month = (Month)this.monthAccessor(attributeQuery, outputContext).parse(charSequence, parsePosition, Month.class, attributeQuery);
            }
            if (month == null) {
                return null;
            }
            return month.getValue();
        }
        char c = ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        int n3 = n = parsePosition.getIndex();
        int n4 = HistoricalIntegerElement.parseNum(charSequence, n3, parsePosition, c);
        n3 = parsePosition.getIndex();
        if (this.index == 2 && !NewYearStrategy.DEFAULT.equals(this.history.getNewYearStrategy()) && n3 < charSequence.length() && charSequence.charAt(n3) == '/') {
            int n5 = n3;
            int n6 = HistoricalIntegerElement.parseNum(charSequence, n3 + 1, parsePosition, c);
            int n7 = parsePosition.getIndex();
            if (n7 == n3 + 1) {
                parsePosition.setIndex(n3);
            } else {
                n3 = n7;
                int n8 = n4;
                int n9 = this.getAncientYear(n8, n6);
                if (n9 != Integer.MAX_VALUE) {
                    n4 = n9;
                } else if (Math.abs(n6 - n8) <= 1) {
                    n4 = n6;
                } else {
                    n4 = n8;
                    n3 = n5;
                    parsePosition.setIndex(n3);
                }
            }
        }
        if (n3 == n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        return n4;
    }

    protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
        if (chronology.isRegistered((ChronoElement)PlainDate.COMPONENT)) {
            return new Rule(this.index, this.history);
        }
        return null;
    }

    private int getAncientYear(int n, int n2) {
        if (n2 < 0 || n2 >= 100 || n < 100) {
            return Integer.MAX_VALUE;
        }
        if (this.history.getEraPreference() != EraPreference.DEFAULT || n < this.history.getGregorianCutOverDate().getYear()) {
            int n3;
            int n4 = n3 = n2 < 10 ? 10 : 100;
            if (Math.abs(n2 - MathUtils.floorModulo((int)n, (int)n3)) <= 1) {
                return MathUtils.floorDivide((int)n, (int)n3) * n3 + n2;
            }
        }
        return Integer.MAX_VALUE;
    }

    private String format(String string, char c, int n, int n2) {
        int n3 = string.length();
        if (n3 > n2) {
            throw new IllegalArgumentException("Element " + this.name() + " cannot be printed as the value " + string + " exceeds the maximum width of " + n2 + ".");
        }
        if (n <= n3) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = n - n3;
        for (int i = 0; i < n4; ++i) {
            stringBuilder.append(c);
        }
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    private TextAccessor monthAccessor(AttributeQuery attributeQuery, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance((String)((String)attributeQuery.get(Attributes.CALENDAR_TYPE, (Object)"iso8601")), (Locale)((Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT)));
        TextWidth textWidth = (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE);
        return calendarText.getStdMonths(textWidth, outputContext);
    }

    private static int parseNum(CharSequence charSequence, int n, ParsePosition parsePosition, char c) {
        int n2;
        int n3 = 0;
        int n4 = n;
        boolean bl = false;
        if (charSequence.charAt(n4) == '-') {
            bl = true;
            ++n4;
        }
        int n5 = Math.min(n4 + 9, charSequence.length());
        for (int i = n4; i < n5 && (n2 = charSequence.charAt(i) - c) >= 0 && n2 <= 9; ++i) {
            n3 = n3 * 10 + n2;
            ++n4;
        }
        if (bl) {
            if (n4 == n + 1) {
                n4 = n;
            } else {
                n3 = MathUtils.safeNegate((int)n3);
            }
        }
        parsePosition.setIndex(n4);
        return n3;
    }

    private Object readResolve() throws ObjectStreamException {
        String string = this.name();
        if (string.equals(this.history.yearOfEra().name())) {
            return this.history.yearOfEra();
        }
        if (string.equals(this.history.month().name())) {
            return this.history.month();
        }
        if (string.equals(this.history.dayOfMonth().name())) {
            return this.history.dayOfMonth();
        }
        throw new InvalidObjectException("Unknown element: " + string);
    }

    private static class Rule<C extends ChronoEntity<C>>
    implements ElementRule<C, Integer> {
        private final int index;
        private final ChronoHistory history;

        Rule(int n, ChronoHistory chronoHistory) {
            this.index = n;
            this.history = chronoHistory;
        }

        public Integer getValue(C c) {
            try {
                HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
                switch (this.index) {
                    case 2: {
                        return historicDate.getYearOfEra();
                    }
                    case 3: {
                        return historicDate.getMonth();
                    }
                    case 4: {
                        return historicDate.getDayOfMonth();
                    }
                }
                throw new UnsupportedOperationException("Unknown element index: " + this.index);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public Integer getMinimum(C c) {
            try {
                int n;
                HistoricDate historicDate = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
                if (this.index == 2) {
                    if (historicDate.getEra().compareTo(HistoricEra.AD) <= 0) {
                        return 1;
                    }
                    return this.history.convert((PlainDate)PlainDate.axis().getMinimum()).getYearOfEra();
                }
                HistoricDate historicDate2 = this.adjust(c, 1);
                if (this.history.isValid(historicDate2)) {
                    return 1;
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (n = list.size() - 1; n >= 0; --n) {
                    CutOverEvent cutOverEvent = list.get(n);
                    if (historicDate.compareTo(cutOverEvent.dateAtCutOver) < 0) continue;
                    historicDate2 = cutOverEvent.dateAtCutOver;
                    break;
                }
                n = this.index == 3 ? historicDate2.getMonth() : historicDate2.getDayOfMonth();
                return n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public Integer getMaximum(C c) {
            try {
                HistoricDate historicDate;
                int n;
                HistoricDate historicDate2 = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
                switch (this.index) {
                    case 2: {
                        int n2 = historicDate2.getEra() == HistoricEra.BC ? this.history.convert((PlainDate)PlainDate.axis().getMinimum()).getYearOfEra() : this.history.convert((PlainDate)PlainDate.axis().getMaximum()).getYearOfEra();
                        return n2;
                    }
                    case 3: {
                        n = 12;
                        historicDate = this.adjust(c, n);
                        break;
                    }
                    case 4: {
                        n = this.history.getAlgorithm(historicDate2).getMaximumDayOfMonth(historicDate2);
                        historicDate = this.adjust(c, n);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown element index: " + this.index);
                    }
                }
                if (this.history.isValid(historicDate)) {
                    return n;
                }
                List<CutOverEvent> list = this.history.getEvents();
                for (int i = list.size() - 1; i >= 0; --i) {
                    CutOverEvent cutOverEvent;
                    CutOverEvent cutOverEvent2 = cutOverEvent = list.get(i);
                    if (historicDate2.compareTo(cutOverEvent.dateAtCutOver) >= 0) continue;
                    historicDate = cutOverEvent2.dateBeforeCutOver;
                    break;
                }
                n = this.index == 3 ? historicDate.getMonth() : historicDate.getDayOfMonth();
                return n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ChronoException(illegalArgumentException.getMessage(), (Exception)illegalArgumentException);
            }
        }

        public boolean isValid(C c, Integer n) {
            if (n == null) {
                return false;
            }
            try {
                HistoricDate historicDate = this.adjust(c, n);
                return this.history.isValid(historicDate);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
        }

        public C withValue(C c, Integer n, boolean bl) {
            HistoricDate historicDate = this.adjust(c, n);
            return (C)c.with((ChronoElement)PlainDate.COMPONENT, (Object)this.history.convert(historicDate));
        }

        public ChronoElement<?> getChildAtFloor(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        public ChronoElement<?> getChildAtCeiling(C c) {
            throw new UnsupportedOperationException("Never called.");
        }

        private HistoricDate adjust(C c, int n) {
            HistoricDate historicDate;
            HistoricDate historicDate2 = this.history.convert((PlainDate)c.get((ChronoElement)PlainDate.COMPONENT));
            switch (this.index) {
                case 2: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), n, historicDate2.getMonth(), historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 3: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), n, historicDate2.getDayOfMonth());
                    historicDate = this.history.adjustDayOfMonth(historicDate);
                    break;
                }
                case 4: {
                    historicDate = HistoricDate.of(historicDate2.getEra(), historicDate2.getYearOfEra(), historicDate2.getMonth(), n);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown element index: " + this.index);
                }
            }
            return historicDate;
        }
    }
}

