/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.PlainDate;
import net.time4j.engine.EpochDays;
import net.time4j.history.AncientJulianLeapYears;
import net.time4j.history.ChronoHistory;
import net.time4j.history.EraPreference;
import net.time4j.history.NewYearStrategy;
import net.time4j.history.internal.HistoricVariant;

final class SPX
implements Externalizable {
    static final int VERSION_1 = 1;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    private static final int[] EMPTY_INT_ARRAY = new int[0];
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 1: 
            case 2: 
            case 3: {
                this.writeHistory(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        ChronoHistory chronoHistory;
        byte by = objectInput.readByte();
        switch ((by & 0xFF) >> 4) {
            case 1: {
                chronoHistory = this.readHistory(objectInput, by);
                break;
            }
            case 2: {
                chronoHistory = this.readHistory(objectInput, by);
                AncientJulianLeapYears ancientJulianLeapYears = SPX.readTriennalState(objectInput);
                if (ancientJulianLeapYears == null) break;
                chronoHistory = chronoHistory.with(ancientJulianLeapYears);
                break;
            }
            case 3: {
                chronoHistory = this.readHistory(objectInput, by);
                AncientJulianLeapYears ancientJulianLeapYears = SPX.readTriennalState(objectInput);
                if (ancientJulianLeapYears != null) {
                    chronoHistory = chronoHistory.with(ancientJulianLeapYears);
                }
                chronoHistory = chronoHistory.with(NewYearStrategy.readFromStream(objectInput));
                chronoHistory = chronoHistory.with(EraPreference.readFromStream(objectInput));
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
        this.obj = chronoHistory;
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeHistory(DataOutput dataOutput) throws IOException {
        ChronoHistory chronoHistory = (ChronoHistory)this.obj;
        int n = chronoHistory.getHistoricVariant().getSerialValue();
        int n2 = this.type;
        n2 <<= 4;
        dataOutput.writeByte(n2 |= n);
        if (chronoHistory.getHistoricVariant() == HistoricVariant.SINGLE_CUTOVER_DATE) {
            dataOutput.writeLong(chronoHistory.getEvents().get((int)0).start);
        }
        int[] nArray = chronoHistory.hasAncientJulianLeapYears() ? chronoHistory.getAncientJulianLeapYears().getPattern() : EMPTY_INT_ARRAY;
        dataOutput.writeInt(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            dataOutput.writeInt(nArray[i]);
        }
        chronoHistory.getNewYearStrategy().writeToStream(dataOutput);
        chronoHistory.getEraPreference().writeToStream(dataOutput);
    }

    private ChronoHistory readHistory(DataInput dataInput, byte by) throws IOException, ClassNotFoundException {
        int n = by & 0xF;
        HistoricVariant historicVariant = SPX.getEnum(n);
        switch (historicVariant) {
            case PROLEPTIC_GREGORIAN: {
                return ChronoHistory.PROLEPTIC_GREGORIAN;
            }
            case PROLEPTIC_JULIAN: {
                return ChronoHistory.PROLEPTIC_JULIAN;
            }
            case PROLEPTIC_BYZANTINE: {
                return ChronoHistory.PROLEPTIC_BYZANTINE;
            }
            case SWEDEN: {
                return ChronoHistory.ofSweden();
            }
            case INTRODUCTION_ON_1582_10_15: {
                return ChronoHistory.ofFirstGregorianReform();
            }
        }
        long l = dataInput.readLong();
        return ChronoHistory.ofGregorianReform(PlainDate.of((long)l, (EpochDays)EpochDays.MODIFIED_JULIAN_DATE));
    }

    private static HistoricVariant getEnum(int n) throws StreamCorruptedException {
        for (HistoricVariant historicVariant : HistoricVariant.values()) {
            if (historicVariant.getSerialValue() != n) continue;
            return historicVariant;
        }
        throw new StreamCorruptedException("Unknown variant of chronological history.");
    }

    private static AncientJulianLeapYears readTriennalState(DataInput dataInput) throws IOException {
        int n = dataInput.readInt();
        if (n > 0) {
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = 1 - dataInput.readInt();
            }
            return AncientJulianLeapYears.of(nArray);
        }
        return null;
    }
}

