/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Locale;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoExtension;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.history.ChronoHistory;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.internal.HistoricAttribute;

public class HistoricExtension
implements ChronoExtension {
    public boolean accept(Class<?> clazz) {
        return clazz == PlainDate.class;
    }

    public Set<ChronoElement<?>> getElements(Locale locale, AttributeQuery attributeQuery) {
        return HistoricExtension.getHistory(locale, attributeQuery).getElements();
    }

    public <T extends ChronoEntity<T>> T resolve(T t, Locale locale, AttributeQuery attributeQuery) {
        ChronoHistory chronoHistory = HistoricExtension.getHistory(locale, attributeQuery);
        HistoricEra historicEra = null;
        if (t.contains(chronoHistory.era())) {
            historicEra = (HistoricEra)((Object)t.get(chronoHistory.era()));
        } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
            historicEra = HistoricEra.AD;
        }
        if (historicEra != null && t.contains(chronoHistory.yearOfEra()) && t.contains(chronoHistory.month()) && t.contains(chronoHistory.dayOfMonth())) {
            int n = (Integer)t.get(chronoHistory.yearOfEra());
            int n2 = (Integer)t.get(chronoHistory.month());
            int n3 = (Integer)t.get(chronoHistory.dayOfMonth());
            HistoricDate historicDate = HistoricDate.of(historicEra, n, n2, n3);
            PlainDate plainDate = chronoHistory.convert(historicDate);
            t.with(chronoHistory.era(), null);
            t.with(chronoHistory.yearOfEra(), null);
            t.with(chronoHistory.month(), null);
            t.with(chronoHistory.dayOfMonth(), null);
            return (T)t.with((ChronoElement)PlainDate.COMPONENT, (Object)plainDate);
        }
        return t;
    }

    private static ChronoHistory getHistory(Locale locale, AttributeQuery attributeQuery) {
        if (((String)attributeQuery.get(Attributes.CALENDAR_TYPE, (Object)"iso8601")).equals("julian")) {
            return ChronoHistory.PROLEPTIC_JULIAN;
        }
        if (attributeQuery.contains(HistoricAttribute.CALENDAR_HISTORY)) {
            return (ChronoHistory)attributeQuery.get(HistoricAttribute.CALENDAR_HISTORY);
        }
        return ChronoHistory.of(locale);
    }
}

