/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.internal.GregorianTextElement;

final class TextProcessor<V>
implements FormatProcessor<V> {
    private final TextElement<V> element;
    private final boolean protectedMode;
    private final GregorianTextElement<V> gte;
    private final Locale language;
    private final TextWidth tw;
    private final OutputContext oc;
    private final Leniency lenientMode;
    private final int protectedLength;

    private TextProcessor(TextElement<V> textElement, boolean bl, Locale locale, TextWidth textWidth, OutputContext outputContext, Leniency leniency, int n) {
        if (textElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = textElement;
        this.protectedMode = bl;
        this.gte = textElement instanceof GregorianTextElement ? (GregorianTextElement)textElement : null;
        this.language = locale;
        this.tw = textWidth;
        this.oc = outputContext;
        this.lenientMode = leniency;
        this.protectedLength = n;
    }

    static <V> TextProcessor<V> create(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement, false, Locale.ROOT, TextWidth.WIDE, OutputContext.FORMAT, Leniency.SMART, 0);
    }

    static <V> TextProcessor<V> createProtected(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement, true, Locale.ROOT, TextWidth.WIDE, OutputContext.FORMAT, Leniency.SMART, 0);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        try {
            if (appendable instanceof CharSequence) {
                CharSequence charSequence = (CharSequence)((Object)appendable);
                int n = charSequence.length();
                this.print(chronoDisplay, appendable, attributeQuery, bl);
                if (set != null) {
                    set.add(new ElementPosition((ChronoElement<?>)this.element, n, charSequence.length()));
                }
            } else {
                this.print(chronoDisplay, appendable, attributeQuery, bl);
            }
        }
        catch (ChronoException chronoException) {
            throw new IllegalArgumentException(chronoException);
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedValues parsedValues, boolean bl) {
        int n;
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        int n4 = n = bl ? this.protectedLength : (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (n > 0) {
            n3 -= n;
        }
        if (n2 >= n3) {
            parseLog.setError(n2, "Missing chars for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        Object object = bl && this.gte != null && this.lenientMode != null ? this.gte.parse(charSequence, parseLog.getPP(), this.language, this.tw, this.oc, this.lenientMode) : this.element.parse(charSequence, parseLog.getPP(), attributeQuery);
        if (parseLog.isError()) {
            Class clazz = this.element.getType();
            if (clazz.isEnum()) {
                parseLog.setError(parseLog.getErrorIndex(), "No suitable enum found: " + clazz.getName());
            } else {
                parseLog.setError(parseLog.getErrorIndex(), "Unparseable element: " + this.element.name());
            }
        } else if (object == null) {
            parseLog.setError(n2, "No interpretable value.");
        } else {
            parsedValues.put((ChronoElement<?>)this.element, object);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TextProcessor) {
            TextProcessor textProcessor = (TextProcessor)object;
            return this.element.equals(textProcessor.element) && this.protectedMode == textProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(",protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        if (chronoElement instanceof TextElement) {
            return TextProcessor.create((TextElement)chronoElement);
        }
        throw new IllegalArgumentException("Text element required: " + chronoElement.getClass().getName());
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<V> quickPath(AttributeQuery attributeQuery, int n) {
        Leniency leniency = (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        boolean bl = (Boolean)attributeQuery.get(Attributes.PARSE_MULTIPLE_CONTEXT, (Object)Boolean.TRUE);
        boolean bl2 = (Boolean)attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, (Object)Boolean.TRUE);
        boolean bl3 = (Boolean)attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, (Object)Boolean.FALSE);
        if (leniency == Leniency.STRICT && (bl || bl2 || bl3)) {
            leniency = null;
        } else if (!(leniency != Leniency.SMART || bl && bl2 && !bl3)) {
            leniency = null;
        } else if (!(bl && bl2 && bl3)) {
            leniency = null;
        }
        return new TextProcessor<V>(this.element, this.protectedMode, (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT), (TextWidth)attributeQuery.get(Attributes.TEXT_WIDTH, (Object)TextWidth.WIDE), (OutputContext)attributeQuery.get(Attributes.OUTPUT_CONTEXT, (Object)OutputContext.FORMAT), leniency, (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0));
    }

    private void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, boolean bl) throws IOException {
        if (this.gte != null && bl) {
            this.gte.print(chronoDisplay, appendable, this.language, this.tw, this.oc);
        } else {
            this.element.print(chronoDisplay, appendable, attributeQuery);
        }
    }
}

