/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumericalElement;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedValues;
import net.time4j.format.expert.SignPolicy;
import net.time4j.history.internal.HistorizedElement;

class NumberProcessor<V>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final boolean fixedWidth;
    private final int minDigits;
    private final int maxDigits;
    private final SignPolicy signPolicy;
    private final boolean protectedMode;
    private final boolean yearOfEra;
    private final Leniency lenientMode;
    private final int reserved;
    private final char zeroDigit;
    private final NumberSystem numberSystem;
    private final int protectedLength;

    NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
        this(chronoElement, bl, n, n2, signPolicy, bl2, 0, '0', NumberSystem.ARABIC, Leniency.SMART, 0);
    }

    private NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2, int n3, char c, NumberSystem numberSystem, Leniency leniency, int n4) {
        this.element = chronoElement;
        this.fixedWidth = bl;
        this.minDigits = n;
        this.maxDigits = n2;
        this.signPolicy = signPolicy;
        this.protectedMode = bl2;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (signPolicy == null) {
            throw new NullPointerException("Missing sign policy.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Not positive: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Max smaller than min: " + n2 + " < " + n);
        }
        if (bl && n != n2) {
            throw new IllegalArgumentException("Variable width in fixed-width-mode: " + n2 + " != " + n);
        }
        if (bl && signPolicy != SignPolicy.SHOW_NEVER) {
            throw new IllegalArgumentException("Sign policy must be SHOW_NEVER in fixed-width-mode.");
        }
        int n5 = this.getScale(NumberSystem.ARABIC);
        if (n > n5) {
            throw new IllegalArgumentException("Min digits out of range: " + n);
        }
        if (n2 > n5) {
            throw new IllegalArgumentException("Max digits out of range: " + n2);
        }
        this.yearOfEra = this.element.name().equals("YEAR_OF_ERA");
        this.reserved = n3;
        this.zeroDigit = c;
        this.numberSystem = numberSystem;
        this.lenientMode = leniency;
        this.protectedLength = n4;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        int n = appendable instanceof CharSequence ? ((CharSequence)((Object)appendable)).length() : -1;
        int n2 = 0;
        NumberSystem numberSystem = bl ? this.numberSystem : this.getNumberSystem(attributeQuery);
        char c = '\u0000';
        if (numberSystem == NumberSystem.ARABIC) {
            char c2 = c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        }
        if (this.yearOfEra && this.element instanceof HistorizedElement) {
            HistorizedElement historizedElement = (HistorizedElement)HistorizedElement.class.cast(this.element);
            StringBuilder stringBuilder = new StringBuilder();
            historizedElement.print(chronoDisplay, stringBuilder, attributeQuery, numberSystem, c, this.minDigits, this.maxDigits);
            appendable.append(stringBuilder.toString());
            n2 = stringBuilder.length();
        } else {
            String string;
            int n3;
            Class clazz = this.element.getType();
            boolean bl2 = false;
            if (clazz == Integer.class) {
                n3 = chronoDisplay.getInt(this.element);
                bl2 = n3 < 0;
                string = NumberProcessor.toNumeral(numberSystem, n3);
            } else if (clazz == Long.class) {
                Object object = chronoDisplay.get(this.element);
                long l = (Long)Long.class.cast(object);
                bl2 = l < 0L;
                string = l == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l));
            } else if (Enum.class.isAssignableFrom(clazz)) {
                Object object = chronoDisplay.get(this.element);
                int n4 = -1;
                if (this.element instanceof NumericalElement) {
                    n4 = ((NumericalElement)this.element).numerical(object);
                    bl2 = n4 < 0;
                } else {
                    for (Object t : clazz.getEnumConstants()) {
                        if (!t.equals(object)) continue;
                        n4 = ((Enum)Enum.class.cast(t)).ordinal();
                        break;
                    }
                    if (n4 == -1) {
                        throw new AssertionError((Object)("Enum broken: " + object + " / " + clazz.getName()));
                    }
                }
                string = NumberProcessor.toNumeral(numberSystem, n4);
            } else {
                throw new IllegalArgumentException("Not formattable: " + this.element);
            }
            if (numberSystem == NumberSystem.ARABIC) {
                if (c != '0') {
                    n3 = c - 48;
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = (char)(cArray[i] + n3);
                    }
                    string = new String(cArray);
                }
                if (string.length() > this.maxDigits) {
                    throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the formatted value " + string + " exceeds the maximum width of " + this.maxDigits + ".");
                }
            }
            if (bl2) {
                if (this.signPolicy == SignPolicy.SHOW_NEVER) {
                    throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
                }
                appendable.append('-');
                ++n2;
            } else {
                switch (this.signPolicy) {
                    case SHOW_ALWAYS: {
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                    case SHOW_WHEN_BIG_NUMBER: {
                        if (string.length() <= this.minDigits) break;
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                }
            }
            if (numberSystem == NumberSystem.ARABIC) {
                int n5 = this.minDigits - string.length();
                for (n3 = 0; n3 < n5; ++n3) {
                    appendable.append(c);
                    ++n2;
                }
            }
            appendable.append(string);
            n2 += string.length();
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n2));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void parse(CharSequence var1_1, ParseLog var2_2, AttributeQuery var3_3, ParsedValues var4_4, boolean var5_5) {
        var6_6 = var1_1.length();
        var7_7 = var2_2.getPosition();
        v0 = var8_8 = var5_5 != false ? this.protectedLength : (Integer)var3_3.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (var8_8 > 0) {
            var6_6 -= var8_8;
        }
        if (var7_7 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            var2_2.setWarning();
            return;
        }
        if (this.yearOfEra && this.element instanceof HistorizedElement) {
            var9_9 = (HistorizedElement)HistorizedElement.class.cast(this.element);
            var10_11 = var9_9.parse(var1_1, var2_2.getPP(), var3_3, var4_4);
            if (var2_2.isError()) {
                var2_2.setError(var2_2.getErrorIndex(), "Unparseable element: " + this.element.name());
            } else if (var10_11 == null) {
                var2_2.setError(var7_7, "No interpretable value.");
            } else {
                var4_4.put(this.element, var10_11);
            }
            return;
        }
        var9_10 = var5_5 != false ? this.numberSystem : this.getNumberSystem(var3_3);
        var10_12 = var5_5 != false ? this.lenientMode : (Leniency)var3_3.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        var11_13 = 1;
        var12_14 = this.getScale(var9_10);
        if (this.fixedWidth || !var10_12.isLax()) {
            var11_13 = this.minDigits;
            var12_14 = this.maxDigits;
        }
        var13_15 = var7_7;
        var14_16 = false;
        var15_17 = var1_1.charAt(var13_15);
        if (var15_17 == '-' || var15_17 == '+') {
            if (this.signPolicy == SignPolicy.SHOW_NEVER && (this.fixedWidth || var10_12.isStrict())) {
                var2_2.setError(var7_7, "Sign not allowed due to sign policy.");
                return;
            }
            if (this.signPolicy == SignPolicy.SHOW_WHEN_NEGATIVE && var15_17 == '+' && var10_12.isStrict()) {
                var2_2.setError(var7_7, "Positive sign not allowed due to sign policy.");
                return;
            }
            var14_16 = var15_17 == '-';
            ++var13_15;
            ++var7_7;
        } else if (this.signPolicy == SignPolicy.SHOW_ALWAYS && var10_12.isStrict()) {
            var2_2.setError(var7_7, "Missing sign of number.");
            return;
        }
        if (var13_15 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            return;
        }
        v1 = var16_18 = var5_5 != false ? this.zeroDigit : ((Character)var3_3.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (!this.fixedWidth && this.reserved > 0 && var8_8 <= 0) {
            var17_19 = 0;
            if (var9_10 == NumberSystem.ARABIC) {
                for (var18_20 = var13_15; var18_20 < var6_6 && (var19_21 = var1_1.charAt(var18_20) - var16_18) >= 0 && var19_21 <= 9; ++var18_20) {
                    ++var17_19;
                }
            } else {
                for (var18_20 = var13_15; var18_20 < var6_6 && var9_10.contains(var1_1.charAt(var18_20)); ++var18_20) {
                    ++var17_19;
                }
            }
            var12_14 = Math.min(var12_14, var17_19 - this.reserved);
        }
        var17_19 = var13_15 + var11_13;
        var18_20 = Math.min(var6_6, var13_15 + var12_14);
        var19_22 = 0L;
        if (var9_10 == NumberSystem.ARABIC) {
            while (var13_15 < var18_20 && (var21_23 = var1_1.charAt(var13_15) - var16_18) >= 0 && var21_23 <= 9) {
                var19_22 = var19_22 * 10L + (long)var21_23;
                ++var13_15;
            }
        } else {
            var21_23 = 0;
            while (var13_15 < var18_20 && var9_10.contains(var1_1.charAt(var13_15))) {
                ++var21_23;
                ++var13_15;
            }
            try {
                if (var21_23 <= 0) ** GOTO lbl81
                var19_22 = var9_10.toInteger(var1_1.subSequence(var13_15 - var21_23, var13_15).toString(), var10_12);
            }
            catch (NumberFormatException var22_25) {
                var2_2.setError(var7_7, var22_25.getMessage());
                return;
            }
        }
lbl81:
        // 3 sources

        if (var13_15 < var17_19) {
            if (var13_15 == var7_7) {
                var2_2.setError(var7_7, "Digit expected.");
                return;
            }
            if (this.fixedWidth || !var10_12.isLax()) {
                var2_2.setError(var7_7, "Not enough digits found for: " + this.element.name());
                return;
            }
        }
        if (var14_16) {
            if (var19_22 == 0L && var10_12.isStrict()) {
                var2_2.setError(var7_7 - 1, "Negative zero is not allowed.");
                return;
            }
            var19_22 = -var19_22;
        } else if (this.signPolicy == SignPolicy.SHOW_WHEN_BIG_NUMBER && var10_12.isStrict() && var9_10 == NumberSystem.ARABIC) {
            if (var15_17 == '+' && var13_15 <= var17_19) {
                var2_2.setError(var7_7 - 1, "Positive sign only allowed for big number.");
            } else if (var15_17 != '+' && var13_15 > var17_19) {
                var2_2.setError(var7_7, "Positive sign must be present for big number.");
            }
        }
        var21_24 /* !! */  = null;
        var22_26 = this.element.getType();
        if (var22_26 == Integer.class) {
            var4_4.put(this.element, (int)var19_22);
            var2_2.setPosition(var13_15);
            return;
        }
        if (var22_26 == Long.class) {
            var21_24 /* !! */  = var19_22;
        } else if (Enum.class.isAssignableFrom(var22_26)) {
            if (this.element instanceof NumericalElement) {
                var23_27 = (NumericalElement)this.element;
                for (T var27_35 : var22_26.getEnumConstants()) {
                    if ((long)var23_27.numerical(var22_26.cast(var27_35)) != var19_22) continue;
                    var21_24 /* !! */  = var27_35;
                    break;
                }
            } else {
                for (T var26_34 : var22_26.getEnumConstants()) {
                    if ((long)((Enum)Enum.class.cast(var26_34)).ordinal() != var19_22) continue;
                    var21_24 /* !! */  = var26_34;
                    break;
                }
            }
            if (var21_24 /* !! */  == null) {
                var2_2.setError(var15_17 == '-' || var15_17 == '+' ? var7_7 - 1 : var7_7, "[" + this.element.name() + "] No enum found for value: " + var19_22);
                return;
            }
        } else {
            throw new IllegalArgumentException("Not parseable: " + this.element);
        }
        var4_4.put(this.element, var21_24 /* !! */ );
        var2_2.setPosition(var13_15);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NumberProcessor) {
            NumberProcessor numberProcessor = (NumberProcessor)object;
            return this.element.equals(numberProcessor.element) && this.fixedWidth == numberProcessor.fixedWidth && this.minDigits == numberProcessor.minDigits && this.maxDigits == numberProcessor.maxDigits && this.signPolicy == numberProcessor.signPolicy && this.protectedMode == numberProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", fixed-width-mode=");
        stringBuilder.append(this.fixedWidth);
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(", sign-policy=");
        stringBuilder.append((Object)this.signPolicy);
        stringBuilder.append(", protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        return new NumberProcessor<V>(chronoElement, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, false);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<V> quickPath(AttributeQuery attributeQuery, int n) {
        return new NumberProcessor<V>(this.element, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, this.protectedMode, n, ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue(), this.getNumberSystem(attributeQuery), (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0));
    }

    private int getScale(NumberSystem numberSystem) {
        if (numberSystem == NumberSystem.ARABIC) {
            return this.element.getType() == Long.class ? 18 : 9;
        }
        return Integer.MAX_VALUE;
    }

    private static String toNumeral(NumberSystem numberSystem, int n) {
        if (n == Integer.MIN_VALUE && numberSystem == NumberSystem.ARABIC) {
            return "2147483648";
        }
        return numberSystem.toNumeral(Math.abs(n));
    }

    private NumberSystem getNumberSystem(AttributeQuery attributeQuery) {
        NumberSystem numberSystem = NumberSystem.ARABIC;
        if (this.yearOfEra && ((Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT)).getLanguage().equals("am") && ((String)attributeQuery.get(Attributes.CALENDAR_TYPE, (Object)"iso8601")).equals("ethiopic")) {
            numberSystem = NumberSystem.ETHIOPIC;
        }
        return (NumberSystem)attributeQuery.get(Attributes.NUMBER_SYSTEM, (Object)numberSystem);
    }
}

