/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.Weekmodel;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoExtension;
import net.time4j.engine.Chronology;
import net.time4j.engine.EpochDays;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.ChronoPattern;
import net.time4j.format.DisplayMode;
import net.time4j.format.FormatEngine;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.SignPolicy;
import net.time4j.history.ChronoHistory;
import net.time4j.history.internal.HistorizedElement;
import net.time4j.i18n.UltimateFormatEngine;

public enum PatternType implements ChronoPattern<PatternType>
{
    CLDR,
    SIMPLE_DATE_FORMAT,
    THREETEN,
    CLDR_24,
    NON_ISO_DATE;


    public FormatEngine<PatternType> getFormatEngine() {
        return UltimateFormatEngine.INSTANCE;
    }

    Map<ChronoElement<?>, ChronoElement<?>> registerSymbol(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (this) {
            case CLDR: {
                return this.cldr(builder, locale, c, n);
            }
            case SIMPLE_DATE_FORMAT: {
                return this.sdf(builder, locale, c, n);
            }
            case THREETEN: {
                return this.threeten(builder, locale, c, n);
            }
            case CLDR_24: {
                return this.cldr24(builder, locale, c, n);
            }
            case NON_ISO_DATE: {
                if (PatternType.isISO(builder.getChronology())) {
                    throw new IllegalArgumentException("Choose CLDR or CLDR_24 for ISO-8601-chronology.");
                }
                return this.general(builder, c, n);
            }
        }
        throw new UnsupportedOperationException(this.name());
    }

    private static boolean isGeneralSymbol(char c) {
        switch (c) {
            case 'D': 
            case 'E': 
            case 'G': 
            case 'L': 
            case 'M': 
            case 'd': 
            case 'r': 
            case 'y': {
                return true;
            }
        }
        return false;
    }

    private static boolean isISO(Chronology<?> chronology) {
        return PatternType.getCalendarType(chronology).equals("iso8601");
    }

    private static String getCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? "iso8601" : calendarType.value();
    }

    private static ChronoElement<Integer> findEthiopianHour(Chronology<?> chronology) {
        for (ChronoExtension chronoExtension : chronology.getExtensions()) {
            for (ChronoElement chronoElement : chronoExtension.getElements(Locale.ROOT, Attributes.empty())) {
                if (!chronoElement.name().equals("ETHIOPIAN_HOUR")) continue;
                return (ChronoElement)PatternType.cast(chronoElement);
            }
        }
        return null;
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        Chronology<?> chronology = builder.getChronology();
        if (PatternType.isGeneralSymbol(c) && !PatternType.isISO(chronology)) {
            return this.general(builder, c, n);
        }
        if (c == 'h' && PatternType.getCalendarType(chronology).equals("ethiopic")) {
            ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(builder.getChronology());
            if (chronoElement == null) {
                throw new IllegalArgumentException("Ethiopian time not available.");
            }
            PatternType.addNumber(chronoElement, builder, n, false);
            return Collections.emptyMap();
        }
        return this.cldrISO(builder, locale, c, n, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map<ChronoElement<?>, ChronoElement<?>> cldrISO(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n, boolean bl) {
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else {
                    if (n != 5) throw new IllegalArgumentException("Too many pattern letters: " + n);
                    textWidth = TextWidth.NARROW;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.of(locale);
                TextElement textElement = (TextElement)TextElement.class.cast(chronoHistory.era());
                builder.addText(textElement);
                builder.endSection();
                HashMap hashMap = new HashMap();
                hashMap.put((ChronoElement<?>)PlainDate.YEAR, (ChronoElement<?>)chronoHistory.yearOfEra());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_OF_YEAR, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.DAY_OF_MONTH, (ChronoElement<?>)chronoHistory.dayOfMonth());
                hashMap.put((ChronoElement<?>)PlainDate.DAY_OF_YEAR, (ChronoElement<?>)chronoHistory.dayOfYear());
                return hashMap;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR);
                    return Collections.emptyMap();
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, false);
                return Collections.emptyMap();
            }
            case 'Y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE);
                    return Collections.emptyMap();
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE, n, false);
                return Collections.emptyMap();
            }
            case 'u': {
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, true);
                return Collections.emptyMap();
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, true);
                builder.endSection();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'Q': {
                PatternType.addQuarterOfYear(builder, n);
                return Collections.emptyMap();
            }
            case 'q': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addQuarterOfYear(builder, n);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, bl ? 4 : n));
                return Collections.emptyMap();
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'w': {
                PatternType.addNumber((ChronoElement<Integer>)Weekmodel.of((Locale)locale).weekOfYear(), builder, n, bl);
                return Collections.emptyMap();
            }
            case 'W': {
                if (n != 1) throw new IllegalArgumentException("Too many pattern letters: " + n);
                builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.of((Locale)locale).weekOfMonth(), 1);
                return Collections.emptyMap();
            }
            case 'd': {
                PatternType.addNumber((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, n, 3);
                    return Collections.emptyMap();
                }
                if (n != 3 && !bl) throw new IllegalArgumentException("Too many pattern letters: " + n);
                builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, n);
                return Collections.emptyMap();
            }
            case 'F': {
                if (n != 1 && !bl) throw new IllegalArgumentException("Too many pattern letters: " + n);
                builder.addFixedInteger((ChronoElement<Integer>)PlainDate.WEEKDAY_IN_MONTH, n);
                return Collections.emptyMap();
            }
            case 'g': {
                builder.addLongNumber((ChronoElement<Long>)EpochDays.MODIFIED_JULIAN_DATE, n, 18, SignPolicy.SHOW_WHEN_NEGATIVE);
                return Collections.emptyMap();
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4 || bl) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    if (n != 6) throw new IllegalArgumentException("Too many pattern letters: " + n);
                    textWidth = TextWidth.SHORT;
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'e': {
                if (n <= 2) {
                    builder.addFixedNumerical(Weekmodel.of((Locale)locale).localDayOfWeek(), n);
                    return Collections.emptyMap();
                }
                this.cldrISO(builder, locale, 'E', n, bl);
                return Collections.emptyMap();
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    if (n == 1) {
                        builder.addFixedNumerical(Weekmodel.of((Locale)locale).localDayOfWeek(), 1);
                        return Collections.emptyMap();
                    }
                    this.cldrISO(builder, locale, 'E', n, bl);
                    return Collections.emptyMap();
                }
                finally {
                    builder.endSection();
                }
            }
            case 'a': {
                TextWidth textWidth = bl ? TextWidth.ABBREVIATED : PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainTime.AM_PM_OF_DAY);
                builder.endSection();
                if (!PatternType.getCalendarType(builder.getChronology()).equals("ethiopic")) return Collections.emptyMap();
                ChronoElement<Integer> chronoElement = PatternType.findEthiopianHour(builder.getChronology());
                if (chronoElement == null) {
                    throw new IllegalArgumentException("Ethiopian time not available.");
                }
                HashMap hashMap = new HashMap();
                hashMap.put(chronoElement, (ChronoElement<?>)PlainTime.CLOCK_HOUR_OF_AMPM);
                return hashMap;
            }
            case 'b': {
                TextWidth textWidth = PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodFixed();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'B': {
                TextWidth textWidth = PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addDayPeriodApproximate();
                builder.endSection();
                return Collections.emptyMap();
            }
            case 'h': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.CLOCK_HOUR_OF_AMPM, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'H': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.DIGITAL_HOUR_OF_DAY, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'K': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.DIGITAL_HOUR_OF_AMPM, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'k': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.CLOCK_HOUR_OF_DAY, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'm': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.MINUTE_OF_HOUR, builder, n, bl);
                return Collections.emptyMap();
            }
            case 's': {
                PatternType.addNumber((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, builder, n, bl);
                return Collections.emptyMap();
            }
            case 'S': {
                builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, n, n, false);
                return Collections.emptyMap();
            }
            case 'A': {
                builder.addInteger((ChronoElement<Integer>)PlainTime.MILLI_OF_DAY, n, 9);
                return Collections.emptyMap();
            }
            case 'z': {
                try {
                    if (n < 4) {
                        builder.addShortTimezoneName();
                        return Collections.emptyMap();
                    }
                    if (n != 4 && !bl) throw new IllegalArgumentException("Too many pattern letters: " + n);
                    builder.addLongTimezoneName();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'Z': {
                if (n < 4) {
                    builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList("+0000"));
                    return Collections.emptyMap();
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n != 5) throw new IllegalArgumentException("Too many pattern letters: " + n);
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList("Z"));
                return Collections.emptyMap();
            }
            case 'O': {
                if (n == 1) {
                    builder.addShortLocalizedOffset();
                    return Collections.emptyMap();
                }
                if (n != 4) throw new IllegalArgumentException("Count of pattern letters is not 1 or 4: " + n);
                builder.addLongLocalizedOffset();
                return Collections.emptyMap();
            }
            case 'V': {
                if (n != 2) throw new IllegalArgumentException("Count of pattern letters is not 2: " + n);
                try {
                    builder.addTimezoneID();
                    return Collections.emptyMap();
                }
                catch (IllegalStateException illegalStateException) {
                    throw new IllegalArgumentException(illegalStateException.getMessage());
                }
            }
            case 'X': {
                PatternType.addOffset(builder, n, true);
                return Collections.emptyMap();
            }
            case 'x': {
                PatternType.addOffset(builder, n, false);
                return Collections.emptyMap();
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
    }

    private static TextWidth getPeriodWidth(int n) {
        if (n <= 3) {
            return TextWidth.ABBREVIATED;
        }
        if (n == 4) {
            return TextWidth.WIDE;
        }
        if (n == 5) {
            return TextWidth.NARROW;
        }
        throw new IllegalArgumentException("Too many pattern letters: " + n);
    }

    private Map<ChronoElement<?>, ChronoElement<?>> sdf(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (c) {
            case 'W': {
                builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.of((Locale)locale).boundedWeekOfMonth(), n);
                break;
            }
            case 'u': {
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, n);
                break;
            }
            case 'S': {
                builder.addFixedInteger((ChronoElement<Integer>)PlainTime.MILLI_OF_SECOND, n);
                break;
            }
            case 'Z': {
                PatternType.addOffset(builder, 2, false);
                break;
            }
            case 'B': 
            case 'O': 
            case 'Q': 
            case 'V': 
            case 'b': 
            case 'c': 
            case 'e': 
            case 'g': 
            case 'q': 
            case 'r': 
            case 'x': {
                throw new IllegalArgumentException("CLDR pattern symbol not supported in SimpleDateFormat-style: " + c);
            }
            case 'X': {
                if (n >= 4) {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                return this.cldrISO(builder, locale, 'X', n, true);
            }
            default: {
                return this.cldrISO(builder, locale, c, n, true);
            }
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChronoElement<?>, ChronoElement<?>> threeten(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                ChronoHistory chronoHistory = ChronoHistory.PROLEPTIC_GREGORIAN;
                TextElement textElement = (TextElement)TextElement.class.cast(chronoHistory.era());
                builder.addText(textElement);
                builder.endSection();
                builder.setProlepticGregorian();
                HashMap hashMap = new HashMap();
                hashMap.put((ChronoElement<?>)PlainDate.YEAR, (ChronoElement<?>)chronoHistory.yearOfEra());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_OF_YEAR, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, (ChronoElement<?>)chronoHistory.month());
                hashMap.put((ChronoElement<?>)PlainDate.DAY_OF_MONTH, (ChronoElement<?>)chronoHistory.dayOfMonth());
                hashMap.put((ChronoElement<?>)PlainDate.DAY_OF_YEAR, (ChronoElement<?>)chronoHistory.dayOfYear());
                return hashMap;
            }
            case 'y': {
                if (n == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR);
                    builder.endSection();
                    break;
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, false);
                break;
            }
            case 'Y': {
                if (n == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addTwoDigitYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE);
                    builder.endSection();
                    break;
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE, n, false);
                break;
            }
            case 'u': {
                if (n == 2) {
                    builder.startSection(Attributes.PIVOT_YEAR, 2100);
                    builder.addProlepticIsoYearWithTwoDigits();
                    builder.endSection();
                    break;
                }
                builder.addYear((ChronoElement<Integer>)PlainDate.YEAR, n, true);
                break;
            }
            case 'W': {
                if (n == 1) {
                    builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.of((Locale)locale).boundedWeekOfMonth(), 1);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainDate.DAY_OF_WEEK);
                builder.endSection();
                break;
            }
            case 'e': {
                if (n <= 2) {
                    builder.addFixedNumerical(Weekmodel.of((Locale)locale).localDayOfWeek(), n);
                    break;
                }
                this.threeten(builder, locale, 'E', n);
                break;
            }
            case 'c': {
                if (n == 2) {
                    throw new IllegalArgumentException("Invalid pattern count of 2 for symbol 'c'.");
                }
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    this.threeten(builder, locale, 'e', n);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'a': {
                TextWidth textWidth = PatternType.getPeriodWidth(n);
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(PlainTime.AM_PM_OF_DAY);
                builder.endSection();
                break;
            }
            case 'A': 
            case 'D': 
            case 'F': 
            case 'H': 
            case 'K': 
            case 'L': 
            case 'M': 
            case 'Q': 
            case 'S': 
            case 'd': 
            case 'h': 
            case 'k': 
            case 'm': 
            case 'q': 
            case 's': 
            case 'w': {
                return this.cldrISO(builder, locale, c, n, false);
            }
            case 'n': {
                builder.addInteger((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, n, 9);
                break;
            }
            case 'N': {
                builder.addLongNumber((ChronoElement<Long>)PlainTime.NANO_OF_DAY, n, 18, SignPolicy.SHOW_NEVER);
                break;
            }
            case 'z': {
                return this.cldrISO(builder, locale, 'z', n, false);
            }
            case 'Z': {
                if (n < 4) {
                    builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Collections.singletonList("+0000"));
                    break;
                }
                if (n == 4) {
                    builder.addLongLocalizedOffset();
                    break;
                }
                if (n == 5) {
                    builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList("Z"));
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'O': 
            case 'V': 
            case 'X': 
            case 'x': {
                return this.cldrISO(builder, locale, c, n, false);
            }
            case 'p': {
                builder.padNext(n);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptyMap();
    }

    private Map<ChronoElement<?>, ChronoElement<?>> cldr24(ChronoFormatter.Builder<?> builder, Locale locale, char c, int n) {
        if (c == 'H') {
            PatternType.addNumber((ChronoElement<Integer>)PlainTime.ISO_HOUR, builder, n, false);
            return Collections.emptyMap();
        }
        return this.cldr(builder, locale, c, n);
    }

    private static void addOffset(ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        switch (n) {
            case 1: {
                builder.addTimezoneOffset(DisplayMode.SHORT, false, Collections.singletonList(bl ? "Z" : "+00"));
                break;
            }
            case 2: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 3: {
                builder.addTimezoneOffset(DisplayMode.MEDIUM, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            case 4: {
                builder.addTimezoneOffset(DisplayMode.LONG, false, Collections.singletonList(bl ? "Z" : "+0000"));
                break;
            }
            case 5: {
                builder.addTimezoneOffset(DisplayMode.LONG, true, Collections.singletonList(bl ? "Z" : "+00:00"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addNumber(ChronoElement<Integer> chronoElement, ChronoFormatter.Builder<?> builder, int n, boolean bl) {
        if (n == 1) {
            builder.addInteger(chronoElement, 1, 2);
        } else if (n == 2 || bl) {
            builder.addFixedInteger(chronoElement, n);
        } else {
            throw new IllegalArgumentException("Too many pattern letters: " + n);
        }
    }

    private static void addMonth(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: {
                builder.addInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 1, 2);
                break;
            }
            case 2: {
                builder.addFixedInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.MONTH_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static void addQuarterOfYear(ChronoFormatter.Builder<?> builder, int n) {
        switch (n) {
            case 1: 
            case 2: {
                builder.addFixedNumerical(PlainDate.QUARTER_OF_YEAR, n);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(PlainDate.QUARTER_OF_YEAR);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChronoElement<?>, ChronoElement<?>> general(ChronoFormatter.Builder<?> builder, char c, int n) {
        ChronoElement chronoElement;
        TextElement textElement;
        String string;
        Set set = builder.getChronology().getRegisteredElements();
        ChronoElement<?> chronoElement2 = PatternType.find(set, c, string = builder.getChronology().getChronoType().getName());
        if (chronoElement2.getType().isEnum() && chronoElement2 instanceof TextElement) {
            textElement = (TextElement)PatternType.cast(chronoElement2);
            chronoElement = null;
        } else if (Integer.class.isAssignableFrom(chronoElement2.getType())) {
            textElement = null;
            if (chronoElement2 instanceof HistorizedElement) {
                textElement = (TextElement)PatternType.cast(chronoElement2);
            }
            chronoElement = (ChronoElement)PatternType.cast(chronoElement2);
        } else {
            throw new IllegalStateException("Implementation error: " + chronoElement2 + " in \"" + string + "\"");
        }
        switch (c) {
            case 'G': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 'y': {
                if (n == 2) {
                    builder.addTwoDigitYear((ChronoElement<Integer>)chronoElement);
                    break;
                }
                builder.addYear((ChronoElement<Integer>)chronoElement, n, false);
                break;
            }
            case 'r': {
                builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
                builder.startSection(Attributes.ZERO_DIGIT, 48);
                builder.addYear((ChronoElement<Integer>)chronoElement, n, true);
                builder.endSection();
                builder.endSection();
                break;
            }
            case 'M': {
                PatternType.addMonth(builder, Math.min(n, n), textElement);
                break;
            }
            case 'L': {
                builder.startSection(Attributes.OUTPUT_CONTEXT, OutputContext.STANDALONE);
                try {
                    PatternType.addMonth(builder, n, textElement);
                    break;
                }
                finally {
                    builder.endSection();
                }
            }
            case 'd': {
                PatternType.addNumber((ChronoElement<Integer>)chronoElement, builder, n, false);
                break;
            }
            case 'D': {
                if (n < 3) {
                    builder.addInteger((ChronoElement<Integer>)chronoElement, n, 3);
                    break;
                }
                if (n == 3) {
                    builder.addFixedInteger((ChronoElement<Integer>)chronoElement, n);
                    break;
                }
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
            case 'E': {
                TextWidth textWidth;
                if (n <= 3) {
                    textWidth = TextWidth.ABBREVIATED;
                } else if (n == 4) {
                    textWidth = TextWidth.WIDE;
                } else if (n == 5) {
                    textWidth = TextWidth.NARROW;
                } else if (n == 6) {
                    textWidth = TextWidth.SHORT;
                } else {
                    throw new IllegalArgumentException("Too many pattern letters: " + n);
                }
                builder.startSection(Attributes.TEXT_WIDTH, textWidth);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported pattern symbol: " + c);
            }
        }
        return Collections.emptyMap();
    }

    private static ChronoElement<?> find(Set<ChronoElement<?>> set, char c, String string) {
        char c2 = c == 'L' ? (char)'M' : (char)c;
        for (ChronoElement<?> chronoElement : set) {
            if (chronoElement.getSymbol() != c2) continue;
            return chronoElement;
        }
        throw new IllegalArgumentException("Cannot find any registered element for symbol " + c + " in \"" + string + "\".");
    }

    private static <V extends Enum<V>> void addMonth(ChronoFormatter.Builder<?> builder, int n, TextElement<?> textElement) {
        switch (n) {
            case 1: 
            case 2: {
                ChronoElement chronoElement = (ChronoElement)PatternType.cast(textElement);
                if (n == 1) {
                    builder.addNumerical(chronoElement, 1, 2);
                    break;
                }
                if (n != 2) break;
                builder.addFixedNumerical(chronoElement, 2);
                break;
            }
            case 3: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.ABBREVIATED);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 4: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.WIDE);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            case 5: {
                builder.startSection(Attributes.TEXT_WIDTH, TextWidth.NARROW);
                builder.addText(textElement);
                builder.endSection();
                break;
            }
            default: {
                throw new IllegalArgumentException("Too many pattern letters: " + n);
            }
        }
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

