/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.TextElement;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.ParseLog;

final class TextProcessor<V>
implements FormatProcessor<V> {
    private final TextElement<V> element;

    private TextProcessor(TextElement<V> textElement) {
        if (textElement == null) {
            throw new NullPointerException("Missing element.");
        }
        this.element = textElement;
    }

    static <V> TextProcessor<V> create(TextElement<V> textElement) {
        return new TextProcessor<V>(textElement);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (appendable instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)((Object)appendable);
            int n = charSequence.length();
            this.element.print(chronoDisplay, appendable, formatStep.getQuery(attributeQuery));
            if (set != null) {
                set.add(new ElementPosition((ChronoElement<?>)this.element, n, charSequence.length()));
            }
        } else {
            this.element.print(chronoDisplay, appendable, formatStep.getQuery(attributeQuery));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n = parseLog.getPosition();
        int n2 = charSequence.length();
        int n3 = formatStep.getAttribute(Attributes.PROTECTED_CHARACTERS, attributeQuery, 0);
        if (n3 > 0) {
            n2 -= n3;
        }
        if (n >= n2) {
            parseLog.setError(n, "Missing chars for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        TextElement textElement = (TextElement)TextElement.class.cast(this.element);
        Object object = textElement.parse(charSequence, parseLog.getPP(), formatStep.getQuery(attributeQuery));
        if (parseLog.isError()) {
            Class clazz = this.element.getType();
            if (clazz.isEnum()) {
                parseLog.setError(parseLog.getErrorIndex(), "No suitable enum found: " + clazz.getName());
            }
        } else if (object == null) {
            parseLog.setError(n, "No interpretable value.");
        } else {
            map.put((ChronoElement<?>)this.element, object);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TextProcessor) {
            TextProcessor textProcessor = (TextProcessor)object;
            return this.element.equals(textProcessor.element);
        }
        return false;
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        if (chronoElement instanceof TextElement) {
            return TextProcessor.create((TextElement)chronoElement);
        }
        throw new IllegalArgumentException("Text element required: " + chronoElement.getClass().getName());
    }

    @Override
    public boolean isNumerical() {
        return false;
    }
}

