/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.NumberSystem;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceControl;

public final class SymbolProviderSPI
implements NumberSymbolProvider {
    private static final Locale[] EMPTY_ARRAY = new Locale[0];
    public static final Set<String> SUPPORTED_LOCALES;
    public static final SymbolProviderSPI INSTANCE;
    private static final Map<String, NumberSystem> CLDR_NAMES;

    public Locale[] getAvailableLocales() {
        return EMPTY_ARRAY;
    }

    public char getZeroDigit(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "zero", NumberSymbolProvider.DEFAULT.getZeroDigit(locale));
    }

    public char getDecimalSeparator(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "separator", NumberSymbolProvider.DEFAULT.getDecimalSeparator(locale));
    }

    public String getPlusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "plus", NumberSymbolProvider.DEFAULT.getPlusSign(locale));
    }

    public String getMinusSign(Locale locale) {
        return SymbolProviderSPI.lookup(locale, "minus", NumberSymbolProvider.DEFAULT.getMinusSign(locale));
    }

    public NumberSystem getDefaultNumberSystem(Locale locale) {
        String string = SymbolProviderSPI.lookup(locale, "numsys", "latn");
        return CLDR_NAMES.get(string);
    }

    public String toString() {
        return "SymbolProviderSPI";
    }

    private static char lookup(Locale locale, String string, char c) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string).charAt(0);
        }
        return c;
    }

    private static String lookup(Locale locale, String string, String string2) {
        ResourceBundle resourceBundle = SymbolProviderSPI.getBundle(locale);
        if (resourceBundle != null && resourceBundle.containsKey(string)) {
            return resourceBundle.getString(string);
        }
        return string2;
    }

    private static ResourceBundle getBundle(Locale locale) {
        if (SUPPORTED_LOCALES.contains(LanguageMatch.getAlias(locale))) {
            return ResourceBundle.getBundle("numbers/symbol", locale, SymbolProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        }
        return null;
    }

    private static ClassLoader getLoader() {
        return SymbolProviderSPI.class.getClassLoader();
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("numbers/symbol", Locale.ROOT, SymbolProviderSPI.getLoader(), UTF8ResourceControl.SINGLETON);
        String[] stringArray = resourceBundle.getString("locales").split(" ");
        HashSet hashSet = new HashSet();
        Collections.addAll(hashSet, stringArray);
        SUPPORTED_LOCALES = Collections.unmodifiableSet(hashSet);
        INSTANCE = new SymbolProviderSPI();
        HashMap<String, NumberSystem> hashMap = new HashMap<String, NumberSystem>();
        hashMap.put("latn", NumberSystem.ARABIC);
        hashMap.put("arab", NumberSystem.ARABIC_INDIC);
        hashMap.put("arabext", NumberSystem.ARABIC_INDIC_EXT);
        hashMap.put("deva", NumberSystem.DEVANAGARI);
        hashMap.put("mymr", NumberSystem.MYANMAR);
        CLDR_NAMES = Collections.unmodifiableMap(hashMap);
    }
}

