/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

public class Iso8601Format {
    private static final IsoDecimalStyle DEFAULT_ISO_DECIMAL_STYLE = Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? IsoDecimalStyle.DOT : IsoDecimalStyle.COMMA;
    private static final NonZeroCondition NON_ZERO_SECOND = new NonZeroCondition((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE);
    private static final NonZeroCondition NON_ZERO_FRACTION = new NonZeroCondition((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND);
    private static final ChronoCondition<ChronoDisplay> SECOND_PART = NON_ZERO_SECOND.or(NON_ZERO_FRACTION);
    public static final ChronoFormatter<PlainDate> BASIC_CALENDAR_DATE = Iso8601Format.calendarFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_CALENDAR_DATE = Iso8601Format.calendarFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_ORDINAL_DATE = Iso8601Format.ordinalFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_ORDINAL_DATE = Iso8601Format.ordinalFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_WEEK_DATE = Iso8601Format.weekdateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_WEEK_DATE = Iso8601Format.weekdateFormat(true);
    public static final ChronoFormatter<PlainDate> BASIC_DATE = Iso8601Format.generalDateFormat(false);
    public static final ChronoFormatter<PlainDate> EXTENDED_DATE = Iso8601Format.generalDateFormat(true);
    public static final ChronoFormatter<PlainTime> BASIC_WALL_TIME = Iso8601Format.timeFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTime> EXTENDED_WALL_TIME = Iso8601Format.timeFormat(true, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTimestamp> BASIC_DATE_TIME = Iso8601Format.timestampFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<PlainTimestamp> EXTENDED_DATE_TIME = Iso8601Format.timestampFormat(true, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<Moment> BASIC_DATE_TIME_OFFSET = Iso8601Format.momentFormat(false, DEFAULT_ISO_DECIMAL_STYLE);
    public static final ChronoFormatter<Moment> EXTENDED_DATE_TIME_OFFSET = Iso8601Format.momentFormat(true, DEFAULT_ISO_DECIMAL_STYLE);

    private Iso8601Format() {
    }

    public static ChronoPrinter<PlainDate> ofDate(IsoDateStyle isoDateStyle) {
        switch (isoDateStyle) {
            case BASIC_CALENDAR_DATE: {
                return BASIC_CALENDAR_DATE;
            }
            case BASIC_ORDINAL_DATE: {
                return BASIC_ORDINAL_DATE;
            }
            case BASIC_WEEK_DATE: {
                return BASIC_WEEK_DATE;
            }
            case EXTENDED_CALENDAR_DATE: {
                return EXTENDED_CALENDAR_DATE;
            }
            case EXTENDED_ORDINAL_DATE: {
                return EXTENDED_ORDINAL_DATE;
            }
            case EXTENDED_WEEK_DATE: {
                return EXTENDED_WEEK_DATE;
            }
        }
        throw new UnsupportedOperationException(isoDateStyle.name());
    }

    public static ChronoPrinter<PlainTime> ofBasicTime(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        Iso8601Format.addWallTime(builder, false, isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<PlainTime> ofExtendedTime(IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        Iso8601Format.addWallTime(builder, true, isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<PlainTimestamp> ofTimestamp(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(PlainTimestamp.axis(), Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.ofDate(isoDateStyle), (charSequence, parseLog, attributeQuery) -> null);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, isoDateStyle.isExtended(), isoDecimalStyle, clockUnit);
        return builder.build().with(Leniency.STRICT);
    }

    public static ChronoPrinter<Moment> ofMoment(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset) {
        ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.axis(), Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.ofDate(isoDateStyle), (charSequence, parseLog, attributeQuery) -> null);
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, isoDateStyle.isExtended(), isoDecimalStyle, clockUnit);
        builder.addTimezoneOffset(DisplayMode.MEDIUM, isoDateStyle.isExtended(), Collections.singletonList("Z"));
        return builder.build().with(Leniency.STRICT).withTimezone((TZID)zonalOffset);
    }

    public static PlainDate parseDate(CharSequence charSequence) throws ParseException {
        ParseLog parseLog = new ParseLog();
        PlainDate plainDate = Iso8601Format.parseDate(charSequence, parseLog);
        if (plainDate == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return plainDate;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static PlainDate parseDate(CharSequence charSequence, ParseLog parseLog) {
        PlainDate plainDate;
        int n;
        int n2;
        int n3 = 0;
        int n4 = charSequence.length();
        int n5 = n4 - (n2 = parseLog.getPosition());
        if (n5 < 7) {
            parseLog.setError(n4, "Too short to be compatible with ISO-8601: " + charSequence.subSequence(n2, n4));
            return null;
        }
        block5: for (n = n2 + 1; n < n4; ++n) {
            switch (charSequence.charAt(n)) {
                case '-': {
                    ++n3;
                    break;
                }
                case 'W': {
                    PlainDate plainDate2;
                    if (n3 > 0) {
                        plainDate2 = EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                        return plainDate2;
                    }
                    plainDate2 = BASIC_WEEK_DATE.parse(charSequence, parseLog);
                    return plainDate2;
                }
                case '/': 
                case 'T': {
                    n5 = n - n2;
                    break block5;
                }
            }
        }
        if (n3 != 0) {
            if (n3 != 1) return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
            return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
        }
        n5 -= 4;
        n = charSequence.charAt(n2);
        if (n == 43 || n == 45) {
            n5 -= 2;
        }
        if (n5 == 3) {
            plainDate = BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
            return plainDate;
        }
        plainDate = BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
        return plainDate;
    }

    private static ChronoFormatter<PlainDate> calendarFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger((ChronoElement<Integer>)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainDate.MONTH_AS_NUMBER, 2);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_MONTH, 2).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> ordinalFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger((ChronoElement<Integer>)PlainDate.YEAR, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedInteger((ChronoElement<Integer>)PlainDate.DAY_OF_YEAR, 3).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> weekdateFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT).startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC).startSection(Attributes.ZERO_DIGIT, 48).addInteger((ChronoElement<Integer>)PlainDate.YEAR_OF_WEEKDATE, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
        if (bl) {
            builder.addLiteral('-');
        }
        builder.addLiteral('W');
        builder.addFixedInteger((ChronoElement<Integer>)Weekmodel.ISO.weekOfYear(), 2);
        if (bl) {
            builder.addLiteral('-');
        }
        return builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1).endSection().endSection().build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainDate> generalDateFormat(boolean bl) {
        ChronoFormatter.Builder<PlainDate> builder = ChronoFormatter.setUp(PlainDate.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTime> timeFormat(boolean bl, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<PlainTime> builder = ChronoFormatter.setUp(PlainTime.class, Locale.ROOT);
        builder.skipUnknown(n -> n == 84, 1);
        Iso8601Format.addWallTime(builder, bl, isoDecimalStyle);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<PlainTimestamp> timestampFormat(boolean bl, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<PlainTimestamp> builder = ChronoFormatter.setUp(PlainTimestamp.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl, isoDecimalStyle);
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoFormatter<Moment> momentFormat(boolean bl, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(Moment.axis().element(), Iso8601Format.momentFormat(DisplayMode.MEDIUM, bl, isoDecimalStyle), Iso8601Format.momentFormat(DisplayMode.SHORT, bl, isoDecimalStyle));
        return builder.build().with(Leniency.STRICT).withTimezone((TZID)ZonalOffset.UTC);
    }

    private static ChronoFormatter<Moment> momentFormat(DisplayMode displayMode, boolean bl, IsoDecimalStyle isoDecimalStyle) {
        ChronoFormatter.Builder<Moment> builder = ChronoFormatter.setUp(Moment.class, Locale.ROOT);
        builder.addCustomized(PlainDate.COMPONENT, Iso8601Format.generalDatePrinter(bl), Iso8601Format.generalDateParser(bl));
        builder.addLiteral('T');
        Iso8601Format.addWallTime(builder, bl, isoDecimalStyle);
        builder.addTimezoneOffset(displayMode, bl, Collections.singletonList("Z"));
        return builder.build().with(Leniency.STRICT);
    }

    private static ChronoPrinter<PlainDate> generalDatePrinter(final boolean bl) {
        return new ChronoPrinter<PlainDate>(){

            @Override
            public Set<ElementPosition> print(PlainDate plainDate, StringBuilder stringBuilder, AttributeQuery attributeQuery) {
                ChronoFormatter<PlainDate> chronoFormatter = bl ? EXTENDED_CALENDAR_DATE : BASIC_CALENDAR_DATE;
                return chronoFormatter.print(plainDate, stringBuilder);
            }

            @Override
            public <R> R print(PlainDate plainDate, Appendable appendable, AttributeQuery attributeQuery, ChronoFunction<ChronoDisplay, R> chronoFunction) throws IOException {
                ChronoFormatter<PlainDate> chronoFormatter = bl ? EXTENDED_CALENDAR_DATE : BASIC_CALENDAR_DATE;
                chronoFormatter.formatToBuffer(plainDate, appendable);
                return null;
            }
        };
    }

    private static ChronoParser<PlainDate> generalDateParser(boolean bl) {
        return (charSequence, parseLog, attributeQuery) -> {
            int n;
            int n2 = 0;
            int n3 = charSequence.length();
            int n4 = parseLog.getPosition();
            int n5 = n3 - n4;
            block5: for (n = n4 + 1; n < n3; ++n) {
                switch (charSequence.charAt(n)) {
                    case '-': {
                        ++n2;
                        break;
                    }
                    case 'W': {
                        if (bl) {
                            return EXTENDED_WEEK_DATE.parse(charSequence, parseLog);
                        }
                        return BASIC_WEEK_DATE.parse(charSequence, parseLog);
                    }
                    case '/': 
                    case 'T': {
                        n5 = n - n4;
                        break block5;
                    }
                }
            }
            if (bl) {
                if (n2 == 1) {
                    return EXTENDED_ORDINAL_DATE.parse(charSequence, parseLog);
                }
                return EXTENDED_CALENDAR_DATE.parse(charSequence, parseLog);
            }
            n5 -= 4;
            n = charSequence.charAt(n4);
            if (n == 43 || n == 45) {
                n5 -= 2;
            }
            if (n5 == 3) {
                return BASIC_ORDINAL_DATE.parse(charSequence, parseLog);
            }
            return BASIC_CALENDAR_DATE.parse(charSequence, parseLog);
        };
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl, IsoDecimalStyle isoDecimalStyle) {
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.ISO_HOUR, 2);
        builder.startOptionalSection();
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.MINUTE_OF_HOUR, 2);
        builder.startOptionalSection(SECOND_PART);
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, 2);
        builder.startOptionalSection(NON_ZERO_FRACTION);
        switch (isoDecimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(isoDecimalStyle.name());
            }
        }
        builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, 1, 9, false);
        for (int i = 0; i < 5; ++i) {
            builder.endSection();
        }
    }

    private static <T extends ChronoEntity<T>> void addWallTime(ChronoFormatter.Builder<T> builder, boolean bl, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit) {
        if (clockUnit == null) {
            throw new NullPointerException("Missing precision.");
        }
        builder.startSection(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
        builder.startSection(Attributes.ZERO_DIGIT, 48);
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.ISO_HOUR, 2);
        if (clockUnit == ClockUnit.HOURS) {
            builder.endSection();
            builder.endSection();
            return;
        }
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.MINUTE_OF_HOUR, 2);
        if (clockUnit == ClockUnit.MINUTES) {
            builder.endSection();
            builder.endSection();
            return;
        }
        if (bl) {
            builder.addLiteral(':');
        }
        builder.addFixedInteger((ChronoElement<Integer>)PlainTime.SECOND_OF_MINUTE, 2);
        if (clockUnit == ClockUnit.SECONDS) {
            builder.endSection();
            builder.endSection();
            return;
        }
        switch (isoDecimalStyle) {
            case COMMA: {
                builder.addLiteral(',', '.');
                break;
            }
            case DOT: {
                builder.addLiteral('.', ',');
                break;
            }
            default: {
                throw new UnsupportedOperationException(isoDecimalStyle.name());
            }
        }
        if (clockUnit == ClockUnit.MILLIS) {
            builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, 3, 3, false);
        } else if (clockUnit == ClockUnit.MICROS) {
            builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, 6, 6, false);
        } else if (clockUnit == ClockUnit.NANOS) {
            builder.addFraction((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, 9, 9, false);
        }
        builder.endSection();
        builder.endSection();
    }

    private static class NonZeroCondition
    implements ChronoCondition<ChronoDisplay> {
        private final ChronoElement<Integer> element;

        NonZeroCondition(ChronoElement<Integer> chronoElement) {
            this.element = chronoElement;
        }

        public boolean test(ChronoDisplay chronoDisplay) {
            return chronoDisplay.getInt(this.element) > 0;
        }

        ChronoCondition<ChronoDisplay> or(NonZeroCondition nonZeroCondition) {
            return chronoDisplay -> this.test((ChronoDisplay)chronoDisplay) || nonZeroCondition.test((ChronoDisplay)chronoDisplay);
        }
    }
}

