/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.history;

import net.time4j.base.GregorianMath;
import net.time4j.history.Calculus;
import net.time4j.history.HistoricDate;
import net.time4j.history.HistoricEra;
import net.time4j.history.JulianMath;

enum CalendarAlgorithm implements Calculus
{
    GREGORIAN{

        @Override
        public long toMJD(HistoricDate historicDate) {
            return GregorianMath.toMJD((int)CalendarAlgorithm.getProlepticYear(historicDate), (int)historicDate.getMonth(), (int)historicDate.getDayOfMonth());
        }

        @Override
        public HistoricDate fromMJD(long l) {
            long l2 = GregorianMath.toPackedDate((long)l);
            int n = GregorianMath.readYear((long)l2);
            int n2 = GregorianMath.readMonth((long)l2);
            int n3 = GregorianMath.readDayOfMonth((long)l2);
            return new HistoricDate(n <= 0 ? HistoricEra.BC : HistoricEra.AD, n <= 0 ? 1 - n : n, n2, n3);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            return GregorianMath.isValid((int)CalendarAlgorithm.getProlepticYear(historicDate), (int)historicDate.getMonth(), (int)historicDate.getDayOfMonth());
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            return GregorianMath.getLengthOfMonth((int)CalendarAlgorithm.getProlepticYear(historicDate), (int)historicDate.getMonth());
        }
    }
    ,
    JULIAN{

        @Override
        public long toMJD(HistoricDate historicDate) {
            return JulianMath.toMJD(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public HistoricDate fromMJD(long l) {
            long l2 = JulianMath.toPackedDate(l);
            int n = JulianMath.readYear(l2);
            int n2 = JulianMath.readMonth(l2);
            int n3 = JulianMath.readDayOfMonth(l2);
            return new HistoricDate(n <= 0 ? HistoricEra.BC : HistoricEra.AD, n <= 0 ? 1 - n : n, n2, n3);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            int n = CalendarAlgorithm.getProlepticYear(historicDate);
            int n2 = historicDate.getMonth();
            int n3 = historicDate.getDayOfMonth();
            if (n < -999979466 || n == -999979466 && (n2 < 11 || n2 == 11 && n3 < 21)) {
                return false;
            }
            return JulianMath.isValid(n, n2, n3);
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            return JulianMath.getLengthOfMonth(CalendarAlgorithm.getProlepticYear(historicDate), historicDate.getMonth());
        }
    }
    ,
    SWEDISH{

        @Override
        public long toMJD(HistoricDate historicDate) {
            int n = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && n == 1712) {
                return -53576L;
            }
            return JulianMath.toMJD(n, historicDate.getMonth(), historicDate.getDayOfMonth()) - 1L;
        }

        @Override
        public HistoricDate fromMJD(long l) {
            if (l == -53576L) {
                return new HistoricDate(HistoricEra.AD, 1712, 2, 30);
            }
            return JULIAN.fromMJD(l + 1L);
        }

        @Override
        public boolean isValid(HistoricDate historicDate) {
            int n = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getDayOfMonth() == 30 && historicDate.getMonth() == 2 && n == 1712) {
                return true;
            }
            return JulianMath.isValid(n, historicDate.getMonth(), historicDate.getDayOfMonth());
        }

        @Override
        public int getMaximumDayOfMonth(HistoricDate historicDate) {
            int n = CalendarAlgorithm.getProlepticYear(historicDate);
            if (historicDate.getMonth() == 2 && n == 1712) {
                return 30;
            }
            return JulianMath.getLengthOfMonth(n, historicDate.getMonth());
        }
    };


    private static int getProlepticYear(HistoricDate historicDate) {
        return historicDate.getEra().annoDomini(historicDate.getYearOfEra());
    }
}

