/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Iterator;
import java.util.Set;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.TZID;

abstract class ParsedEntity<T extends ParsedEntity<T>>
extends ChronoEntity<T> {
    ParsedEntity() {
    }

    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return true;
    }

    public <V> T with(ChronoElement<V> chronoElement, V v) {
        this.put(chronoElement, v);
        return (T)((Object)this);
    }

    public T with(ChronoElement<Integer> chronoElement, int n) {
        this.put(chronoElement, n);
        return (T)((Object)this);
    }

    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMinimum();
    }

    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        return (V)chronoElement.getDefaultMaximum();
    }

    public final boolean hasTimezone() {
        return this.contains(TimezoneElement.TIMEZONE_ID) || this.contains(TimezoneElement.TIMEZONE_OFFSET);
    }

    public final TZID getTimezone() {
        Object object = null;
        if (this.contains(TimezoneElement.TIMEZONE_ID)) {
            object = this.get(TimezoneElement.TIMEZONE_ID);
        } else if (this.contains(TimezoneElement.TIMEZONE_OFFSET)) {
            object = this.get(TimezoneElement.TIMEZONE_OFFSET);
        }
        if (object instanceof TZID) {
            return (TZID)TZID.class.cast(object);
        }
        return super.getTimezone();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ParsedEntity) {
            Object object22;
            ParsedEntity parsedEntity = (ParsedEntity)((Object)object);
            Set set = this.getRegisteredElements();
            Set set2 = parsedEntity.getRegisteredElements();
            if (set.size() != set2.size()) {
                return false;
            }
            for (Object object22 : set) {
                if (set2.contains(object22) && this.get((ChronoElement)object22).equals(parsedEntity.get((ChronoElement)object22))) continue;
                return false;
            }
            Iterator iterator = this.getResult();
            object22 = parsedEntity.getResult();
            if (iterator == null) {
                return object22 == null;
            }
            return iterator.equals(object22);
        }
        return false;
    }

    public final int hashCode() {
        int n = this.getRegisteredElements().hashCode();
        Object e = this.getResult();
        if (e != null) {
            n += 31 * e.hashCode();
        }
        return n;
    }

    public String toString() {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append('{');
        for (ChronoElement chronoElement : this.getRegisteredElements()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(", ");
            }
            stringBuilder.append(chronoElement.name());
            stringBuilder.append('=');
            stringBuilder.append(this.get(chronoElement));
        }
        stringBuilder.append('}');
        Iterator iterator = this.getResult();
        if (iterator != null) {
            stringBuilder.append(">>>result=");
            stringBuilder.append(iterator);
        }
        return stringBuilder.toString();
    }

    protected final Chronology<T> getChronology() {
        throw new UnsupportedOperationException("Parsed values do not have any chronology.");
    }

    abstract void put(ChronoElement<?> var1, int var2);

    abstract void put(ChronoElement<?> var1, Object var2);

    abstract void setResult(Object var1);

    abstract <E> E getResult();
}

