/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Set;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.LiteralProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;

final class DecimalProcessor
implements FormatProcessor<BigDecimal> {
    private final FormatProcessor<Void> decimalSeparator;
    private final ChronoElement<BigDecimal> element;
    private final int precision;
    private final int scale;
    private final char zeroDigit;
    private final Leniency lenientMode;
    private final int protectedLength;

    DecimalProcessor(ChronoElement<BigDecimal> chronoElement, int n, int n2) {
        this.decimalSeparator = new LiteralProcessor((AttributeKey<Character>)Attributes.DECIMAL_SEPARATOR);
        this.element = chronoElement;
        this.precision = n;
        this.scale = n2;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (n < 2) {
            throw new IllegalArgumentException("Precision must be >= 2: " + n);
        }
        if (n2 >= n) {
            throw new IllegalArgumentException("Precision must be bigger than scale: " + n + "," + n2);
        }
        if (n2 < 1) {
            throw new IllegalArgumentException("Scale must be bigger than zero.");
        }
        this.zeroDigit = (char)48;
        this.lenientMode = Leniency.SMART;
        this.protectedLength = 0;
    }

    private DecimalProcessor(FormatProcessor<Void> formatProcessor, ChronoElement<BigDecimal> chronoElement, int n, int n2, char c, Leniency leniency, int n3) {
        this.decimalSeparator = formatProcessor;
        this.element = chronoElement;
        this.precision = n;
        this.scale = n2;
        this.zeroDigit = c;
        this.lenientMode = leniency;
        this.protectedLength = n3;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        int n;
        int n2;
        int n3;
        BigDecimal bigDecimal = ((BigDecimal)chronoDisplay.get(this.element)).setScale(this.scale, RoundingMode.FLOOR);
        String string = bigDecimal.toPlainString();
        int n4 = 0;
        int n5 = 0;
        int n6 = -1;
        int n7 = string.length();
        for (n3 = 0; n3 < n7; ++n3) {
            char c = string.charAt(n3);
            if (c == '.') {
                n6 = n3;
                continue;
            }
            if (n6 >= 0) {
                ++n5;
                continue;
            }
            ++n4;
        }
        n3 = this.precision - this.scale - n4;
        if (n3 < 0) {
            throw new IllegalArgumentException("Integer part of element value exceeds fixed format width: " + string);
        }
        StringBuilder stringBuilder = new StringBuilder(this.precision + 1);
        for (n2 = 0; n2 < n3; ++n2) {
            stringBuilder.append('0');
        }
        for (n2 = 0; n2 < n4; ++n2) {
            stringBuilder.append(string.charAt(n2));
        }
        this.decimalSeparator.print(chronoDisplay, stringBuilder, attributeQuery, set, bl);
        for (n2 = 0; n2 < n5; ++n2) {
            stringBuilder.append(string.charAt(n4 + 1 + n2));
        }
        for (n2 = 0; n2 < this.scale - n5; ++n2) {
            stringBuilder.append('0');
        }
        string = stringBuilder.toString();
        n2 = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        if (n2 != 48) {
            n = n2 - 48;
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                char c = cArray[i];
                if (c < '0' || c > '9') continue;
                cArray[i] = (char)(c + n);
            }
            string = new String(cArray);
        }
        n = -1;
        int n8 = string.length();
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        if (n != -1 && n8 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n8));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n;
        Leniency leniency;
        int n2;
        int n3;
        int n4 = charSequence.length();
        int n5 = n3 = parseLog.getPosition();
        int n6 = n2 = bl ? this.protectedLength : (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (n2 > 0) {
            n4 -= n2;
        }
        if (n5 >= n4) {
            parseLog.setError(n5, "Missing digits for: " + this.element.name());
            parseLog.setWarning();
            return;
        }
        char c = bl ? this.zeroDigit : ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue();
        int n7 = Math.min(n4, n5 + 18);
        long l = 0L;
        boolean bl2 = true;
        int n8 = 0;
        while (n5 + n8 < n7) {
            int n9 = charSequence.charAt(n5 + n8) - c;
            if (n9 >= 0 && n9 <= 9) {
                l = l * 10L + (long)n9;
                ++n8;
                bl2 = false;
                continue;
            }
            if (!bl2) break;
            parseLog.setError(n3, "Digit expected.");
            return;
        }
        Leniency leniency2 = leniency = bl ? this.lenientMode : (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        if (!leniency.isLax() && n8 != this.precision - this.scale) {
            parseLog.setError(n5, "Integer part of decimal element does not match expected width.");
            return;
        }
        parseLog.setPosition(n5 += n8);
        this.decimalSeparator.parse(charSequence, parseLog, attributeQuery, null, bl);
        if (parseLog.isError()) {
            return;
        }
        n7 = Math.min(n4, ++n5 + 18);
        int n10 = 0;
        long l2 = 0L;
        while (n5 + n10 < n7 && (n = charSequence.charAt(n5 + n10) - c) >= 0 && n <= 9) {
            l2 = l2 * 10L + (long)n;
            ++n10;
        }
        if (n10 == 0) {
            parseLog.setError(n5, "Fraction part expected.");
            return;
        }
        if (leniency.isStrict() && n10 != this.scale) {
            parseLog.setError(n5, "Fraction part of decimal element does not match expected width.");
            return;
        }
        parseLog.setPosition(n5 += n10);
        BigDecimal bigDecimal = new BigDecimal(l);
        BigDecimal bigDecimal2 = new BigDecimal(BigInteger.valueOf(l2), n10);
        BigDecimal bigDecimal3 = bigDecimal.add(bigDecimal2).stripTrailingZeros();
        parsedEntity.put(this.element, bigDecimal3);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DecimalProcessor) {
            DecimalProcessor decimalProcessor = (DecimalProcessor)object;
            return this.element.equals(decimalProcessor.element) && this.precision == decimalProcessor.precision && this.scale == decimalProcessor.scale;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.scale + this.precision * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", precision=");
        stringBuilder.append(this.precision);
        stringBuilder.append(", scale=");
        stringBuilder.append(this.scale);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<BigDecimal> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<BigDecimal> withElement(ChronoElement<BigDecimal> chronoElement) {
        if (this.element == chronoElement) {
            return this;
        }
        return new DecimalProcessor(chronoElement, this.precision, this.scale);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<BigDecimal> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        return new DecimalProcessor(this.decimalSeparator, this.element, this.precision, this.scale, ((Character)attributeQuery.get(Attributes.ZERO_DIGIT, (Object)Character.valueOf('0'))).charValue(), (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0));
    }
}

