/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Set;
import net.time4j.PlainDate;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSystem;
import net.time4j.format.NumericalElement;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.SignPolicy;
import net.time4j.history.internal.HistorizedElement;

class NumberProcessor<V>
implements FormatProcessor<V> {
    private final ChronoElement<V> element;
    private final boolean fixedWidth;
    private final int minDigits;
    private final int maxDigits;
    private final SignPolicy signPolicy;
    private final boolean protectedMode;
    private final boolean yearOfEra;
    private final Leniency lenientMode;
    private final int reserved;
    private final char zeroDigit;
    private final NumberSystem numberSystem;
    private final int protectedLength;
    private final int scaleOfNumsys;
    private final boolean fixedInt;
    private static final int[] THRESHOLDS = new int[]{9, 99, 999, 9999, 99999, 999999, 9999999, 99999999, 999999999, Integer.MAX_VALUE};

    NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2) {
        this(chronoElement, bl, n, n2, signPolicy, bl2, 0, '0', NumberSystem.ARABIC, Leniency.SMART, 0, false);
    }

    private NumberProcessor(ChronoElement<V> chronoElement, boolean bl, int n, int n2, SignPolicy signPolicy, boolean bl2, int n3, char c, NumberSystem numberSystem, Leniency leniency, int n4, boolean bl3) {
        this.element = chronoElement;
        this.fixedWidth = bl;
        this.minDigits = n;
        this.maxDigits = n2;
        this.signPolicy = signPolicy;
        this.protectedMode = bl2;
        this.fixedInt = bl3;
        if (chronoElement == null) {
            throw new NullPointerException("Missing element.");
        }
        if (signPolicy == null) {
            throw new NullPointerException("Missing sign policy.");
        }
        if (n < 1) {
            throw new IllegalArgumentException("Not positive: " + n);
        }
        if (n > n2) {
            throw new IllegalArgumentException("Max smaller than min: " + n2 + " < " + n);
        }
        if (bl && n != n2) {
            throw new IllegalArgumentException("Variable width in fixed-width-mode: " + n2 + " != " + n);
        }
        if (bl && signPolicy != SignPolicy.SHOW_NEVER) {
            throw new IllegalArgumentException("Sign policy must be SHOW_NEVER in fixed-width-mode.");
        }
        int n5 = this.getScale(numberSystem);
        if (numberSystem.isDecimal()) {
            if (n > n5) {
                throw new IllegalArgumentException("Min digits out of range: " + n);
            }
            if (n2 > n5) {
                throw new IllegalArgumentException("Max digits out of range: " + n2);
            }
        }
        this.yearOfEra = this.element.name().equals("YEAR_OF_ERA");
        this.reserved = n3;
        this.zeroDigit = c;
        this.numberSystem = numberSystem;
        this.lenientMode = leniency;
        this.protectedLength = n4;
        this.scaleOfNumsys = n5;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        char c;
        NumberSystem numberSystem;
        int n = appendable instanceof CharSequence ? ((CharSequence)((Object)appendable)).length() : -1;
        int n2 = 0;
        if (bl) {
            numberSystem = this.numberSystem;
            c = this.zeroDigit;
        } else {
            numberSystem = (NumberSystem)attributeQuery.get(Attributes.NUMBER_SYSTEM, (Object)NumberSystem.ARABIC);
            char c2 = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)((Character)attributeQuery.get(Attributes.ZERO_DIGIT)).charValue() : (c = numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        }
        if (bl && this.fixedInt) {
            int n3 = chronoDisplay.getInt(this.element);
            if (n3 < 0) {
                if (n3 == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Format context \"" + chronoDisplay + "\" without element: " + this.element);
                }
                throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
            }
            int n4 = NumberProcessor.length(n3);
            if (n4 > this.maxDigits) {
                throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the formatted value " + n3 + " exceeds the maximum width of " + this.maxDigits + ".");
            }
            int n5 = this.minDigits - n4;
            for (int i = 0; i < n5; ++i) {
                appendable.append('0');
                ++n2;
            }
            if (n4 == 2) {
                NumberProcessor.appendTwoDigits(n3, appendable, '0');
            } else if (n4 == 1) {
                appendable.append((char)(n3 + 48));
            } else if (n3 >= 2000 && n3 < 2100) {
                appendable.append('2');
                appendable.append('0');
                NumberProcessor.appendTwoDigits(n3 - 2000, appendable, '0');
            } else if (n3 >= 1900 && n3 < 2000) {
                appendable.append('1');
                appendable.append('9');
                NumberProcessor.appendTwoDigits(n3 - 1900, appendable, '0');
            } else {
                appendable.append(Integer.toString(n3));
            }
            n2 += n4;
        } else if (this.yearOfEra && this.element instanceof HistorizedElement) {
            HistorizedElement historizedElement = (HistorizedElement)HistorizedElement.class.cast(this.element);
            StringBuilder stringBuilder = new StringBuilder();
            historizedElement.print(chronoDisplay, stringBuilder, attributeQuery, numberSystem, c, this.minDigits, this.maxDigits);
            appendable.append(stringBuilder.toString());
            n2 = stringBuilder.length();
        } else {
            int n6;
            int n7;
            int n8;
            char c3 = numberSystem.getDigits().charAt(0);
            Class clazz = this.element.getType();
            boolean bl2 = false;
            boolean bl3 = numberSystem.isDecimal();
            String string = null;
            if (clazz == Integer.class) {
                n8 = chronoDisplay.getInt(this.element);
                if (n8 == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Format context \"" + chronoDisplay + "\" without element: " + this.element);
                }
                bl2 = n8 < 0;
                n7 = Math.abs(n8);
                n6 = NumberProcessor.length(n7);
            } else if (clazz == Long.class) {
                Object object = chronoDisplay.get(this.element);
                long l = (Long)Long.class.cast(object);
                bl2 = l < 0L;
                string = l == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(l));
                n7 = Integer.MIN_VALUE;
                n6 = string.length();
                c3 = '0';
            } else if (Enum.class.isAssignableFrom(clazz)) {
                Object object = chronoDisplay.get(this.element);
                int n9 = -1;
                if (this.element instanceof NumericalElement) {
                    n9 = ((NumericalElement)this.element).numerical(object);
                    bl2 = n9 < 0;
                } else {
                    for (Object t : clazz.getEnumConstants()) {
                        if (!t.equals(object)) continue;
                        n9 = ((Enum)Enum.class.cast(t)).ordinal();
                        break;
                    }
                    if (n9 == -1) {
                        throw new AssertionError((Object)("Enum broken: " + object + " / " + clazz.getName()));
                    }
                }
                if (n9 == Integer.MIN_VALUE) {
                    throw new IllegalArgumentException("Cannot print: " + this.element);
                }
                n7 = Math.abs(n9);
                n6 = NumberProcessor.length(n7);
            } else {
                throw new IllegalArgumentException("Not formattable: " + this.element);
            }
            if (bl3) {
                if (c != c3) {
                    n8 = c - c3;
                    if (string == null) {
                        string = numberSystem.toNumeral(n7);
                    }
                    char[] cArray = string.toCharArray();
                    for (int i = 0; i < cArray.length; ++i) {
                        cArray[i] = (char)(cArray[i] + n8);
                    }
                    string = new String(cArray);
                }
                if (n6 > this.maxDigits) {
                    if (string == null) {
                        string = numberSystem.toNumeral(n7);
                    }
                    throw new IllegalArgumentException("Element " + this.element.name() + " cannot be printed as the formatted value " + string + " exceeds the maximum width of " + this.maxDigits + ".");
                }
            }
            if (bl2) {
                if (this.signPolicy == SignPolicy.SHOW_NEVER) {
                    throw new IllegalArgumentException("Negative value not allowed according to sign policy.");
                }
                appendable.append('-');
                ++n2;
            } else {
                switch (this.signPolicy) {
                    case SHOW_ALWAYS: {
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                    case SHOW_WHEN_BIG_NUMBER: {
                        if (!bl3 || n6 <= this.minDigits) break;
                        appendable.append('+');
                        ++n2;
                        break;
                    }
                }
            }
            if (bl3) {
                int n10 = this.minDigits - n6;
                for (n8 = 0; n8 < n10; ++n8) {
                    appendable.append(c);
                    ++n2;
                }
            }
            if (string == null) {
                if (bl3) {
                    if (n6 == 2) {
                        NumberProcessor.appendTwoDigits(n7, appendable, c);
                    } else if (n6 == 1) {
                        appendable.append((char)(n7 + c));
                    } else if (n7 >= 2000 && n7 < 2100) {
                        appendable.append((char)(2 + c));
                        appendable.append(c);
                        NumberProcessor.appendTwoDigits(n7 - 2000, appendable, c);
                    } else if (n7 >= 1900 && n7 < 2000) {
                        appendable.append((char)('\u0001' + c));
                        appendable.append((char)(9 + c));
                        NumberProcessor.appendTwoDigits(n7 - 1900, appendable, c);
                    } else {
                        appendable.append(numberSystem.toNumeral(n7));
                    }
                } else {
                    n6 = numberSystem.toNumeral(n7, appendable);
                }
            } else {
                appendable.append(string);
                n6 = string.length();
            }
            n2 += n6;
        }
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(this.element, n, n + n2));
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void parse(CharSequence var1_1, ParseLog var2_2, AttributeQuery var3_3, ParsedEntity<?> var4_4, boolean var5_5) {
        var6_6 = var1_1.length();
        var7_7 = var2_2.getPosition();
        if (var5_5 && this.fixedInt) {
            if (var7_7 >= var6_6) {
                var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
                var2_2.setWarning();
                return;
            }
            var8_8 = var1_1.charAt(var7_7);
            if (var8_8 == '-' || var8_8 == '+') {
                var2_2.setError(var7_7, "Sign not allowed due to sign policy.");
                return;
            }
            var9_10 = var7_7 + this.minDigits;
            var10_13 = Math.min(var6_6, var9_10);
            var11_16 = 0;
            for (var12_18 = var7_7; var12_18 < var10_13 && (var13_20 = var1_1.charAt(var12_18) - 48) >= 0 && var13_20 <= 9; ++var12_18) {
                var11_16 = var11_16 * 10 + var13_20;
            }
            if (var12_18 < var9_10) {
                if (var12_18 == var7_7) {
                    var2_2.setError(var7_7, "Digit expected.");
                } else {
                    var2_2.setError(var7_7, "Not enough digits found for: " + this.element.name());
                }
                return;
            }
            var4_4.put(this.element, var11_16);
            var2_2.setPosition(var12_18);
            return;
        }
        v0 = var8_9 = var5_5 != false ? this.protectedLength : (Integer)var3_3.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        if (var8_9 > 0) {
            var6_6 -= var8_9;
        }
        if (var7_7 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            var2_2.setWarning();
            return;
        }
        if (this.yearOfEra && this.element instanceof HistorizedElement) {
            var9_11 = (HistorizedElement)HistorizedElement.class.cast(this.element);
            var10_14 = var9_11.parse(var1_1, var2_2.getPP(), var3_3, var4_4);
            if (var2_2.isError()) {
                var2_2.setError(var2_2.getErrorIndex(), "Unparseable element: " + this.element.name());
            } else if (var10_14 == null) {
                var2_2.setError(var7_7, "No interpretable value.");
            } else {
                var4_4.put(this.element, var10_14);
            }
            return;
        }
        var11_17 = 1;
        if (var5_5) {
            var9_12 = this.numberSystem;
            var12_19 = this.scaleOfNumsys;
            var10_15 = this.zeroDigit;
            var13_21 = var9_12.isDecimal();
        } else {
            var9_12 = (NumberSystem)var3_3.get(Attributes.NUMBER_SYSTEM, (Object)NumberSystem.ARABIC);
            var13_21 = var9_12.isDecimal();
            var12_19 = this.getScale(var9_12);
            var10_15 = var3_3.contains(Attributes.ZERO_DIGIT) != false ? (int)((Character)var3_3.get(Attributes.ZERO_DIGIT)).charValue() : (var13_21 != false ? (int)var9_12.getDigits().charAt(0) : 48);
        }
        v1 = var14_22 = var5_5 != false ? this.lenientMode : (Leniency)var3_3.get(Attributes.LENIENCY, (Object)Leniency.SMART);
        if (var13_21 && (this.fixedWidth || !var14_22.isLax())) {
            var11_17 = this.minDigits;
            var12_19 = this.maxDigits;
        }
        var15_23 = var7_7;
        var16_24 = false;
        var17_25 = var1_1.charAt(var15_23);
        if (var17_25 == '-' || var17_25 == '+') {
            if (this.signPolicy == SignPolicy.SHOW_NEVER && (this.fixedWidth || var14_22.isStrict())) {
                var2_2.setError(var7_7, "Sign not allowed due to sign policy.");
                return;
            }
            if (this.signPolicy == SignPolicy.SHOW_WHEN_NEGATIVE && var17_25 == '+' && var14_22.isStrict()) {
                var2_2.setError(var7_7, "Positive sign not allowed due to sign policy.");
                return;
            }
            var16_24 = var17_25 == '-';
            ++var15_23;
            ++var7_7;
        } else if (this.signPolicy == SignPolicy.SHOW_ALWAYS && var14_22.isStrict()) {
            var2_2.setError(var7_7, "Missing sign of number.");
            return;
        }
        if (var15_23 >= var6_6) {
            var2_2.setError(var7_7, "Missing digits for: " + this.element.name());
            return;
        }
        if (!this.fixedWidth && this.reserved > 0 && var8_9 <= 0) {
            var18_26 = 0;
            if (var13_21) {
                for (var19_27 = var15_23; var19_27 < var6_6 && (var20_28 = var1_1.charAt(var19_27) - var10_15) >= 0 && var20_28 <= 9; ++var19_27) {
                    ++var18_26;
                }
            } else {
                for (var19_27 = var15_23; var19_27 < var6_6 && var9_12.contains(var1_1.charAt(var19_27)); ++var19_27) {
                    ++var18_26;
                }
            }
            var12_19 = Math.min(var12_19, var18_26 - this.reserved);
        }
        var18_26 = var15_23 + var11_17;
        var19_27 = Math.min(var6_6, var15_23 + var12_19);
        var20_29 = 0L;
        if (var13_21) {
            while (var15_23 < var19_27 && (var22_30 = var1_1.charAt(var15_23) - var10_15) >= 0 && var22_30 <= 9) {
                var20_29 = var20_29 * 10L + (long)var22_30;
                ++var15_23;
            }
        } else {
            var22_30 = 0;
            while (var15_23 < var19_27 && var9_12.contains(var1_1.charAt(var15_23))) {
                ++var22_30;
                ++var15_23;
            }
            try {
                if (var22_30 <= 0) ** GOTO lbl112
                var20_29 = var9_12.toInteger(var1_1.subSequence(var15_23 - var22_30, var15_23).toString(), var14_22);
            }
            catch (NumberFormatException var23_32) {
                var2_2.setError(var7_7, var23_32.getMessage());
                return;
            }
        }
lbl112:
        // 3 sources

        if (var15_23 < var18_26) {
            if (var15_23 == var7_7) {
                var2_2.setError(var7_7, "Digit expected.");
                return;
            }
            if (this.fixedWidth || !var14_22.isLax()) {
                var2_2.setError(var7_7, "Not enough digits found for: " + this.element.name());
                return;
            }
        }
        if (var16_24) {
            if (var20_29 == 0L && var14_22.isStrict()) {
                var2_2.setError(var7_7 - 1, "Negative zero is not allowed.");
                return;
            }
            var20_29 = -var20_29;
        } else if (this.signPolicy == SignPolicy.SHOW_WHEN_BIG_NUMBER && var14_22.isStrict() && var13_21) {
            if (var17_25 == '+' && var15_23 <= var18_26) {
                var2_2.setError(var7_7 - 1, "Positive sign only allowed for big number.");
            } else if (var17_25 != '+' && var15_23 > var18_26) {
                var2_2.setError(var7_7, "Positive sign must be present for big number.");
            }
        }
        var22_31 /* !! */  = null;
        var23_33 = this.element.getType();
        if (var23_33 == Integer.class) {
            var4_4.put(this.element, (int)var20_29);
            var2_2.setPosition(var15_23);
            return;
        }
        if (var23_33 == Long.class) {
            var22_31 /* !! */  = var20_29;
        } else {
            if (this.element == PlainDate.MONTH_OF_YEAR) {
                var4_4.put((ChronoElement<?>)PlainDate.MONTH_AS_NUMBER, (int)var20_29);
                var2_2.setPosition(var15_23);
                return;
            }
            if (Enum.class.isAssignableFrom(var23_33)) {
                if (this.element instanceof NumericalElement) {
                    var24_34 = (NumericalElement)this.element;
                    for (T var28_42 : var23_33.getEnumConstants()) {
                        if ((long)var24_34.numerical(var23_33.cast(var28_42)) != var20_29) continue;
                        var22_31 /* !! */  = var28_42;
                        break;
                    }
                } else {
                    for (T var27_41 : var23_33.getEnumConstants()) {
                        if ((long)((Enum)Enum.class.cast(var27_41)).ordinal() != var20_29) continue;
                        var22_31 /* !! */  = var27_41;
                        break;
                    }
                }
                if (var22_31 /* !! */  == null) {
                    var2_2.setError(var17_25 == '-' || var17_25 == '+' ? var7_7 - 1 : var7_7, "[" + this.element.name() + "] No enum found for value: " + var20_29);
                    return;
                }
            } else {
                throw new IllegalArgumentException("Not parseable: " + this.element);
            }
        }
        var4_4.put(this.element, var22_31 /* !! */ );
        var2_2.setPosition(var15_23);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof NumberProcessor) {
            NumberProcessor numberProcessor = (NumberProcessor)object;
            return this.element.equals(numberProcessor.element) && this.fixedWidth == numberProcessor.fixedWidth && this.minDigits == numberProcessor.minDigits && this.maxDigits == numberProcessor.maxDigits && this.signPolicy == numberProcessor.signPolicy && this.protectedMode == numberProcessor.protectedMode;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.element.hashCode() + 31 * (this.minDigits + this.maxDigits * 10);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[element=");
        stringBuilder.append(this.element.name());
        stringBuilder.append(", fixed-width-mode=");
        stringBuilder.append(this.fixedWidth);
        stringBuilder.append(", min-digits=");
        stringBuilder.append(this.minDigits);
        stringBuilder.append(", max-digits=");
        stringBuilder.append(this.maxDigits);
        stringBuilder.append(", sign-policy=");
        stringBuilder.append((Object)this.signPolicy);
        stringBuilder.append(", protected-mode=");
        stringBuilder.append(this.protectedMode);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<V> getElement() {
        return this.element;
    }

    @Override
    public FormatProcessor<V> withElement(ChronoElement<V> chronoElement) {
        if (this.protectedMode || this.element == chronoElement) {
            return this;
        }
        return new NumberProcessor<V>(chronoElement, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, false);
    }

    @Override
    public boolean isNumerical() {
        return true;
    }

    @Override
    public FormatProcessor<V> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        NumberSystem numberSystem = (NumberSystem)attributeQuery.get(Attributes.NUMBER_SYSTEM, (Object)NumberSystem.ARABIC);
        char c = attributeQuery.contains(Attributes.ZERO_DIGIT) ? (char)((Character)attributeQuery.get(Attributes.ZERO_DIGIT)).charValue() : (numberSystem.isDecimal() ? (char)numberSystem.getDigits().charAt(0) : (char)'0');
        int n2 = (Integer)attributeQuery.get(Attributes.PROTECTED_CHARACTERS, (Object)0);
        boolean bl = numberSystem == NumberSystem.ARABIC && c == '0' && this.fixedWidth && n2 == 0 && this.element.getType() == Integer.class && !this.yearOfEra;
        return new NumberProcessor<V>(this.element, this.fixedWidth, this.minDigits, this.maxDigits, this.signPolicy, this.protectedMode, n, c, numberSystem, (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART), n2, bl);
    }

    private int getScale(NumberSystem numberSystem) {
        if (numberSystem.isDecimal()) {
            return this.element.getType() == Long.class ? 18 : 9;
        }
        return 100;
    }

    private static int length(int n) {
        assert (n >= 0);
        int n2 = 0;
        while (n > THRESHOLDS[n2]) {
            ++n2;
        }
        return n2 + 1;
    }

    private static void appendTwoDigits(int n, Appendable appendable, char c) throws IOException {
        int n2 = n * 103 >>> 10;
        int n3 = n - ((n2 << 3) + (n2 << 1));
        appendable.append((char)(n2 + c));
        appendable.append((char)(n3 + c));
    }
}

