/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Locale;
import java.util.Optional;
import java.util.ServiceLoader;
import net.time4j.PlainDate;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarProvider;
import net.time4j.engine.CalendarSystem;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;

final class CalendarConverter<T extends ChronoEntity<T>>
implements Converter<CalendarDate, T> {
    private final Chronology<T> chronology;
    private final String calendarVariant;

    private CalendarConverter(Chronology<T> chronology, String string) {
        this.chronology = chronology;
        this.calendarVariant = string;
    }

    static Chronology<CalendarDate> getChronology(Locale locale) {
        String string = locale.getUnicodeLocaleType("ca");
        if (string == null) {
            return CalendarConverter.adapt(PlainDate.axis(), "");
        }
        if (string.equals("ethiopic-amete-alem")) {
            string = "ethioaa";
        } else if (string.equals("islamicc")) {
            string = "islamic-civil";
        } else if (string.equals("islamic")) {
            string = "islamic-icu4j";
        }
        for (CalendarProvider calendarProvider : ServiceLoader.load(CalendarProvider.class)) {
            Optional optional = calendarProvider.findChronology(string);
            if (!optional.isPresent()) continue;
            int n = string.indexOf(45);
            String string2 = n == -1 ? "" : string.substring(n + 1);
            return CalendarConverter.adapt((Chronology)optional.get(), string2);
        }
        throw new IllegalArgumentException("Could not find any calendar for: " + string);
    }

    public T translate(CalendarDate calendarDate) {
        CalendarSystem calendarSystem = this.chronology instanceof CalendarFamily ? this.chronology.getCalendarSystem(this.calendarVariant) : this.chronology.getCalendarSystem();
        return (T)((ChronoEntity)calendarSystem.transform(calendarDate.getDaysSinceEpochUTC()));
    }

    public Class<CalendarDate> getSourceType() {
        return CalendarDate.class;
    }

    public CalendarDate from(T t) {
        return (CalendarDate)t;
    }

    private static <T extends ChronoEntity<T>> Chronology<CalendarDate> adapt(Chronology<?> chronology, String string) {
        Chronology<?> chronology2 = chronology;
        CalendarConverter calendarConverter = new CalendarConverter(chronology2, string);
        return new BridgeChronology(calendarConverter, chronology2);
    }
}

