/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Locale;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.CalendarText;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.TZID;
import net.time4j.tz.ZonalOffset;

enum TimezoneElement implements ChronoElement<TZID>
{
    TIMEZONE_ID,
    TIMEZONE_OFFSET;


    public Class<TZID> getType() {
        return TZID.class;
    }

    public char getSymbol() {
        return '\u0000';
    }

    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        TZID tZID = chronoDisplay.getTimezone();
        TZID tZID2 = chronoDisplay2.getTimezone();
        return tZID.canonical().compareTo(tZID2.canonical());
    }

    public TZID getDefaultMinimum() {
        return ZonalOffset.ofHours((OffsetSign)OffsetSign.BEHIND_UTC, (int)14);
    }

    public TZID getDefaultMaximum() {
        return ZonalOffset.ofHours((OffsetSign)OffsetSign.AHEAD_OF_UTC, (int)14);
    }

    public boolean isDateElement() {
        return false;
    }

    public boolean isTimeElement() {
        return false;
    }

    public boolean isLenient() {
        return false;
    }

    public String getDisplayName(Locale locale) {
        String string = (String)CalendarText.getIsoInstance((Locale)locale).getTextForms().get("L_zone");
        return string == null ? this.name() : string;
    }
}

