/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.AttributeSet;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.CustomizedProcessor;
import net.time4j.format.expert.DecimalProcessor;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FractionProcessor;
import net.time4j.format.expert.MergedAttributes;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.StyleProcessor;
import net.time4j.format.internal.DualFormatElement;

final class FormatStep {
    private final FormatProcessor<?> processor;
    private final int level;
    private final int section;
    private final AttributeSet sectionalAttrs;
    private final AttributeQuery fullAttrs;
    private final int reserved;
    private final int padLeft;
    private final int padRight;
    private final boolean orMarker;
    private final int lastOrBlockIndex;

    FormatStep(FormatProcessor<?> formatProcessor, int n, int n2, AttributeSet attributeSet) {
        this(formatProcessor, n, n2, attributeSet, null, 0, 0, 0, false, -1);
    }

    private FormatStep(FormatProcessor<?> formatProcessor, int n, int n2, AttributeSet attributeSet, AttributeQuery attributeQuery, int n3, int n4, int n5, boolean bl, int n6) {
        if (formatProcessor == null) {
            throw new NullPointerException("Missing format processor.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Invalid level: " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Invalid section: " + n2);
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Reserved chars must not be negative: " + n3);
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("Invalid pad-width: " + n4);
        }
        if (n5 < 0) {
            throw new IllegalArgumentException("Invalid pad-width: " + n5);
        }
        this.processor = formatProcessor;
        this.level = n;
        this.section = n2;
        this.sectionalAttrs = attributeSet;
        this.fullAttrs = attributeQuery;
        this.reserved = n3;
        this.padLeft = n4;
        this.padRight = n5;
        this.orMarker = bl;
        this.lastOrBlockIndex = n6;
    }

    int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        int n;
        block20: {
            int n2;
            char c;
            boolean bl2;
            StringBuilder stringBuilder;
            LinkedHashSet<ElementPosition> linkedHashSet;
            int n3;
            int n4;
            block19: {
                AttributeQuery attributeQuery2;
                if (!this.isPrinting(chronoDisplay)) {
                    return 0;
                }
                AttributeQuery attributeQuery3 = attributeQuery2 = bl ? this.fullAttrs : this.getQuery(attributeQuery);
                if (this.padLeft == 0 && this.padRight == 0) {
                    return this.processor.print(chronoDisplay, appendable, attributeQuery2, set, bl);
                }
                n4 = -1;
                n3 = -1;
                linkedHashSet = null;
                if (appendable instanceof StringBuilder) {
                    stringBuilder = (StringBuilder)appendable;
                    n4 = stringBuilder.length();
                } else {
                    stringBuilder = new StringBuilder();
                }
                if (appendable instanceof CharSequence && set != null) {
                    n3 = stringBuilder == appendable && (this.processor instanceof CustomizedProcessor || this.processor instanceof StyleProcessor) ? 0 : ((CharSequence)((Object)appendable)).length();
                    linkedHashSet = new LinkedHashSet<ElementPosition>();
                }
                bl2 = this.isStrict(attributeQuery2);
                c = this.getPadChar(attributeQuery2);
                n2 = stringBuilder.length();
                this.processor.print(chronoDisplay, stringBuilder, attributeQuery2, linkedHashSet, bl);
                n = n2 = stringBuilder.length() - n2;
                if (this.padLeft <= 0) break block19;
                if (bl2 && n2 > this.padLeft) {
                    throw new IllegalArgumentException(this.padExceeded());
                }
                int n5 = 0;
                while (n < this.padLeft) {
                    if (n4 == -1) {
                        appendable.append(c);
                    } else {
                        stringBuilder.insert(n4, c);
                    }
                    ++n;
                    ++n5;
                }
                if (n4 == -1) {
                    appendable.append(stringBuilder);
                }
                if (n3 != -1) {
                    n3 += n5;
                    for (ElementPosition elementPosition : linkedHashSet) {
                        set.add(new ElementPosition(elementPosition.getElement(), n3 + elementPosition.getStartIndex(), n3 + elementPosition.getEndIndex()));
                    }
                }
                if (this.padRight <= 0) break block20;
                if (bl2 && n2 > this.padRight) {
                    throw new IllegalArgumentException(this.padExceeded());
                }
                while (n2 < this.padRight) {
                    appendable.append(c);
                    ++n2;
                    ++n;
                }
                break block20;
            }
            if (bl2 && n2 > this.padRight) {
                throw new IllegalArgumentException(this.padExceeded());
            }
            if (n4 == -1) {
                appendable.append(stringBuilder);
            }
            while (n < this.padRight) {
                appendable.append(c);
                ++n;
            }
            if (n3 != -1) {
                for (ElementPosition elementPosition : linkedHashSet) {
                    set.add(new ElementPosition(elementPosition.getElement(), n3 + elementPosition.getStartIndex(), n3 + elementPosition.getEndIndex()));
                }
            }
        }
        return n;
    }

    void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n;
        AttributeQuery attributeQuery2;
        AttributeQuery attributeQuery3 = attributeQuery2 = bl ? this.fullAttrs : this.getQuery(attributeQuery);
        if (this.padLeft == 0 && this.padRight == 0) {
            this.doParse(charSequence, parseLog, attributeQuery2, parsedEntity, bl);
            return;
        }
        boolean bl2 = this.isStrict(attributeQuery2);
        char c = this.getPadChar(attributeQuery2);
        int n2 = parseLog.getPosition();
        int n3 = charSequence.length();
        for (n = n2; n < n3 && charSequence.charAt(n) == c; ++n) {
        }
        int n4 = n - n2;
        if (bl2 && n4 > this.padLeft) {
            parseLog.setError(n2, this.padExceeded());
            return;
        }
        parseLog.setPosition(n);
        this.doParse(charSequence, parseLog, attributeQuery2, parsedEntity, bl);
        if (parseLog.isError()) {
            return;
        }
        n = parseLog.getPosition();
        int n5 = n - n2 - n4;
        if (bl2 && this.padLeft > 0 && n5 + n4 != this.padLeft) {
            parseLog.setError(n2, this.padMismatched());
            return;
        }
        int n6 = 0;
        while (!(n >= n3 || bl2 && n5 + n6 >= this.padRight || charSequence.charAt(n) != c)) {
            ++n;
            ++n6;
        }
        if (bl2 && this.padRight > 0 && n5 + n6 != this.padRight) {
            parseLog.setError(n - n6, this.padMismatched());
            return;
        }
        parseLog.setPosition(n);
    }

    int getLevel() {
        return this.level;
    }

    int getSection() {
        return this.section;
    }

    boolean isDecimal() {
        return this.processor instanceof FractionProcessor || this.processor instanceof DecimalProcessor;
    }

    boolean isNumerical() {
        return this.processor.isNumerical();
    }

    FormatProcessor<?> getProcessor() {
        return this.processor;
    }

    FormatStep quickPath(ChronoFormatter<?> chronoFormatter) {
        AttributeSet attributeSet = chronoFormatter.getAttributes0();
        if (this.sectionalAttrs != null) {
            Attributes attributes = new Attributes.Builder().setAll(attributeSet.getAttributes()).setAll(this.sectionalAttrs.getAttributes()).build();
            attributeSet = attributeSet.withAttributes(attributes);
        }
        return new FormatStep(this.processor.quickPath(chronoFormatter, attributeSet, this.reserved), this.level, this.section, this.sectionalAttrs, attributeSet, this.reserved, this.padLeft, this.padRight, this.orMarker, this.lastOrBlockIndex);
    }

    FormatStep updateElement(ChronoElement<?> chronoElement) {
        FormatProcessor<?> formatProcessor = FormatStep.update(this.processor, chronoElement);
        if (this.processor == formatProcessor) {
            return this;
        }
        return new FormatStep(formatProcessor, this.level, this.section, this.sectionalAttrs, this.fullAttrs, this.reserved, this.padLeft, this.padRight, this.orMarker, this.lastOrBlockIndex);
    }

    FormatStep reserve(int n) {
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, null, this.reserved + n, this.padLeft, this.padRight, this.orMarker, this.lastOrBlockIndex);
    }

    FormatStep pad(int n, int n2) {
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, null, this.reserved, this.padLeft + n, this.padRight + n2, this.orMarker, this.lastOrBlockIndex);
    }

    FormatStep startNewOrBlock() {
        if (this.orMarker) {
            throw new IllegalStateException("Cannot start or-block twice.");
        }
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, null, this.reserved, this.padLeft, this.padRight, true, -1);
    }

    FormatStep markLastOrBlock(int n) {
        if (!this.orMarker) {
            throw new IllegalStateException("This step is not starting an or-block.");
        }
        return new FormatStep(this.processor, this.level, this.section, this.sectionalAttrs, this.fullAttrs, this.reserved, this.padLeft, this.padRight, true, n);
    }

    boolean isNewOrBlockStarted() {
        return this.orMarker;
    }

    int skipTrailingOrBlocks() {
        return this.lastOrBlockIndex;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FormatStep) {
            FormatStep formatStep = (FormatStep)object;
            return this.processor.equals(formatStep.processor) && this.level == formatStep.level && this.section == formatStep.section && FormatStep.isEqual(this.sectionalAttrs, formatStep.sectionalAttrs) && FormatStep.isEqual(this.fullAttrs, formatStep.fullAttrs) && this.reserved == formatStep.reserved && this.padLeft == formatStep.padLeft && this.padRight == formatStep.padRight && this.orMarker == formatStep.orMarker && this.lastOrBlockIndex == formatStep.lastOrBlockIndex;
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.processor.hashCode() + 31 * (this.sectionalAttrs == null ? 0 : this.sectionalAttrs.hashCode());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[processor=");
        stringBuilder.append(this.processor);
        stringBuilder.append(", level=");
        stringBuilder.append(this.level);
        stringBuilder.append(", section=");
        stringBuilder.append(this.section);
        if (this.sectionalAttrs != null) {
            stringBuilder.append(", attributes=");
            stringBuilder.append(this.sectionalAttrs);
        }
        stringBuilder.append(", reserved=");
        stringBuilder.append(this.reserved);
        stringBuilder.append(", pad-left=");
        stringBuilder.append(this.padLeft);
        stringBuilder.append(", pad-right=");
        stringBuilder.append(this.padRight);
        if (this.orMarker) {
            stringBuilder.append(", or-block-started");
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    private AttributeQuery getQuery(AttributeQuery attributeQuery) {
        if (this.sectionalAttrs == null) {
            return attributeQuery;
        }
        return new MergedAttributes(this.sectionalAttrs, attributeQuery);
    }

    private static <V> FormatProcessor<V> update(FormatProcessor<V> formatProcessor, ChronoElement<?> chronoElement) {
        if (formatProcessor.getElement() == null) {
            return formatProcessor;
        }
        if (formatProcessor.getElement().getType() != chronoElement.getType() && !(chronoElement instanceof DualFormatElement)) {
            throw new IllegalArgumentException("Cannot change element value type: " + chronoElement.name());
        }
        return formatProcessor.withElement(chronoElement);
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    private void doParse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        int n = parseLog.getPosition();
        try {
            this.processor.parse(charSequence, parseLog, attributeQuery, parsedEntity, bl);
        }
        catch (RuntimeException runtimeException) {
            parseLog.setError(n, runtimeException.getMessage());
        }
    }

    private boolean isStrict(AttributeQuery attributeQuery) {
        return ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isStrict();
    }

    private char getPadChar(AttributeQuery attributeQuery) {
        return ((Character)attributeQuery.get(Attributes.PAD_CHAR, (Object)Character.valueOf(' '))).charValue();
    }

    private String padExceeded() {
        return "Pad width exceeded: " + this.processor.getElement().name();
    }

    private String padMismatched() {
        return "Pad width mismatched: " + this.processor.getElement().name();
    }

    private boolean isPrinting(ChronoDisplay chronoDisplay) {
        if (this.sectionalAttrs == null) {
            return true;
        }
        ChronoCondition<ChronoDisplay> chronoCondition = this.sectionalAttrs.getCondition();
        return chronoCondition == null || chronoCondition.test((Object)chronoDisplay);
    }
}

