/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.format.expert.ParsedEntity;

class ParsedValue
extends ParsedEntity<ParsedValue> {
    private Object result = null;
    private Map<ChronoElement<?>, Object> map = null;

    ParsedValue() {
    }

    public boolean contains(ChronoElement<?> chronoElement) {
        if (chronoElement != null && this.map != null) {
            return this.map.containsKey(chronoElement);
        }
        return false;
    }

    public <V> V get(ChronoElement<V> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException();
        }
        Map<ChronoElement<?>, Object> map = this.map;
        if (map != null && map.containsKey(chronoElement)) {
            return (V)chronoElement.getType().cast(map.get(chronoElement));
        }
        throw new ChronoException("No value found for: " + chronoElement.name());
    }

    public int getInt(ChronoElement<Integer> chronoElement) {
        if (chronoElement == null) {
            throw new NullPointerException();
        }
        Map<ChronoElement<?>, Object> map = this.map;
        if (map != null && map.containsKey(chronoElement)) {
            return (Integer)chronoElement.getType().cast(map.get(chronoElement));
        }
        return Integer.MIN_VALUE;
    }

    public Set<ChronoElement<?>> getRegisteredElements() {
        if (this.map == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.map.keySet());
    }

    @Override
    void put(ChronoElement<?> chronoElement, int n) {
        if (chronoElement == null) {
            throw new NullPointerException();
        }
        Map<ChronoElement<?>, Object> map = this.map;
        if (map == null) {
            map = new HashMap();
            this.map = map;
        }
        map.put(chronoElement, n);
    }

    @Override
    void put(ChronoElement<?> chronoElement, Object object) {
        if (chronoElement == null) {
            throw new NullPointerException();
        }
        if (object == null) {
            if (this.map != null) {
                this.map.remove(chronoElement);
                if (this.map.isEmpty()) {
                    this.map = null;
                }
            }
        } else {
            Map<ChronoElement<?>, Object> map = this.map;
            if (map == null) {
                map = new HashMap();
                this.map = map;
            }
            map.put(chronoElement, object);
        }
    }

    @Override
    void setResult(Object object) {
        this.result = object;
    }

    @Override
    <E> E getResult() {
        return (E)this.result;
    }
}

