/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.time4j.Weekday;
import net.time4j.base.ResourceLoader;
import net.time4j.format.WeekdataProvider;
import net.time4j.format.internal.FormatUtils;

public class WeekdataProviderSPI
implements WeekdataProvider {
    private final String source;
    private final Set<String> countriesWithMinDays4;
    private final Map<String, Weekday> firstDayOfWeek;
    private final Map<String, Weekday> startOfWeekend;
    private final Map<String, Weekday> endOfWeekend;

    /*
     * WARNING - void declaration
     */
    public WeekdataProviderSPI() {
        String string = "data/week.data";
        URI uRI = ResourceLoader.getInstance().locate("i18n", WeekdataProviderSPI.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            try {
                inputStream = ResourceLoader.getInstance().load(WeekdataProviderSPI.class, string, true);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (inputStream != null) {
            this.source = "@" + uRI;
            HashSet<String[]> hashSet = new HashSet<String[]>();
            HashMap hashMap = new HashMap();
            HashMap<String, Weekday> hashMap2 = new HashMap<String, Weekday>();
            HashMap hashMap3 = new HashMap();
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    void var13_22;
                    HashMap<String, Weekday> hashMap4;
                    Object object;
                    String string32;
                    if (string2.startsWith("#")) continue;
                    int n = string2.indexOf(61);
                    String string4 = string2.substring(0, n).trim();
                    String[] stringArray = string2.substring(n + 1).split(" ");
                    if (string4.equals("minDays-4")) {
                        for (String string32 : stringArray) {
                            String[] stringArray2 = string32.trim().toUpperCase(Locale.US);
                            if (stringArray2.isEmpty()) continue;
                            hashSet.add(stringArray2);
                        }
                        continue;
                    }
                    if (string4.startsWith("start-")) {
                        String string5 = string4.substring(6);
                        object = Weekday.SATURDAY;
                        hashMap4 = hashMap2;
                    } else if (string4.startsWith("end-")) {
                        String string6 = string4.substring(4);
                        object = Weekday.SUNDAY;
                        hashMap4 = hashMap3;
                    } else if (string4.startsWith("first-")) {
                        String string7 = string4.substring(6);
                        object = Weekday.MONDAY;
                        hashMap4 = hashMap;
                    } else {
                        throw new IllegalStateException("Unexpected format: " + this.source);
                    }
                    string32 = WeekdataProviderSPI.toEnum((String)var13_22);
                    if (string32 != null) {
                        object = string32;
                    }
                    for (String string8 : stringArray) {
                        String string9 = string8.trim().toUpperCase(Locale.US);
                        if (string9.isEmpty()) continue;
                        hashMap4.put(string9, (Weekday)object);
                    }
                }
                this.countriesWithMinDays4 = Collections.unmodifiableSet(hashSet);
                this.firstDayOfWeek = Collections.unmodifiableMap(hashMap);
                this.startOfWeekend = Collections.unmodifiableMap(hashMap2);
                this.endOfWeekend = Collections.unmodifiableMap(hashMap3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (Exception exception) {
                throw new IllegalStateException("Unexpected format: " + this.source, exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        this.source = "@STATIC";
        this.countriesWithMinDays4 = Collections.emptySet();
        this.firstDayOfWeek = Collections.emptyMap();
        this.startOfWeekend = Collections.emptyMap();
        this.endOfWeekend = Collections.emptyMap();
        System.err.println("Warning: File \"" + string + "\" not found.");
    }

    public int getFirstDayOfWeek(Locale locale) {
        Object object;
        String string = locale.getUnicodeLocaleType("fw");
        if (string != null && (object = WeekdataProviderSPI.toEnum(string)) != null) {
            return object.getValue();
        }
        if (this.firstDayOfWeek.isEmpty()) {
            object = new GregorianCalendar(locale);
            int n = ((Calendar)object).getFirstDayOfWeek();
            return n == 1 ? 7 : n - 1;
        }
        object = FormatUtils.getRegion((Locale)locale);
        Weekday weekday = Weekday.MONDAY;
        if (this.firstDayOfWeek.containsKey(object)) {
            weekday = this.firstDayOfWeek.get(object);
        }
        return weekday.getValue();
    }

    public int getMinimalDaysInFirstWeek(Locale locale) {
        if (this.countriesWithMinDays4.isEmpty()) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
            return gregorianCalendar.getMinimalDaysInFirstWeek();
        }
        String string = FormatUtils.getRegion((Locale)locale);
        int n = 1;
        if (string.isEmpty() && locale.getLanguage().isEmpty()) {
            n = 4;
        } else if (this.countriesWithMinDays4.contains(string)) {
            n = 4;
        }
        return n;
    }

    public int getStartOfWeekend(Locale locale) {
        String string = FormatUtils.getRegion((Locale)locale);
        Weekday weekday = Weekday.SATURDAY;
        if (this.startOfWeekend.containsKey(string)) {
            weekday = this.startOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public int getEndOfWeekend(Locale locale) {
        String string = FormatUtils.getRegion((Locale)locale);
        Weekday weekday = Weekday.SUNDAY;
        if (this.endOfWeekend.containsKey(string)) {
            weekday = this.endOfWeekend.get(string);
        }
        return weekday.getValue();
    }

    public String toString() {
        return this.getClass().getName() + this.source;
    }

    private static Weekday toEnum(String string) {
        switch (string) {
            case "mon": {
                return Weekday.MONDAY;
            }
            case "tue": {
                return Weekday.TUESDAY;
            }
            case "wed": {
                return Weekday.WEDNESDAY;
            }
            case "thu": {
                return Weekday.THURSDAY;
            }
            case "fri": {
                return Weekday.FRIDAY;
            }
            case "sat": {
                return Weekday.SATURDAY;
            }
            case "sun": {
                return Weekday.SUNDAY;
            }
        }
        return null;
    }
}

