/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.DisplayMode;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.ParsedEntity;
import net.time4j.format.expert.PatternType;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

final class StyleProcessor<T>
implements FormatProcessor<T> {
    private final ChronoFormatter<T> formatter;
    private final DisplayStyle dateStyle;
    private final DisplayStyle timeStyle;

    StyleProcessor(DisplayStyle displayStyle, DisplayStyle displayStyle2) {
        this(null, displayStyle, displayStyle2);
    }

    private StyleProcessor(ChronoFormatter<T> chronoFormatter, DisplayStyle displayStyle, DisplayStyle displayStyle2) {
        if (displayStyle == null || displayStyle2 == null) {
            throw new NullPointerException("Missing display style.");
        }
        this.dateStyle = displayStyle;
        this.timeStyle = displayStyle2;
        this.formatter = chronoFormatter;
    }

    @Override
    public int print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, boolean bl) throws IOException {
        ChronoFormatter<T> chronoFormatter = this.getFormatter(attributeQuery, bl);
        Set<ElementPosition> set2 = chronoFormatter.print(chronoDisplay, appendable, attributeQuery, set != null);
        if (set != null) {
            set.addAll(set2);
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, ParsedEntity<?> parsedEntity, boolean bl) {
        ChronoFormatter<T> chronoFormatter = this.getFormatter(attributeQuery, bl);
        T t = chronoFormatter.parse(charSequence, parseLog, attributeQuery);
        if (!parseLog.isError() && t != null) {
            parsedEntity.setResult(t);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StyleProcessor) {
            StyleProcessor styleProcessor = (StyleProcessor)object;
            if (this.dateStyle.equals(styleProcessor.dateStyle) && this.timeStyle.equals(styleProcessor.timeStyle)) {
                if (this.formatter == null) {
                    return styleProcessor.formatter == null;
                }
                return this.formatter.equals(styleProcessor.formatter);
            }
        }
        return false;
    }

    public int hashCode() {
        return this.formatter == null ? 0 : this.formatter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[date-style=");
        stringBuilder.append(this.dateStyle);
        stringBuilder.append(",time-style=");
        stringBuilder.append(this.timeStyle);
        stringBuilder.append(",delegate=");
        stringBuilder.append(this.formatter);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public ChronoElement<T> getElement() {
        return null;
    }

    @Override
    public FormatProcessor<T> withElement(ChronoElement<T> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    @Override
    public FormatProcessor<T> quickPath(ChronoFormatter<?> chronoFormatter, AttributeQuery attributeQuery, int n) {
        TransitionStrategy transitionStrategy = (TransitionStrategy)attributeQuery.get(Attributes.TRANSITION_STRATEGY, (Object)Timezone.DEFAULT_CONFLICT_STRATEGY);
        TZID tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID, null);
        Locale locale = (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)Locale.ROOT);
        ChronoFormatter<T> chronoFormatter2 = StyleProcessor.createFormatter(chronoFormatter.getChronology(), this.dateStyle, this.timeStyle, locale, (Boolean)attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, (Object)Boolean.FALSE), tZID == null ? null : Timezone.of((TZID)tZID).with(transitionStrategy));
        return new StyleProcessor<T>(chronoFormatter2, this.dateStyle, this.timeStyle);
    }

    DisplayStyle getDateStyle() {
        return this.dateStyle;
    }

    private ChronoFormatter<T> getFormatter(AttributeQuery attributeQuery, boolean bl) {
        ChronoFormatter<T> chronoFormatter;
        if (bl) {
            chronoFormatter = this.formatter;
        } else {
            AttributeQuery attributeQuery2 = this.formatter.getAttributes();
            TransitionStrategy transitionStrategy = (TransitionStrategy)attributeQuery.get(Attributes.TRANSITION_STRATEGY, attributeQuery2.get(Attributes.TRANSITION_STRATEGY, (Object)Timezone.DEFAULT_CONFLICT_STRATEGY));
            TZID tZID = (TZID)attributeQuery.get(Attributes.TIMEZONE_ID, attributeQuery2.get(Attributes.TIMEZONE_ID, null));
            Timezone timezone = tZID == null ? null : Timezone.of((TZID)tZID).with(transitionStrategy);
            chronoFormatter = StyleProcessor.createFormatter(this.formatter.getChronology(), this.dateStyle, this.timeStyle, (Locale)attributeQuery.get(Attributes.LANGUAGE, (Object)this.formatter.getLocale()), (Boolean)attributeQuery.get(Attributes.FOUR_DIGIT_YEAR, (Object)Boolean.FALSE), timezone);
        }
        return chronoFormatter;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <T> ChronoFormatter<T> createFormatter(Chronology<?> chronology, DisplayStyle displayStyle, DisplayStyle displayStyle2, Locale locale, boolean bl, Timezone timezone) {
        Chronology chronology2;
        String string;
        if (chronology.equals((Object)PlainDate.axis())) {
            string = CalendarText.patternForDate((DisplayMode)((DisplayMode)displayStyle), (Locale)locale);
        } else if (chronology.equals((Object)PlainTime.axis())) {
            string = CalendarText.patternForTime((DisplayMode)((DisplayMode)displayStyle2), (Locale)locale);
        } else if (chronology.equals((Object)PlainTimestamp.axis())) {
            string = CalendarText.patternForTimestamp((DisplayMode)((DisplayMode)displayStyle), (DisplayMode)((DisplayMode)displayStyle2), (Locale)locale);
        } else if (chronology.equals((Object)Moment.axis())) {
            string = CalendarText.patternForMoment((DisplayMode)((DisplayMode)displayStyle), (DisplayMode)((DisplayMode)displayStyle2), (Locale)locale);
        } else if (chronology.getChronoType() == CalendarDate.class) {
            chronology2 = chronology;
            while (chronology2 instanceof BridgeChronology) {
                chronology2 = chronology2.preparser();
            }
            if (!LocalizedPatternSupport.class.isAssignableFrom(chronology2.getChronoType())) throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
            assert (displayStyle == displayStyle2);
            string = chronology2.getFormatPattern(displayStyle, locale);
        } else {
            if (!LocalizedPatternSupport.class.isAssignableFrom(chronology.getChronoType())) throw new UnsupportedOperationException("Localized format patterns not available: " + chronology);
            assert (displayStyle == displayStyle2);
            string = chronology.getFormatPattern(displayStyle, locale);
        }
        if (bl && string.contains("yy") && !string.contains("yyy")) {
            string = string.replace("yy", "yyyy");
        }
        if (chronology.getChronoType() == CalendarDate.class) {
            return ChronoFormatter.ofGenericCalendarPattern(string, locale);
        }
        chronology2 = ChronoFormatter.ofPattern(string, PatternType.CLDR, locale, chronology);
        if (timezone == null) return chronology2;
        return chronology2.with(timezone);
    }
}

