/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralProvider;
import net.time4j.format.PluralRules;
import net.time4j.format.internal.FormatUtils;

public final class PluralProviderSPI
implements PluralProvider {
    private static final Map<String, PluralRules> CARDINAL_MAP = new HashMap<String, PluralRules>(140);
    private static final PluralRules STD_CARDINALS = new StdCardinalRules(0);
    private static final Map<String, PluralRules> ORDINAL_MAP;
    private static final PluralRules STD_ORDINALS;

    public PluralRules load(Locale locale, NumberType numberType) {
        PluralRules pluralRules;
        Map<String, PluralRules> map;
        switch (numberType) {
            case CARDINALS: {
                map = CARDINAL_MAP;
                pluralRules = STD_CARDINALS;
                break;
            }
            case ORDINALS: {
                map = ORDINAL_MAP;
                pluralRules = STD_ORDINALS;
                break;
            }
            default: {
                throw new UnsupportedOperationException(numberType.name());
            }
        }
        PluralRules pluralRules2 = null;
        String string = FormatUtils.getRegion((Locale)locale);
        if (!string.isEmpty()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(locale.getLanguage());
            stringBuilder.append('_');
            stringBuilder.append(string);
            pluralRules2 = map.get(stringBuilder.toString());
        }
        if (pluralRules2 == null) {
            pluralRules2 = map.get(locale.getLanguage());
        }
        if (pluralRules2 == null) {
            return pluralRules;
        }
        return pluralRules2;
    }

    private static void fillC(Map<String, PluralRules> map, String string, int n) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdCardinalRules(n));
        }
    }

    private static void fillO(Map<String, PluralRules> map, String string, int n) {
        for (String string2 : string.split(" ")) {
            map.put(string2, new StdOrdinalRules(n));
        }
    }

    static {
        HashMap<String, Object> hashMap = new HashMap<String, PluralRules>();
        PluralProviderSPI.fillC(hashMap, "bm bo dz id ig ii in ja jbo jv jw kde kea km ko lkt", -1);
        PluralProviderSPI.fillC(hashMap, "lo ms my nqo root sah ses sg th to vi wo yo zh", -1);
        PluralProviderSPI.fillC(hashMap, "pt_PT", 0);
        PluralProviderSPI.fillC(hashMap, "am as bn fa gu hi kn mr zu", 1);
        PluralProviderSPI.fillC(hashMap, "ff fr hy kab pt", 1);
        PluralProviderSPI.fillC(hashMap, "si", 1);
        PluralProviderSPI.fillC(hashMap, "ak bh guw ln mg nso pa ti wa", 1);
        PluralProviderSPI.fillC(hashMap, "tzm", 2);
        PluralProviderSPI.fillC(hashMap, "is", 3);
        PluralProviderSPI.fillC(hashMap, "mk", 4);
        PluralProviderSPI.fillC(hashMap, "fil tl", 5);
        PluralProviderSPI.fillC(hashMap, "lv prg", 6);
        PluralProviderSPI.fillC(hashMap, "lag ksh", 7);
        PluralProviderSPI.fillC(hashMap, "iu kw naq se sma smi smj smn sms", 8);
        PluralProviderSPI.fillC(hashMap, "shi", 9);
        PluralProviderSPI.fillC(hashMap, "mo ro", 10);
        PluralProviderSPI.fillC(hashMap, "bs hr sh sr", 11);
        PluralProviderSPI.fillC(hashMap, "gd", 12);
        PluralProviderSPI.fillC(hashMap, "sl", 13);
        PluralProviderSPI.fillC(hashMap, "he iw", 14);
        PluralProviderSPI.fillC(hashMap, "cs sk", 15);
        PluralProviderSPI.fillC(hashMap, "pl", 16);
        PluralProviderSPI.fillC(hashMap, "be", 17);
        PluralProviderSPI.fillC(hashMap, "lt", 18);
        PluralProviderSPI.fillC(hashMap, "mt", 19);
        PluralProviderSPI.fillC(hashMap, "ru uk", 17);
        PluralProviderSPI.fillC(hashMap, "br", 20);
        PluralProviderSPI.fillC(hashMap, "ga", 21);
        PluralProviderSPI.fillC(hashMap, "gv", 22);
        PluralProviderSPI.fillC(hashMap, "ar", 23);
        PluralProviderSPI.fillC(hashMap, "cy", 24);
        PluralProviderSPI.fillC(hashMap, "dsb hsb", 25);
        CARDINAL_MAP.putAll(hashMap);
        ORDINAL_MAP = new HashMap<String, PluralRules>(140);
        STD_ORDINALS = new StdOrdinalRules(0);
        hashMap = new HashMap();
        PluralProviderSPI.fillO(hashMap, "sv", 1);
        PluralProviderSPI.fillO(hashMap, "fil fr ga hy lo mo ms ro tl vi", 2);
        PluralProviderSPI.fillO(hashMap, "hu", 3);
        PluralProviderSPI.fillO(hashMap, "ne", 4);
        PluralProviderSPI.fillO(hashMap, "kk", 5);
        PluralProviderSPI.fillO(hashMap, "it", 6);
        PluralProviderSPI.fillO(hashMap, "ka", 7);
        PluralProviderSPI.fillO(hashMap, "sq", 8);
        PluralProviderSPI.fillO(hashMap, "en", 9);
        PluralProviderSPI.fillO(hashMap, "mr", 10);
        PluralProviderSPI.fillO(hashMap, "ca", 11);
        PluralProviderSPI.fillO(hashMap, "mk", 12);
        PluralProviderSPI.fillO(hashMap, "az", 13);
        PluralProviderSPI.fillO(hashMap, "gu hi", 14);
        PluralProviderSPI.fillO(hashMap, "as bn", 15);
        PluralProviderSPI.fillO(hashMap, "cy", 16);
        PluralProviderSPI.fillO(hashMap, "be", 17);
        PluralProviderSPI.fillO(hashMap, "uk", 18);
        PluralProviderSPI.fillO(hashMap, "tk", 19);
        PluralProviderSPI.fillO(hashMap, "or", 20);
        ORDINAL_MAP.putAll(hashMap);
    }

    private static class StdOrdinalRules
    extends PluralRules {
        private final int id;

        private StdOrdinalRules(int n) {
            this.id = n;
        }

        public PluralCategory getCategory(long l) {
            switch (this.id) {
                case 0: {
                    return PluralCategory.OTHER;
                }
                case 1: {
                    long l2 = l % 10L;
                    long l3 = l % 100L;
                    if ((l2 == 1L || l2 == 2L) && l3 != 11L && l3 != 12L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 2: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l == 1L || l == 5L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    if (l >= 1L || l <= 4L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 5: {
                    long l4 = l % 10L;
                    if (l4 == 6L || l4 == 9L || l4 == 0L && l != 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 6: {
                    if (l == 8L || l == 11L || l == 80L || l == 800L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    long l5 = l % 100L;
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 0L || l5 >= 2L && l5 <= 20L || l5 == 40L || l5 == 60L || l5 == 80L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l % 10L == 4L && l % 100L != 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    long l6 = l % 10L;
                    long l7 = l % 100L;
                    if (l6 == 1L && l7 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l6 == 2L && l7 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l6 == 3L && l7 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    if (l == 1L || l == 3L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    long l8 = l % 10L;
                    long l9 = l % 100L;
                    if (l8 == 1L && l9 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l8 == 2L && l9 != 12L) {
                        return PluralCategory.TWO;
                    }
                    if ((l8 == 7L || l8 == 8L) && l9 != 17L && l9 != 18L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    long l10 = l % 10L;
                    long l11 = l % 100L;
                    long l12 = l % 1000L;
                    if (l10 == 1L || l10 == 2L || l10 == 5L || l10 == 7L || l10 == 8L || l11 == 20L || l11 == 50L || l11 == 70L || l11 == 80L) {
                        return PluralCategory.ONE;
                    }
                    if (l10 == 3L || l10 == 4L || l12 == 100L || l12 == 200L || l12 == 300L || l12 == 400L || l12 == 500L || l12 == 600L || l12 == 700L || l12 == 800L || l12 == 900L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 0L || l10 == 6L || l11 == 40L || l11 == 60L || l11 == 90L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l == 1L || l == 5L || l >= 7L && l <= 10L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l == 0L || l >= 7L && l <= 9L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 3L || l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 5L || l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 17: {
                    long l13 = l % 10L;
                    long l14 = l % 100L;
                    if ((l13 == 2L || l13 == 3L) && l14 != 12L && l14 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 18: {
                    long l15 = l % 10L;
                    long l16 = l % 100L;
                    if (l15 == 3L && l16 != 13L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 19: {
                    long l17 = l % 10L;
                    if (l17 == 6L || l17 == 9L || l == 10L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 20: {
                    if (l == 1L || l == 5L || l == 7L || l == 8L || l == 9L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 3L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 4L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        public NumberType getNumberType() {
            return NumberType.ORDINALS;
        }
    }

    private static class StdCardinalRules
    extends PluralRules {
        private final int id;

        private StdCardinalRules(int n) {
            this.id = n;
        }

        public PluralCategory getCategory(long l) {
            switch (this.id) {
                case 0: {
                    return l == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 1: {
                    return l == 0L || l == 1L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 2: {
                    if (l == 0L || l == 1L || l >= 11L && l <= 99L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 3: {
                    if (l % 10L == 1L && l % 100L != 11L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 4: {
                    return l % 10L == 1L && l % 100L != 11L ? PluralCategory.ONE : PluralCategory.OTHER;
                }
                case 5: {
                    if (l >= 1L && l <= 3L) {
                        return PluralCategory.ONE;
                    }
                    long l2 = l % 10L;
                    if (l2 == 4L || l2 == 6L || l2 == 9L) {
                        return PluralCategory.OTHER;
                    }
                    return PluralCategory.ONE;
                }
                case 6: {
                    if (l % 10L == 0L) {
                        return PluralCategory.ZERO;
                    }
                    long l3 = l % 100L;
                    if (l3 >= 11L && l3 <= 19L) {
                        return PluralCategory.ZERO;
                    }
                    if (l % 10L == 1L && l3 != 11L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 7: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    return PluralCategory.OTHER;
                }
                case 8: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    return PluralCategory.OTHER;
                }
                case 9: {
                    if (l == 0L || l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l >= 2L && l <= 10L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 10: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 0L) {
                        return PluralCategory.FEW;
                    }
                    long l4 = l % 100L;
                    if (l4 >= 1L && l4 <= 19L && l != 1L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 11: {
                    long l5 = l % 100L;
                    if (l % 10L == 1L && l5 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l % 10L >= 2L && l % 10L <= 4L && l5 != 12L && l5 != 13L && l5 != 14L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 12: {
                    if (l == 1L || l == 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L || l == 12L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 3L && l <= 10L || l >= 13L && l <= 19L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 13: {
                    long l6 = l % 100L;
                    if (l6 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l6 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l6 == 3L || l6 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 14: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 11L && l % 10L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 15: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l >= 2L && l <= 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 16: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    long l7 = l % 10L;
                    long l8 = l % 100L;
                    if (l7 >= 2L && l7 <= 4L && l8 != 12L && l8 != 13L && l8 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l != 1L && l7 >= 0L && l7 <= 1L || l7 >= 5L && l7 <= 9L || l8 >= 12L && l8 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 17: {
                    long l9 = l % 10L;
                    long l10 = l % 100L;
                    if (l9 == 1L && l10 != 11L) {
                        return PluralCategory.ONE;
                    }
                    if (l9 >= 2L && l9 <= 4L && l10 != 12L && l10 != 13L && l10 != 14L) {
                        return PluralCategory.FEW;
                    }
                    if (l9 == 0L || l9 >= 5L && l9 <= 9L || l10 >= 11L && l10 <= 14L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 18: {
                    long l11 = l % 10L;
                    long l12 = l % 100L;
                    if (l11 == 1L && (l12 < 11L || l12 > 19L)) {
                        return PluralCategory.ONE;
                    }
                    if (l11 >= 2L && l11 <= 9L && (l12 < 11L || l12 > 19L)) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 19: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    long l13 = l % 100L;
                    if (l == 0L || l13 >= 2L && l13 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l13 >= 11L && l13 <= 19L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 20: {
                    long l14 = l % 10L;
                    long l15 = l % 100L;
                    if (l14 == 1L && l15 != 11L && l15 != 71L && l15 != 91L) {
                        return PluralCategory.ONE;
                    }
                    if (l14 == 2L && l15 != 12L && l15 != 72L && l15 != 92L) {
                        return PluralCategory.TWO;
                    }
                    if (!(l14 != 3L && l14 != 4L && l14 != 9L || l15 >= 10L && l15 <= 19L || l15 >= 70L && l15 <= 79L || l15 >= 90L && l15 <= 99L)) {
                        return PluralCategory.FEW;
                    }
                    if (l != 0L && l % 1000000L == 0L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 21: {
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l >= 3L && l <= 6L) {
                        return PluralCategory.FEW;
                    }
                    if (l >= 7L && l <= 10L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 22: {
                    long l16 = l % 10L;
                    long l17 = l % 100L;
                    if (l16 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l16 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l17 == 0L || l17 == 20L || l17 == 40L || l17 == 60L || l17 == 80L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
                case 23: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    long l18 = l % 100L;
                    if (l18 >= 3L && l18 <= 10L) {
                        return PluralCategory.FEW;
                    }
                    if (l18 >= 11L && l18 <= 99L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 24: {
                    if (l == 0L) {
                        return PluralCategory.ZERO;
                    }
                    if (l == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l == 3L) {
                        return PluralCategory.FEW;
                    }
                    if (l == 6L) {
                        return PluralCategory.MANY;
                    }
                    return PluralCategory.OTHER;
                }
                case 25: {
                    long l19 = l % 100L;
                    if (l19 == 1L) {
                        return PluralCategory.ONE;
                    }
                    if (l19 == 2L) {
                        return PluralCategory.TWO;
                    }
                    if (l19 == 3L || l19 == 4L) {
                        return PluralCategory.FEW;
                    }
                    return PluralCategory.OTHER;
                }
            }
            return PluralCategory.OTHER;
        }

        public NumberType getNumberType() {
            return NumberType.CARDINALS;
        }
    }
}

