/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import net.time4j.base.ResourceLoader;
import net.time4j.format.internal.FormatUtils;
import net.time4j.i18n.LanguageMatch;
import net.time4j.i18n.UTF8ResourceBundle;
import net.time4j.i18n.UTF8ResourceReader;

public class UTF8ResourceControl
extends ResourceBundle.Control {
    private static final String FORMAT_ID = "time4j.properties";
    public static final ResourceBundle.Control SINGLETON = new UTF8ResourceControl();

    protected UTF8ResourceControl() {
    }

    @Override
    public Locale getFallbackLocale(String string, Locale locale) {
        if (string == null || locale == null) {
            throw new NullPointerException();
        }
        return null;
    }

    @Override
    public List<String> getFormats(String string) {
        return Collections.singletonList(FORMAT_ID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
        if (string2.equals(FORMAT_ID)) {
            UTF8ResourceBundle uTF8ResourceBundle = null;
            String string3 = this.toBundleName(string, locale);
            String string4 = this.toResourceName(string3, "properties");
            URI uRI = ResourceLoader.getInstance().locate(this.getModuleName(), this.getModuleRef(), string4);
            InputStream inputStream = ResourceLoader.getInstance().load(uRI, bl);
            if (inputStream == null) {
                try {
                    inputStream = ResourceLoader.getInstance().load(this.getModuleRef(), string4, bl);
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            if (inputStream != null) {
                try (UTF8ResourceReader uTF8ResourceReader = null;){
                    uTF8ResourceReader = new UTF8ResourceReader(inputStream);
                    uTF8ResourceBundle = new UTF8ResourceBundle(uTF8ResourceReader, locale);
                }
            }
            return uTF8ResourceBundle;
        }
        throw new UnsupportedOperationException("Unknown resource bundle format: " + string2);
    }

    @Override
    public String toBundleName(String string, Locale locale) {
        if (locale == Locale.ROOT) {
            return string;
        }
        String string2 = LanguageMatch.getAlias(locale);
        String string3 = FormatUtils.getRegion((Locale)locale);
        String string4 = locale.getVariant();
        if (string2.isEmpty() && string3.isEmpty() && string4.isEmpty()) {
            return string;
        }
        if (string2.equals("zh") && locale.getScript().equals("Hant")) {
            string3 = "TW";
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_').append(string2);
        if (!string4.isEmpty()) {
            stringBuilder.append('_').append(string3).append('_').append(string4);
        } else if (!string3.isEmpty()) {
            stringBuilder.append('_').append(string3);
        }
        return stringBuilder.toString();
    }

    protected String getModuleName() {
        return "i18n";
    }

    protected Class<?> getModuleRef() {
        return UTF8ResourceControl.class;
    }
}

