/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.FormatProcessor;
import net.time4j.format.expert.FormatStep;
import net.time4j.format.expert.LocalizedGMTProcessor;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.TimezoneElement;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneNameProcessor
implements FormatProcessor<TZID> {
    private static final ConcurrentMap<Locale, TZNames> CACHE_ABBREVIATIONS = new ConcurrentHashMap<Locale, TZNames>();
    private static final ConcurrentMap<Locale, TZNames> CACHE_ZONENAMES = new ConcurrentHashMap<Locale, TZNames>();
    private static final int MAX = 25;
    private static final String DEFAULT_PROVIDER = "DEFAULT";
    private final boolean abbreviated;
    private final FormatProcessor<TZID> fallback;
    private final Set<TZID> preferredZones;

    TimezoneNameProcessor(boolean bl) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = null;
    }

    TimezoneNameProcessor(boolean bl, Set<TZID> set) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = Collections.unmodifiableSet(new LinkedHashSet<TZID>(set));
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone id from: " + chronoDisplay);
        }
        TZID tZID = chronoDisplay.getTimezone();
        if (tZID instanceof ZonalOffset) {
            this.fallback.print(chronoDisplay, appendable, attributeQuery, set, formatStep);
            return;
        }
        if (!(chronoDisplay instanceof UnixTime)) {
            throw new IllegalArgumentException("Cannot extract timezone name from: " + chronoDisplay);
        }
        Timezone timezone = Timezone.of((TZID)tZID);
        UnixTime unixTime = (UnixTime)UnixTime.class.cast(chronoDisplay);
        String string = timezone.getDisplayName(this.getStyle(timezone.isDaylightSaving(unixTime)), formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT));
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        int n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        int n;
        ArrayList<TZID> arrayList;
        List<TZID> list;
        List<TZID> list2;
        Object object;
        char c;
        int n2 = charSequence.length();
        int n3 = parseLog.getPosition();
        int n4 = n3;
        if (n4 >= n2) {
            parseLog.setError(n3, "Missing timezone name.");
            return;
        }
        Locale locale = formatStep.getAttribute(Attributes.LANGUAGE, attributeQuery, Locale.ROOT);
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        StringBuilder stringBuilder = new StringBuilder();
        while (n4 < n2 && (Character.isLetter(c = charSequence.charAt(n4)) || !this.abbreviated && n4 > n3 && !Character.isDigit(c))) {
            stringBuilder.append(c);
            ++n4;
        }
        String string = stringBuilder.toString().trim();
        n4 = n3 + string.length();
        if (string.startsWith("GMT") || string.startsWith("UT")) {
            this.fallback.parse(charSequence, parseLog, attributeQuery, map, formatStep);
            return;
        }
        ConcurrentMap<Locale, TZNames> concurrentMap = this.abbreviated ? CACHE_ABBREVIATIONS : CACHE_ZONENAMES;
        Object object2 = (TZNames)concurrentMap.get(locale);
        if (object2 == null) {
            object = this.getTimezoneNameMap(locale, false);
            list2 = this.getTimezoneNameMap(locale, true);
            object2 = new TZNames((Map<String, List<TZID>>)object, (Map<String, List<TZID>>)((Object)list2));
            if (concurrentMap.size() < 25 && (list = concurrentMap.putIfAbsent(locale, (TZNames)object2)) != null) {
                object2 = list;
            }
        }
        object = new int[]{n4, n4};
        list2 = TimezoneNameProcessor.readZones((TZNames)object2, string, false, object);
        list = TimezoneNameProcessor.readZones((TZNames)object2, string, true, object);
        int n5 = list2.size() + list.size();
        if (n5 == 0) {
            parseLog.setError(n3, "Unknown timezone name: " + string);
            return;
        }
        if (n5 > 1 && !leniency.isLax()) {
            if (list2.size() > 0) {
                list2 = this.resolve(list2, locale, leniency);
            }
            if (list.size() > 0) {
                list = this.resolve(list, locale, leniency);
            }
        }
        if ((n5 = list2.size() + list.size()) == 0) {
            parseLog.setError(n3, "Time zone id not found among preferred timezones in locale " + locale);
            return;
        }
        if (list2.size() > 0) {
            arrayList = list2;
            n = 0;
            if (n5 == 2 && list.size() > 0 && list2.get(0).canonical().equals(list.get(0).canonical())) {
                list.remove(0);
                --n5;
            } else if (!list.isEmpty()) {
                arrayList = new ArrayList<TZID>(arrayList);
                arrayList.addAll(list);
            }
        } else {
            arrayList = list;
            n = 1;
        }
        if (n5 > 1) {
            ArrayList<TZID> arrayList2 = null;
            for (TZID tZID : arrayList) {
                if (tZID.canonical().indexOf(126) != -1) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<TZID>();
                }
                arrayList2.add(tZID);
            }
            if (arrayList2 != null) {
                arrayList = arrayList2;
                n5 = arrayList.size();
            }
        }
        if (n5 == 1 || leniency.isLax()) {
            map.put(TimezoneElement.TIMEZONE_ID, arrayList.get(0));
            parseLog.setPosition(object[n]);
            if (((TZNames)object2).isDaylightSensitive()) {
                parseLog.setDaylightSaving(n == 1);
            }
        } else {
            parseLog.setError(n3, "Time zone name is not unique: \"" + string + "\" in " + TimezoneNameProcessor.toString(arrayList));
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private Map<String, List<TZID>> getTimezoneNameMap(Locale locale, boolean bl) {
        HashMap<String, ArrayList<TZID>> hashMap = new HashMap<String, ArrayList<TZID>>();
        for (TZID tZID : Timezone.getAvailableIDs()) {
            Timezone timezone = Timezone.of((TZID)tZID);
            String string = timezone.getDisplayName(this.getStyle(bl), locale);
            if (string.equals(tZID.canonical())) continue;
            ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<TZID>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(tZID);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private static List<TZID> readZones(TZNames tZNames, String string, boolean bl, int[] nArray) {
        int n;
        List<TZID> list = tZNames.search(string, bl);
        if (list.isEmpty() && !Character.isLetter(string.charAt(n = string.length() - 1)) && !(list = tZNames.search(string.substring(0, n), bl)).isEmpty()) {
            int n2;
            int n3 = n2 = bl ? 1 : 0;
            nArray[n3] = nArray[n3] - 1;
        }
        return list;
    }

    private List<TZID> resolve(List<TZID> object, Locale locale, Leniency leniency) {
        HashMap hashMap = new HashMap();
        hashMap.put(DEFAULT_PROVIDER, new ArrayList());
        Object object2 = object.iterator();
        block0: while (object2.hasNext()) {
            TZID tZID = object2.next();
            String string = tZID.canonical();
            Object object3 = this.preferredZones;
            String string2 = DEFAULT_PROVIDER;
            int n = string.indexOf(126);
            if (n >= 0) {
                string2 = string.substring(0, n);
            }
            if (object3 == null) {
                object3 = Timezone.getPreferredIDs((Locale)locale, (boolean)leniency.isSmart(), (String)string2);
            }
            Iterator<TZID> iterator = object3.iterator();
            while (iterator.hasNext()) {
                TZID tZID2 = iterator.next();
                if (!tZID2.canonical().equals(string)) continue;
                ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string2);
                if (arrayList == null) {
                    arrayList = new ArrayList<TZID>();
                    hashMap.put(string2, arrayList);
                }
                arrayList.add(tZID2);
                continue block0;
            }
        }
        object2 = (List)hashMap.get(DEFAULT_PROVIDER);
        if (object2.isEmpty()) {
            hashMap.remove(DEFAULT_PROVIDER);
            boolean bl = false;
            for (Object object3 : hashMap.keySet()) {
                object2 = (List)hashMap.get(object3);
                if (object2.isEmpty()) continue;
                bl = true;
                object = object2;
                break;
            }
            if (!bl) {
                object = Collections.emptyList();
            }
        } else {
            object = object2;
        }
        return object;
    }

    private NameStyle getStyle(boolean bl) {
        if (bl) {
            return this.abbreviated ? NameStyle.SHORT_DAYLIGHT_TIME : NameStyle.LONG_DAYLIGHT_TIME;
        }
        return this.abbreviated ? NameStyle.SHORT_STANDARD_TIME : NameStyle.LONG_STANDARD_TIME;
    }

    private static String toString(List<TZID> list) {
        StringBuilder stringBuilder = new StringBuilder(list.size() * 16);
        stringBuilder.append('{');
        boolean bl = true;
        for (TZID tZID : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(tZID.canonical());
        }
        return stringBuilder.append('}').toString();
    }

    private static class TZNames {
        private final boolean dstSensitive;
        private final Map<String, List<TZID>> stdNames;
        private final Map<String, List<TZID>> dstNames;

        TZNames(Map<String, List<TZID>> map, Map<String, List<TZID>> map2) {
            this.stdNames = map;
            this.dstNames = map2;
            this.dstSensitive = !map.keySet().equals(map2.keySet());
        }

        boolean isDaylightSensitive() {
            return this.dstSensitive;
        }

        List<TZID> search(String string, boolean bl) {
            Map<String, List<TZID>> map;
            Map<String, List<TZID>> map2 = map = bl ? this.dstNames : this.stdNames;
            if (map.containsKey(string)) {
                return map.get(string);
            }
            return Collections.emptyList();
        }
    }
}

