/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format.expert;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

final class AttributeSet
implements AttributeQuery {
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    private static final char ISO_DECIMAL_SEPARATOR;
    private static final ConcurrentMap<Locale, NumericalSymbols> NUMBER_SYMBOL_CACHE;
    private static final NumericalSymbols DEFAULT_NUMERICAL_SYMBOLS;
    private final Map<String, Object> internals;
    private final Attributes attributes;
    private final Locale locale;
    private final int level;
    private final int section;
    private final ChronoCondition<ChronoDisplay> printCondition;

    AttributeSet(Attributes attributes, Locale locale) {
        this(attributes, locale, 0, 0, null);
    }

    AttributeSet(Attributes attributes, Locale locale, int n, int n2, ChronoCondition<ChronoDisplay> chronoCondition) {
        if (attributes == null) {
            throw new NullPointerException("Missing format attributes.");
        }
        this.attributes = attributes;
        this.locale = locale == null ? Locale.ROOT : locale;
        this.level = n;
        this.section = n2;
        this.printCondition = chronoCondition;
        this.internals = Collections.emptyMap();
    }

    private AttributeSet(Attributes attributes, Locale locale, int n, int n2, ChronoCondition<ChronoDisplay> chronoCondition, Map<String, Object> map) {
        if (attributes == null) {
            throw new NullPointerException("Missing format attributes.");
        }
        this.attributes = attributes;
        this.locale = locale == null ? Locale.ROOT : locale;
        this.level = n;
        this.section = n2;
        this.printCondition = chronoCondition;
        this.internals = Collections.unmodifiableMap(map);
    }

    public boolean contains(AttributeKey<?> attributeKey) {
        if (this.internals.containsKey(attributeKey.name())) {
            return true;
        }
        return this.attributes.contains(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey) {
        if (this.internals.containsKey(attributeKey.name())) {
            return (A)attributeKey.type().cast(this.internals.get(attributeKey.name()));
        }
        return (A)this.attributes.get(attributeKey);
    }

    public <A> A get(AttributeKey<A> attributeKey, A a) {
        if (this.internals.containsKey(attributeKey.name())) {
            return (A)attributeKey.type().cast(this.internals.get(attributeKey.name()));
        }
        return (A)this.attributes.get(attributeKey, a);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof AttributeSet) {
            AttributeSet attributeSet = (AttributeSet)object;
            return this.attributes.equals((Object)attributeSet.attributes) && this.locale.equals(attributeSet.locale) && this.level == attributeSet.level && this.section == attributeSet.section && AttributeSet.isEqual(this.printCondition, attributeSet.printCondition) && this.internals.equals(attributeSet.internals);
        }
        return false;
    }

    public int hashCode() {
        return 7 * this.attributes.hashCode() + 37 * this.internals.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[attributes=");
        stringBuilder.append(this.attributes);
        stringBuilder.append(",locale=");
        stringBuilder.append(this.locale);
        stringBuilder.append(",level=");
        stringBuilder.append(this.level);
        stringBuilder.append(",section=");
        stringBuilder.append(this.section);
        stringBuilder.append(",print-condition=");
        stringBuilder.append(this.printCondition);
        stringBuilder.append(",other=");
        stringBuilder.append(this.internals);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Attributes getAttributes() {
        return this.attributes;
    }

    Locale getLocale() {
        return this.locale;
    }

    int getLevel() {
        return this.level;
    }

    int getSection() {
        return this.section;
    }

    ChronoCondition<ChronoDisplay> getCondition() {
        return this.printCondition;
    }

    static AttributeSet createDefaults(Chronology<?> chronology, Locale locale) {
        Attributes.Builder builder = new Attributes.Builder(chronology);
        builder.set(Attributes.LENIENCY, (Enum)Leniency.SMART);
        builder.set(Attributes.TEXT_WIDTH, (Enum)TextWidth.WIDE);
        builder.set(Attributes.OUTPUT_CONTEXT, (Enum)OutputContext.FORMAT);
        builder.set(Attributes.PAD_CHAR, ' ');
        AttributeSet attributeSet = new AttributeSet(builder.build(), locale);
        return attributeSet.withLocale(locale);
    }

    AttributeSet withAttributes(Attributes attributes) {
        return new AttributeSet(attributes, this.locale, this.level, this.section, this.printCondition, this.internals);
    }

    <A> AttributeSet withInternal(AttributeKey<A> attributeKey, A a) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.internals);
        if (a == null) {
            hashMap.remove(attributeKey.name());
        } else {
            hashMap.put(attributeKey.name(), a);
        }
        return new AttributeSet(this.attributes, this.locale, this.level, this.section, this.printCondition, hashMap);
    }

    AttributeSet withLocale(Locale locale) {
        Attributes.Builder builder = new Attributes.Builder();
        builder.setAll(this.attributes);
        if (locale.getLanguage().isEmpty() && locale.getCountry().isEmpty()) {
            locale = Locale.ROOT;
            builder.set(Attributes.ZERO_DIGIT, '0');
            builder.set(Attributes.DECIMAL_SEPARATOR, ISO_DECIMAL_SEPARATOR);
        } else {
            Object object = NUMBER_SYMBOL_CACHE.get(locale);
            if (object == null) {
                object = DEFAULT_NUMERICAL_SYMBOLS;
                Object object2 = NUMBER_SYMBOLS.getAvailableLocales();
                int n = ((Locale[])object2).length;
                for (int i = 0; i < n; ++i) {
                    Locale locale2 = object2[i];
                    if (!locale.equals(locale2)) continue;
                    object = new NumericalSymbols(NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getDecimalSeparator(locale));
                    break;
                }
                if ((object2 = NUMBER_SYMBOL_CACHE.putIfAbsent(locale, (NumericalSymbols)object)) != null) {
                    object = object2;
                }
            }
            builder.set(Attributes.ZERO_DIGIT, ((NumericalSymbols)object).zeroDigit);
            builder.set(Attributes.DECIMAL_SEPARATOR, ((NumericalSymbols)object).decimalSeparator);
        }
        builder.setLanguage(locale);
        return new AttributeSet(builder.build(), locale, this.level, this.section, this.printCondition, this.internals);
    }

    private static boolean isEqual(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    static {
        NumberSymbolProvider numberSymbolProvider = null;
        Iterator iterator = ResourceLoader.getInstance().services(NumberSymbolProvider.class).iterator();
        if (iterator.hasNext()) {
            NumberSymbolProvider numberSymbolProvider2;
            numberSymbolProvider = numberSymbolProvider2 = (NumberSymbolProvider)iterator.next();
        }
        if (numberSymbolProvider == null) {
            numberSymbolProvider = NumberSymbolProvider.DEFAULT;
        }
        NUMBER_SYMBOLS = numberSymbolProvider;
        ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
        NUMBER_SYMBOL_CACHE = new ConcurrentHashMap<Locale, NumericalSymbols>();
        DEFAULT_NUMERICAL_SYMBOLS = new NumericalSymbols('0', ISO_DECIMAL_SEPARATOR);
    }

    private static class NumericalSymbols {
        private final char zeroDigit;
        private final char decimalSeparator;

        NumericalSymbols(char c, char c2) {
            this.zeroDigit = c;
            this.decimalSeparator = c2;
        }
    }
}

