/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.CalendarFooter;
import net.time4j.ui.javafx.CalendarView;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.NavigationBar;

class CalendarContent<T extends CalendarDate>
extends BorderPane {
    private static final String CSS_CALENDAR = "calendar";
    private static final String CSS_CALENDAR_HEADER = "calendar-header";
    private static final String CSS_CALENDAR_NAVIGATION_INFO = "calendar-navigation-info";
    private VBox header;

    CalendarContent(CalendarControl<T> calendarControl, FXCalendarSystem<T> fXCalendarSystem) {
        this.setEffect((Effect)new DropShadow());
        this.getStyleClass().add((Object)CSS_CALENDAR);
        this.setMaxWidth(Double.NEGATIVE_INFINITY);
        NavigationBar<T> navigationBar = new NavigationBar<T>(calendarControl, fXCalendarSystem);
        this.header = CalendarContent.createHeader(calendarControl, navigationBar);
        CalendarView<T> calendarView = new CalendarView<T>(calendarControl, fXCalendarSystem, navigationBar.getTitleButton());
        this.setTop((Node)this.header);
        this.setCenter((Node)calendarView);
        this.setBottom((Node)new CalendarFooter<T>(calendarControl));
        calendarControl.showInfoLabelProperty().addListener((observableValue, bl, bl2) -> {
            boolean bl3;
            boolean bl4 = bl3 = this.header.getChildren().size() == 2;
            if (bl2 != bl3) {
                if (bl2.booleanValue()) {
                    this.header.getChildren().add((Object)CalendarContent.createLabel(calendarControl));
                } else {
                    this.header.getChildren().remove(1);
                }
            }
        });
    }

    private static VBox createHeader(CalendarControl<?> calendarControl, NavigationBar<?> navigationBar) {
        VBox vBox = new VBox();
        vBox.getStyleClass().add((Object)CSS_CALENDAR_HEADER);
        vBox.getChildren().add(navigationBar);
        if (calendarControl.showInfoLabelProperty().get()) {
            vBox.getChildren().add((Object)CalendarContent.createLabel(calendarControl));
        }
        return vBox;
    }

    private static Node createLabel(CalendarControl<?> calendarControl) {
        Label label = new Label();
        label.textProperty().bind((ObservableValue)calendarControl.navigationInfoProperty());
        HBox hBox = new HBox();
        hBox.getChildren().add((Object)label);
        hBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)label, (Priority)Priority.ALWAYS);
        label.getStyleClass().add((Object)CSS_CALENDAR_NAVIGATION_INFO);
        return hBox;
    }
}

