/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import java.util.function.Supplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.util.Duration;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.Chronology;
import net.time4j.ui.javafx.CellCustomizer;

class CalendarControl<T extends CalendarDate> {
    private Supplier<T> todaySupplier;
    private Chronology<T> chronology;
    private ObjectProperty<T> pageDateProperty = new SimpleObjectProperty((Object)this, "PAGE-DATE");
    private ObjectProperty<T> selectedDateProperty = new SimpleObjectProperty((Object)this, "SELECTED-DATE");
    private IntegerProperty ongoingTransitionsProperty = new SimpleIntegerProperty((Object)this, "TRANSITION-COUNT");
    private IntegerProperty viewIndexProperty = new SimpleIntegerProperty((Object)this, "VIEW-INDEX");
    private StringProperty navigationTitleProperty = new SimpleStringProperty((Object)this, "NAVIGATION-TITLE");
    private StringProperty navigationInfoProperty = new SimpleStringProperty((Object)this, "NAVIGATION-INFO");
    private ObjectProperty<T> minDateProperty = new SimpleObjectProperty((Object)this, "MIN-DATE");
    private ObjectProperty<T> maxDateProperty = new SimpleObjectProperty((Object)this, "MAX-DATE");
    private ObjectProperty<Locale> localeProperty = new SimpleObjectProperty((Object)this, "LOCALE");
    private BooleanProperty showWeeksProperty = new SimpleBooleanProperty((Object)this, "SHOW-WEEKS");
    private BooleanProperty showInfoLabelProperty = new SimpleBooleanProperty((Object)this, "SHOW-INFO-LABEL");
    private ObjectProperty<CellCustomizer<T>> cellCustomizerProperty = new SimpleObjectProperty((Object)this, "CELL-CUSTOMIZER");
    private ObjectProperty<Duration> lengthOfAnimationsProperty = new SimpleObjectProperty((Object)this, "LENGTH-OF-ANIMATIONS");

    CalendarControl(Locale locale, Supplier<T> supplier, Chronology<T> chronology, T t, T t2) {
        if (locale == null || supplier == null || chronology == null || t == null || t2 == null) {
            throw new NullPointerException();
        }
        this.todaySupplier = supplier;
        this.chronology = chronology;
        this.selectedDateProperty.setValue(null);
        this.pageDateProperty.setValue(supplier.get());
        this.localeProperty.setValue((Object)locale);
        this.ongoingTransitionsProperty.set(0);
        this.minDateProperty.setValue(t);
        this.maxDateProperty.setValue(t2);
        this.cellCustomizerProperty.setValue(null);
    }

    T today() {
        return (T)((CalendarDate)this.todaySupplier.get());
    }

    Chronology<T> chronology() {
        return this.chronology;
    }

    ObjectProperty<Locale> localeProperty() {
        return this.localeProperty;
    }

    ObjectProperty<T> minDateProperty() {
        return this.minDateProperty;
    }

    ObjectProperty<T> maxDateProperty() {
        return this.maxDateProperty;
    }

    ObjectProperty<T> pageDateProperty() {
        return this.pageDateProperty;
    }

    ObjectProperty<T> selectedDateProperty() {
        return this.selectedDateProperty;
    }

    IntegerProperty ongoingTransitionsProperty() {
        return this.ongoingTransitionsProperty;
    }

    IntegerProperty viewIndexProperty() {
        return this.viewIndexProperty;
    }

    StringProperty navigationTitleProperty() {
        return this.navigationTitleProperty;
    }

    StringProperty navigationInfoProperty() {
        return this.navigationInfoProperty;
    }

    BooleanProperty showWeeksProperty() {
        return this.showWeeksProperty;
    }

    BooleanProperty showInfoLabelProperty() {
        return this.showInfoLabelProperty;
    }

    ObjectProperty<Duration> lengthOfAnimationsProperty() {
        return this.lengthOfAnimationsProperty;
    }

    ObjectProperty<CellCustomizer<T>> cellCustomizerProperty() {
        return this.cellCustomizerProperty;
    }
}

