/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.util.Locale;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.control.Button;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import net.time4j.PrettyTime;
import net.time4j.engine.CalendarDate;
import net.time4j.ui.javafx.CalendarControl;

class CalendarFooter<T extends CalendarDate>
extends HBox {
    private static final String CSS_CALENDAR_FOOTER = "calendar-footer";
    private static final String CSS_CALENDAR_TODAY_BUTTON = "calendar-today-button";
    private CalendarControl<T> control;

    CalendarFooter(CalendarControl<T> calendarControl) {
        this.control = calendarControl;
        this.getStyleClass().add((Object)CSS_CALENDAR_FOOTER);
        Button button = new Button();
        button.textProperty().bind((ObservableValue)new TodayBinding());
        button.getStyleClass().add((Object)CSS_CALENDAR_TODAY_BUTTON);
        button.setTooltip(new Tooltip(calendarControl.today().toString()));
        button.setOnAction(actionEvent -> {
            calendarControl.pageDateProperty().setValue(calendarControl.today());
            calendarControl.viewIndexProperty().setValue((Number)0);
        });
        button.disableProperty().bind((ObservableValue)new DisabledBinding());
        this.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)button);
    }

    private class DisabledBinding
    extends BooleanBinding {
        DisabledBinding() {
            this.bind(new Observable[]{CalendarFooter.this.control.minDateProperty(), CalendarFooter.this.control.maxDateProperty()});
        }

        protected boolean computeValue() {
            Object t = CalendarFooter.this.control.today();
            return t.isBefore(CalendarFooter.this.control.minDateProperty().get()) || t.isAfter(CalendarFooter.this.control.maxDateProperty().get());
        }
    }

    private class TodayBinding
    extends StringBinding {
        TodayBinding() {
            this.bind(new Observable[]{CalendarFooter.this.control.localeProperty()});
        }

        protected String computeValue() {
            Locale locale = (Locale)CalendarFooter.this.control.localeProperty().get();
            if (locale == null) {
                locale = Locale.ROOT;
            }
            return PrettyTime.of((Locale)locale).printToday();
        }
    }
}

