/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.ui.javafx;

import java.time.format.FormatStyle;
import java.util.Collection;
import java.util.Locale;
import java.util.function.Supplier;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.animation.ScaleTransition;
import javafx.beans.Observable;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Duration;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.calendar.CopticCalendar;
import net.time4j.calendar.EthiopianCalendar;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HijriCalendar;
import net.time4j.calendar.JulianCalendar;
import net.time4j.calendar.MinguoCalendar;
import net.time4j.calendar.PersianCalendar;
import net.time4j.calendar.ThaiSolarCalendar;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.CalendarFamily;
import net.time4j.engine.CalendarVariant;
import net.time4j.engine.Calendrical;
import net.time4j.engine.Chronology;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.VariantSource;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.PatternType;
import net.time4j.ui.javafx.CalendarContent;
import net.time4j.ui.javafx.CalendarControl;
import net.time4j.ui.javafx.CellCustomizer;
import net.time4j.ui.javafx.FXCalendarSystem;
import net.time4j.ui.javafx.FXCalendarSystemCoptic;
import net.time4j.ui.javafx.FXCalendarSystemEthiopian;
import net.time4j.ui.javafx.FXCalendarSystemHebrew;
import net.time4j.ui.javafx.FXCalendarSystemHijri;
import net.time4j.ui.javafx.FXCalendarSystemIso8601;
import net.time4j.ui.javafx.FXCalendarSystemJulian;
import net.time4j.ui.javafx.FXCalendarSystemMinguo;
import net.time4j.ui.javafx.FXCalendarSystemPersian;
import net.time4j.ui.javafx.FXCalendarSystemThai;

public class CalendarPicker<T extends CalendarDate>
extends HBox {
    private static final Duration STD_ANIMATION_TIME = Duration.seconds((double)0.5);
    private static final String CSS_CALENDAR_EDITOR_ERROR = "calendar-editor-error";
    private static final String CSS_CALENDAR_DIALOG_START = "calendar-dialog-start";
    private TextField textField;
    private Button popupButton;
    private Popup popupDialog;
    private CalendarControl<T> control;
    private FXCalendarSystem<T> calsys;
    private boolean committingText = false;
    private boolean textInChange = false;
    private boolean valueInChange = false;
    private boolean selectionInChange = false;
    private ObjectProperty<T> valuePropertyInt = new SimpleObjectProperty((Object)this, "VALUE-INTERNAL");
    private ObjectProperty<T> valuePropertyExt = new SimpleObjectProperty((Object)this, "VALUE");
    private StringProperty errorProperty = new SimpleStringProperty((Object)this, "ERROR");
    private ObjectProperty<ChronoFormatter<T>> formatProperty = new SimpleObjectProperty((Object)this, "DATE-FORMAT");
    private StringProperty promptProperty = new SimpleStringProperty((Object)this, "PROMPT-TEXT");

    private CalendarPicker(FXCalendarSystem<T> fXCalendarSystem, Locale locale, Supplier<T> supplier, Chronology<T> chronology, T t, T t2) {
        this.control = new CalendarControl<T>(locale, supplier, chronology, t, t2);
        this.calsys = fXCalendarSystem;
        this.control.selectedDateProperty().setValue(null);
        this.control.pageDateProperty().setValue(supplier.get());
        this.valuePropertyInt.setValue(null);
        this.errorProperty.setValue(null);
        this.formatProperty.setValue(null);
        this.promptProperty.setValue(null);
        this.setShowWeeks(true);
        this.setLengthOfAnimations(STD_ANIMATION_TIME);
        this.getStylesheets().add((Object)"/net/time4j/ui/javafx/calendar.css");
        this.textField = new TextField();
        this.popupButton = this.createPopupButton();
        this.popupDialog = null;
        this.getChildren().add((Object)this.textField);
        this.getChildren().add((Object)this.popupButton);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.control.selectedDateProperty().addListener((observableValue, calendarDate, calendarDate2) -> {
            this.control.pageDateProperty().setValue(calendarDate2 == null ? this.control.today() : calendarDate2);
            if (!this.valueInChange) {
                this.selectionInChange = true;
                this.valuePropertyInt.setValue(calendarDate2);
                this.selectionInChange = false;
                if (!this.committingText) {
                    this.hidePopup();
                }
            }
        });
        this.valuePropertyInt.addListener((observableValue, calendarDate, calendarDate2) -> {
            this.valueInChange = true;
            if (!this.committingText) {
                this.errorProperty.setValue(null);
                if (!this.selectionInChange) {
                    this.control.selectedDateProperty().setValue(calendarDate2);
                }
                this.updateTextField();
            }
            this.valuePropertyExt.setValue(calendarDate2);
            this.valueInChange = false;
        });
        this.valuePropertyExt.addListener((observableValue, calendarDate, calendarDate2) -> {
            if (calendarDate2 != null && (calendarDate2.isBefore(this.control.minDateProperty().get()) || calendarDate2.isAfter(this.control.maxDateProperty().get()))) {
                throw new IllegalArgumentException("Out of range: " + calendarDate2);
            }
            if (!this.valueInChange) {
                this.valuePropertyInt.setValue(calendarDate2);
            }
        });
        this.errorProperty.addListener(observable -> {
            if (this.errorProperty.getValue() == null) {
                this.textField.getStyleClass().remove((Object)CSS_CALENDAR_EDITOR_ERROR);
                this.textField.setTooltip(null);
            } else {
                if (!this.textField.getStyleClass().contains((Object)CSS_CALENDAR_EDITOR_ERROR)) {
                    this.textField.getStyleClass().add((Object)CSS_CALENDAR_EDITOR_ERROR);
                }
                this.textField.setTooltip(new Tooltip(this.errorProperty.getValue()));
            }
        });
        this.textField.promptTextProperty().bind((ObservableValue)new PromptBinding());
        this.textField.minHeightProperty().bind((ObservableValue)this.minHeightProperty());
        this.textField.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        this.textField.textProperty().addListener((observableValue, string, string2) -> {
            if (!this.textInChange) {
                if (string2 == null || string2.isEmpty()) {
                    this.committingText = true;
                    this.control.selectedDateProperty().setValue(null);
                    this.errorProperty.setValue(null);
                    this.committingText = false;
                } else {
                    this.textField.setTooltip(null);
                }
            }
        });
        this.textField.focusedProperty().addListener(observable -> {
            if (!this.textField.isFocused()) {
                this.commitTextInput();
            }
        });
        this.textField.setOnAction(actionEvent -> {
            this.hidePopup();
            this.popupButton.requestFocus();
            if (this.textField.isFocused()) {
                this.commitTextInput();
            }
        });
        this.control.localeProperty().addListener(observable -> this.updateTextField());
    }

    public static CalendarPicker<PlainDate> gregorianWithSystemDefaults() {
        return CalendarPicker.gregorian(Locale.getDefault(Locale.Category.FORMAT), () -> SystemClock.inLocalView().today());
    }

    public static CalendarPicker<PlainDate> gregorian(Locale locale, Supplier<PlainDate> supplier) {
        return CalendarPicker.create(PlainDate.axis(), new FXCalendarSystemIso8601(), locale, supplier);
    }

    public static CalendarPicker<CopticCalendar> copticWithSystemDefaults() {
        return CalendarPicker.coptic(Locale.getDefault(Locale.Category.FORMAT), () -> (CopticCalendar)SystemClock.inLocalView().now((Chronology)CopticCalendar.axis()));
    }

    public static CalendarPicker<CopticCalendar> coptic(Locale locale, Supplier<CopticCalendar> supplier) {
        return CalendarPicker.create(CopticCalendar.axis(), new FXCalendarSystemCoptic(), locale, supplier);
    }

    public static CalendarPicker<EthiopianCalendar> ethiopianWithSystemDefaults() {
        return CalendarPicker.ethiopian(Locale.getDefault(Locale.Category.FORMAT), () -> (EthiopianCalendar)SystemClock.inLocalView().now((Chronology)EthiopianCalendar.axis()));
    }

    public static CalendarPicker<EthiopianCalendar> ethiopian(Locale locale, Supplier<EthiopianCalendar> supplier) {
        return CalendarPicker.create(EthiopianCalendar.axis(), new FXCalendarSystemEthiopian(), locale, supplier);
    }

    public static CalendarPicker<HebrewCalendar> hebrewWithSystemDefaults() {
        return CalendarPicker.hebrew(Locale.getDefault(Locale.Category.FORMAT), () -> (HebrewCalendar)SystemClock.inLocalView().now((Chronology)HebrewCalendar.axis()));
    }

    public static CalendarPicker<HebrewCalendar> hebrew(Locale locale, Supplier<HebrewCalendar> supplier) {
        return CalendarPicker.create(HebrewCalendar.axis(), new FXCalendarSystemHebrew(), locale, supplier);
    }

    public static CalendarPicker<HijriCalendar> hijriWithSystemDefaults(VariantSource variantSource) {
        return CalendarPicker.hijri(variantSource, Locale.getDefault(Locale.Category.FORMAT), () -> (HijriCalendar)SystemClock.inLocalView().now(HijriCalendar.family(), variantSource, StartOfDay.EVENING).toDate());
    }

    public static CalendarPicker<HijriCalendar> hijri(VariantSource variantSource, Locale locale, Supplier<HijriCalendar> supplier) {
        return CalendarPicker.create(HijriCalendar.family(), new FXCalendarSystemHijri(variantSource.getVariant()), locale, supplier);
    }

    public static CalendarPicker<JulianCalendar> julianWithSystemDefaults() {
        return CalendarPicker.julian(Locale.getDefault(Locale.Category.FORMAT), () -> (JulianCalendar)SystemClock.inLocalView().now((Chronology)JulianCalendar.axis()));
    }

    public static CalendarPicker<JulianCalendar> julian(Locale locale, Supplier<JulianCalendar> supplier) {
        return CalendarPicker.create(JulianCalendar.axis(), new FXCalendarSystemJulian(), locale, supplier);
    }

    public static CalendarPicker<MinguoCalendar> minguoWithSystemDefaults() {
        return CalendarPicker.minguo(Locale.getDefault(Locale.Category.FORMAT), () -> (MinguoCalendar)SystemClock.inLocalView().now((Chronology)MinguoCalendar.axis()));
    }

    public static CalendarPicker<MinguoCalendar> minguo(Locale locale, Supplier<MinguoCalendar> supplier) {
        return CalendarPicker.create(MinguoCalendar.axis(), new FXCalendarSystemMinguo(), locale, supplier);
    }

    public static CalendarPicker<PersianCalendar> persianWithSystemDefaults() {
        return CalendarPicker.persian(Locale.getDefault(Locale.Category.FORMAT), () -> (PersianCalendar)SystemClock.inLocalView().now((Chronology)PersianCalendar.axis()));
    }

    public static CalendarPicker<PersianCalendar> persian(Locale locale, Supplier<PersianCalendar> supplier) {
        return CalendarPicker.create(PersianCalendar.axis(), new FXCalendarSystemPersian(), locale, supplier);
    }

    public static CalendarPicker<ThaiSolarCalendar> thaiWithSystemDefaults() {
        return CalendarPicker.thai(Locale.getDefault(Locale.Category.FORMAT), () -> (ThaiSolarCalendar)SystemClock.inLocalView().now((Chronology)ThaiSolarCalendar.axis()));
    }

    public static CalendarPicker<ThaiSolarCalendar> thai(Locale locale, Supplier<ThaiSolarCalendar> supplier) {
        return CalendarPicker.create(ThaiSolarCalendar.axis(), new FXCalendarSystemThai(), locale, supplier);
    }

    public ObjectProperty<Locale> localeProperty() {
        return this.control.localeProperty();
    }

    public ObjectProperty<T> valueProperty() {
        return this.valuePropertyExt;
    }

    public ReadOnlyStringProperty errorProperty() {
        return this.errorProperty;
    }

    public ReadOnlyObjectProperty<ChronoFormatter<T>> dateFormatProperty() {
        return this.formatProperty;
    }

    public ReadOnlyStringProperty promptTextProperty() {
        return this.promptProperty;
    }

    public ReadOnlyObjectProperty<T> minDateProperty() {
        return this.control.minDateProperty();
    }

    public ReadOnlyObjectProperty<T> maxDateProperty() {
        return this.control.maxDateProperty();
    }

    public BooleanProperty showWeeksProperty() {
        return this.control.showWeeksProperty();
    }

    public BooleanProperty showInfoLabelProperty() {
        return this.control.showInfoLabelProperty();
    }

    public ReadOnlyObjectProperty<Duration> lengthOfAnimationsProperty() {
        return this.control.lengthOfAnimationsProperty();
    }

    public ObjectProperty<CellCustomizer<T>> cellCustomizerProperty() {
        return this.control.cellCustomizerProperty();
    }

    public void setLocale(Locale locale) {
        this.localeProperty().setValue((Object)locale);
    }

    public void setValue(T t) {
        this.valuePropertyExt.setValue(t);
    }

    public void setDateFormat(ChronoFormatter<T> chronoFormatter) {
        if (chronoFormatter == null) {
            throw new NullPointerException("Missing date format.");
        }
        this.formatProperty.setValue(chronoFormatter);
    }

    public void setPromptText(String string) {
        if (string == null) {
            throw new NullPointerException("Missing prompt text.");
        }
        this.promptProperty.setValue(string);
    }

    public void setMinDate(T t) {
        if (t == null) {
            throw new NullPointerException("Missing minimum date.");
        }
        this.control.minDateProperty().setValue(t);
    }

    public void setMaxDate(T t) {
        if (t == null) {
            throw new NullPointerException("Missing maximum date.");
        }
        this.control.maxDateProperty().setValue(t);
    }

    public void setShowWeeks(boolean bl) {
        this.showWeeksProperty().set(bl);
    }

    public void setShowInfoLabel(boolean bl) {
        this.showInfoLabelProperty().set(bl);
    }

    public void setLengthOfAnimations(Duration duration) {
        this.control.lengthOfAnimationsProperty().set((Object)(duration == null ? Duration.ZERO : duration));
    }

    public void setCellCustomizer(CellCustomizer<T> cellCustomizer) {
        this.cellCustomizerProperty().set(cellCustomizer);
    }

    private static <D extends CalendarVariant<D>> CalendarPicker<D> create(CalendarFamily<D> calendarFamily, FXCalendarSystem<D> fXCalendarSystem, Locale locale, Supplier<D> supplier) {
        CalendarPicker<D> calendarPicker = new CalendarPicker<D>(fXCalendarSystem, locale, supplier, calendarFamily, fXCalendarSystem.getChronologicalMinimum(), fXCalendarSystem.getChronologicalMaximum());
        calendarPicker.setShowInfoLabel(true);
        return calendarPicker;
    }

    private static <U, T extends Calendrical<U, T>> CalendarPicker<T> create(TimeAxis<U, T> timeAxis, FXCalendarSystem<T> fXCalendarSystem, Locale locale, Supplier<T> supplier) {
        CalendarPicker<CalendarDate> calendarPicker = new CalendarPicker<CalendarDate>((FXCalendarSystem<CalendarDate>)fXCalendarSystem, locale, (Supplier<CalendarDate>)supplier, (Chronology<CalendarDate>)timeAxis, (CalendarDate)timeAxis.getMinimum(), (CalendarDate)timeAxis.getMaximum());
        calendarPicker.setShowInfoLabel(timeAxis != PlainDate.axis());
        return calendarPicker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitTextInput() {
        try {
            this.committingText = true;
            ParseLog parseLog = new ParseLog();
            String string = this.textField.getText();
            if (string == null || string.trim().isEmpty()) {
                this.control.selectedDateProperty().setValue(null);
                this.errorProperty.setValue(null);
            } else {
                CalendarDate calendarDate = (CalendarDate)this.getFormat().parse((CharSequence)string, parseLog);
                if (parseLog.isError()) {
                    this.control.selectedDateProperty().setValue(null);
                    this.errorProperty.setValue("[error-position=" + parseLog.getErrorIndex() + "] " + parseLog.getErrorMessage());
                } else if (calendarDate.isBefore(this.control.minDateProperty().get()) || calendarDate.isAfter(this.control.maxDateProperty().get())) {
                    this.control.selectedDateProperty().setValue(null);
                    this.errorProperty.setValue("[error] Out of range: " + calendarDate);
                } else {
                    this.control.selectedDateProperty().setValue((Object)calendarDate);
                    this.errorProperty.setValue(null);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            this.control.selectedDateProperty().setValue(null);
            this.errorProperty.setValue("[error] " + runtimeException.getMessage());
        }
        finally {
            this.updateTextField();
            this.committingText = false;
        }
    }

    private void updateTextField() {
        if (this.errorProperty.getValue() == null) {
            this.textInChange = true;
            CalendarDate calendarDate = (CalendarDate)this.valuePropertyInt.getValue();
            if (calendarDate == null) {
                this.textField.setText("");
            } else {
                String string = this.getFormat().format((Object)calendarDate);
                if (!this.textField.getText().equals(string)) {
                    this.textField.setText(string);
                }
            }
            this.textInChange = false;
        }
    }

    private ChronoFormatter<T> getFormat() {
        ChronoFormatter chronoFormatter;
        if (this.formatProperty.getValue() == null) {
            Locale locale = (Locale)this.control.localeProperty().get();
            if (locale == null) {
                locale = Locale.ROOT;
            }
            String string = this.getStdFormatPattern(locale);
            chronoFormatter = ChronoFormatter.ofPattern((String)string, (PatternType)PatternType.CLDR, (Locale)locale, this.control.chronology()).with(Leniency.STRICT);
            if (this.calsys.getVariantSource().isPresent()) {
                chronoFormatter = chronoFormatter.withCalendarVariant(this.calsys.getVariantSource().get());
            }
        } else {
            chronoFormatter = (ChronoFormatter)this.formatProperty.getValue();
            if (!((Leniency)chronoFormatter.getAttributes().get(Attributes.LENIENCY, (Object)Leniency.SMART)).isStrict()) {
                chronoFormatter = chronoFormatter.with(Leniency.STRICT);
            }
        }
        return chronoFormatter;
    }

    private String getStdFormatPattern(Locale locale) {
        String string = this.control.chronology().getFormatPattern(FormatStyle.SHORT, locale);
        if (string.contains("yy") && !string.contains("yyy")) {
            string = string.replace("yy", "yyyy");
        }
        return string;
    }

    private void showPopup() {
        Object object;
        AnimatedPopup animatedPopup;
        if (this.popupDialog == null) {
            animatedPopup = new AnimatedPopup();
            animatedPopup.setAutoHide(true);
            animatedPopup.setAutoFix(true);
            animatedPopup.setHideOnEscape(true);
            object = new CalendarContent<T>(this.control, this.calsys);
            object.getStylesheets().setAll((Collection)this.getStylesheets());
            this.getStylesheets().addListener(arg_0 -> this.lambda$showPopup$17((CalendarContent)((Object)object), arg_0));
            animatedPopup.getContent().add(object);
            this.popupDialog = animatedPopup;
        }
        animatedPopup = ((Node)this.popupDialog.getContent().get(0)).getBoundsInLocal();
        object = this.localToScene(this.getBoundsInLocal());
        Scene scene = this.getScene();
        Window window = scene.getWindow();
        double d = animatedPopup.getMinX() + object.getMinX() + scene.getX() + window.getX();
        double d2 = animatedPopup.getMinY() + object.getHeight() + object.getMinY() + scene.getY() + window.getY();
        this.popupDialog.show((Node)this, d, d2);
        window.setOnCloseRequest(((AnimatedPopup)((Object)AnimatedPopup.class.cast(this.popupDialog))).getClosingHandler());
    }

    private void hidePopup() {
        if (this.popupDialog != null) {
            this.popupDialog.hide();
        }
    }

    private Button createPopupButton() {
        Button button = new Button();
        button.getStyleClass().add((Object)CSS_CALENDAR_DIALOG_START);
        ImageView imageView = new ImageView("/net/time4j/ui/javafx/calendar32.png");
        imageView.setFitHeight(16.0);
        imageView.setPreserveRatio(true);
        button.setGraphic((Node)imageView);
        button.setOnAction(actionEvent -> this.showPopup());
        return button;
    }

    private /* synthetic */ void lambda$showPopup$17(CalendarContent calendarContent, Observable observable) {
        calendarContent.getStylesheets().setAll((Collection)this.getStylesheets());
    }

    private static class PopupInterpolator
    extends Interpolator {
        private PopupInterpolator() {
        }

        protected double curve(double d) {
            double d2 = 1.70158;
            double d3 = 1.0 - d;
            return 1.0 - d3 * d3 * ((d2 + 1.0) * d3 - d2);
        }
    }

    private class AnimatedPopup
    extends Popup {
        private final FadeTransition hideFadeTransition;
        private final ScaleTransition hideScaleTransition;
        private final FadeTransition showFadeTransition;
        private final ScaleTransition showScaleTransition;
        private final EventHandler<WindowEvent> closingHandler;

        AnimatedPopup() {
            PopupInterpolator popupInterpolator = new PopupInterpolator();
            this.showFadeTransition = new FadeTransition(Duration.seconds((double)0.2), (Node)this.getScene().getRoot());
            this.showFadeTransition.setFromValue(0.0);
            this.showFadeTransition.setToValue(1.0);
            this.showFadeTransition.setInterpolator((Interpolator)popupInterpolator);
            this.showScaleTransition = new ScaleTransition(Duration.seconds((double)0.2), (Node)this.getScene().getRoot());
            this.showScaleTransition.setFromX(0.8);
            this.showScaleTransition.setFromY(0.8);
            this.showScaleTransition.setToY(1.0);
            this.showScaleTransition.setToX(1.0);
            this.showScaleTransition.setInterpolator((Interpolator)popupInterpolator);
            this.hideFadeTransition = new FadeTransition(Duration.seconds((double)0.3), (Node)this.getScene().getRoot());
            this.hideFadeTransition.setFromValue(1.0);
            this.hideFadeTransition.setToValue(0.0);
            this.hideFadeTransition.setInterpolator((Interpolator)popupInterpolator);
            this.hideScaleTransition = new ScaleTransition(Duration.seconds((double)0.3), (Node)this.getScene().getRoot());
            this.hideScaleTransition.setFromX(1.0);
            this.hideScaleTransition.setFromY(1.0);
            this.hideScaleTransition.setToY(0.8);
            this.hideScaleTransition.setToX(0.8);
            this.hideScaleTransition.setInterpolator((Interpolator)popupInterpolator);
            this.hideScaleTransition.setOnFinished(actionEvent -> {
                if (AnimatedPopup.super.isShowing()) {
                    AnimatedPopup.super.hide();
                }
            });
            this.closingHandler = windowEvent -> {
                Popup popup = CalendarPicker.this.popupDialog;
                if (popup != null) {
                    popup.getOwnerWindow().removeEventFilter(WindowEvent.WINDOW_CLOSE_REQUEST, this.getClosingHandler());
                    if (popup.isShowing()) {
                        popup.hide();
                        windowEvent.consume();
                    }
                    CalendarPicker.this.popupDialog = null;
                }
            };
        }

        public void show() {
            super.show();
            if (this.showFadeTransition.getStatus() != Animation.Status.RUNNING) {
                this.showFadeTransition.playFromStart();
                this.showScaleTransition.playFromStart();
            }
        }

        public void hide() {
            if (this.isShowing()) {
                if (!this.getOwnerWindow().isShowing()) {
                    this.hideFadeTransition.stop();
                    this.hideScaleTransition.stop();
                } else if (this.hideFadeTransition.getStatus() != Animation.Status.RUNNING) {
                    this.hideFadeTransition.playFromStart();
                    this.hideScaleTransition.playFromStart();
                }
            }
        }

        private EventHandler<WindowEvent> getClosingHandler() {
            return this.closingHandler;
        }
    }

    private class PromptBinding
    extends StringBinding {
        PromptBinding() {
            this.bind(new Observable[]{CalendarPicker.this.control.localeProperty(), CalendarPicker.this.formatProperty, CalendarPicker.this.promptProperty});
        }

        protected String computeValue() {
            if (CalendarPicker.this.promptProperty.getValue() != null) {
                return CalendarPicker.this.promptProperty.getValue();
            }
            if (CalendarPicker.this.formatProperty.getValue() == null) {
                Locale locale = (Locale)CalendarPicker.this.control.localeProperty().get();
                if (locale == null) {
                    locale = Locale.ROOT;
                }
                return CalendarPicker.this.getStdFormatPattern(locale);
            }
            return "";
        }
    }
}

